"""

Revision ID: 5b10ee7604c1
Revises: b76079e9845f
Create Date: 2025-07-13 11:59:59.351417

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "5b10ee7604c1"
down_revision: Union[str, None] = "b76079e9845f"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("sma_50_above_sma_200", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("price_above_sma_50", sa.Date(), nullable=True))
        batch_op.create_index(
            "ix_analysis_price_above_sma_50", ["price_above_sma_50"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_sma_50_above_sma_200", ["sma_50_above_sma_200"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_sma_50_above_sma_200")
        batch_op.drop_index("ix_analysis_price_above_sma_50")
        batch_op.drop_column("price_above_sma_50")
        batch_op.drop_column("sma_50_above_sma_200")
