"""

Revision ID: ae444f338124
Revises: d0e58e050845
Create Date: 2025-08-07 11:07:48.169941

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "ae444f338124"
down_revision: Union[str, None] = "d0e58e050845"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("consensus", sqlmodel.sql.sqltypes.AutoString(), nullable=True)
        )
        batch_op.add_column(
            sa.Column(
                "recommendation", sqlmodel.sql.sqltypes.AutoString(), nullable=True
            )
        )
        batch_op.add_column(sa.Column("high_price_target", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("low_price_target", sa.Float(), nullable=True))
        batch_op.add_column(
            sa.Column("reason", sqlmodel.sql.sqltypes.AutoString(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("explanation", sqlmodel.sql.sqltypes.AutoString(), nullable=True)
        )
        batch_op.add_column(sa.Column("news_date", sa.DateTime(), nullable=True))
        batch_op.add_column(sa.Column("news_summary", sa.JSON(), nullable=True))
        batch_op.alter_column(
            "summary",
            existing_type=sa.VARCHAR(),
            type_=sa.JSON(),
            existing_nullable=True,
        )
        batch_op.create_index("ix_analysis_consensus", ["consensus"], unique=False)
        batch_op.create_index("ix_analysis_explanation", ["explanation"], unique=False)
        batch_op.create_index(
            "ix_analysis_high_price_target", ["high_price_target"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_low_price_target", ["low_price_target"], unique=False
        )
        batch_op.create_index("ix_analysis_news_date", ["news_date"], unique=False)
        batch_op.create_index(
            "ix_analysis_news_summary", ["news_summary"], unique=False
        )
        batch_op.create_index("ix_analysis_reason", ["reason"], unique=False)
        batch_op.create_index(
            "ix_analysis_recommendation", ["recommendation"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_recommendation")
        batch_op.drop_index("ix_analysis_reason")
        batch_op.drop_index("ix_analysis_news_summary")
        batch_op.drop_index("ix_analysis_news_date")
        batch_op.drop_index("ix_analysis_low_price_target")
        batch_op.drop_index("ix_analysis_high_price_target")
        batch_op.drop_index("ix_analysis_explanation")
        batch_op.drop_index("ix_analysis_consensus")
        batch_op.alter_column(
            "summary",
            existing_type=sa.JSON(),
            type_=sa.VARCHAR(),
            existing_nullable=True,
        )
        batch_op.drop_column("news_summary")
        batch_op.drop_column("news_date")
        batch_op.drop_column("explanation")
        batch_op.drop_column("reason")
        batch_op.drop_column("low_price_target")
        batch_op.drop_column("high_price_target")
        batch_op.drop_column("recommendation")
        batch_op.drop_column("consensus")

    # ### end Alembic commands ###
