"""

Revision ID: b36c310f49ec
Revises: 260fcff7212e
Create Date: 2025-08-14 22:39:38.207093

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "b36c310f49ec"
down_revision: Union[str, None] = "cc28171c21a4"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "openai",
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("news_date", sa.Date(), nullable=False),
        sa.Column("high_price_target", sa.Float(), nullable=True),
        sa.Column("low_price_target", sa.Float(), nullable=True),
        sa.Column("recent_news", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("recommendation", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("explanation", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "news_date"),
    )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("openai")
    # ### end Alembic commands ###
