"""

Revision ID: c828e29e1105
Revises: b36c310f49ec
Create Date: 2025-08-15 17:57:09.541454

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "c828e29e1105"
down_revision: Union[str, None] = "b36c310f49ec"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("oai_high_price_target", sa.Float(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("oai_low_price_target", sa.Float(), nullable=True)
        )
        batch_op.add_column(sa.Column("oai_news_date", sa.DateTime(), nullable=True))
        batch_op.add_column(
            sa.Column(
                "oai_recent_news", sqlmodel.sql.sqltypes.AutoString(), nullable=True
            )
        )
        batch_op.add_column(
            sa.Column(
                "oai_recommendation", sqlmodel.sql.sqltypes.AutoString(), nullable=True
            )
        )
        batch_op.add_column(
            sa.Column(
                "oai_explanation", sqlmodel.sql.sqltypes.AutoString(), nullable=True
            )
        )
        batch_op.create_index(
            "ix_analysis_oai_explanation", ["oai_explanation"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_oai_high_price_target", ["oai_high_price_target"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_oai_low_price_target", ["oai_low_price_target"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_oai_news_date", ["oai_news_date"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_oai_recent_news", ["oai_recent_news"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_oai_recommendation", ["oai_recommendation"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_oai_recommendation")
        batch_op.drop_index("ix_analysis_oai_recent_news")
        batch_op.drop_index("ix_analysis_oai_news_date")
        batch_op.drop_index("ix_analysis_oai_low_price_target")
        batch_op.drop_index("ix_analysis_oai_high_price_target")
        batch_op.drop_index("ix_analysis_oai_explanation")
        batch_op.drop_column("oai_explanation")
        batch_op.drop_column("oai_recommendation")
        batch_op.drop_column("oai_recent_news")
        batch_op.drop_column("oai_news_date")
        batch_op.drop_column("oai_low_price_target")
        batch_op.drop_column("oai_high_price_target")

    # ### end Alembic commands ###
