"""

Revision ID: cc28171c21a4
Revises: 260fcff7212e
Create Date: 2025-08-15 17:04:59.467407

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "cc28171c21a4"
down_revision: Union[str, None] = "260fcff7212e"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("adx_14", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("adx_14_overbought", sa.Date(), nullable=True))
        batch_op.create_index("ix_analysis_adx_14", ["adx_14"], unique=False)
        batch_op.create_index(
            "ix_analysis_adx_14_overbought", ["adx_14_overbought"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_adx_14_overbought")
        batch_op.drop_index("ix_analysis_adx_14")
        batch_op.drop_column("adx_14_overbought")
        batch_op.drop_column("adx_14")

    # ### end Alembic commands ###
