"""

Revision ID: fc191121f522
Revises: 49c83f9eb5ac
Create Date: 2025-07-06 17:33:02.231374

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "fc191121f522"
down_revision: Union[str, None] = "49c83f9eb5ac"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("lower_than_200_day_high", sa.Date(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("lower_than_20_day_high", sa.Date(), nullable=True)
        )
        batch_op.add_column(sa.Column("rsi_neutral", sa.Date(), nullable=True))
        batch_op.create_index(
            "ix_analysis_lower_than_200_day_high",
            ["lower_than_200_day_high"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_lower_than_20_day_high",
            ["lower_than_20_day_high"],
            unique=False,
        )
        batch_op.create_index("ix_analysis_rsi_neutral", ["rsi_neutral"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_rsi_neutral")
        batch_op.drop_index("ix_analysis_lower_than_20_day_high")
        batch_op.drop_index("ix_analysis_lower_than_200_day_high")
        batch_op.drop_column("rsi_neutral")
        batch_op.drop_column("lower_than_20_day_high")
        batch_op.drop_column("lower_than_200_day_high")

    # ### end Alembic commands ###
