# MDANSE 

## MDANSE Python Module

This is the module containing the command-line utilities and libraries of the
Molecular Dynamics Analysis for Neutron Scattering Experiments (MDANSE) software package.

If you would like to use a graphical user interface, you will need to install also the MDANSE_GUI package.

## Molecular Dynamics Analysis for Neutron Scattering Experiments

MDANSE is a Python package designed for analysing molecular dynamics (MD)
trajectories. One of its functions is calculating the expected results
of neutron scattering experiments. The results can be directly compared with neutron scattering experiment results, particularly inelastic and quasi-elastic neutron scattering 
spectroscopies.

MDANSE contains a family of converters which can be used to transform MD
trajectory files into HDF5 files (.MDT format). These are then used as input
for MDANSE analysis runs. The analysis results can be saved as HDF5 files,
or in text format.

While the MDANSE package is sufficient to perform the analysis, we recommend
to install the MDANSE_GUI package as well, which makes it easier to create
analysis scripts with valid input parameters, and can visualise both the
trajectory and the analysis results.

This project is built on the development published previously: \
G. Goret, B. Aoun, E. Pellegrini, "MDANSE: An Interactive Analysis Environment for Molecular Dynamics Simulations", 
J Chem Inf Model. 57(1):1-5 (2017).

## Version information

This is the second release candidate of MDANSE 2.0.0. The set of features it
contains will not change by the time the full release has been made. However,
there still may be some problems with the code at this stage that need to be
identified and corrected. Please help us develop MDANSE by reporting any
problems you experience when using the code. The preferred way of reporting
problems is by adding them to the
[GitHub issue tracker](https://github.com/ISISNeutronMuon/MDANSE/issues).
You can also send a message to MDANSE-help@stfc.ac.uk to get in touch
with MDANSE developers.

## Quick start: installation

We recommend that you install MDANSE in a Python virtual environment. You can
create a virtual environment named mdanse_env by typing
```
python3 -m venv mdanse_env
```

To activate your virtual environment, type
```
source mdanse_env/bin/activate
```
in a bash console, or
```
mdanse_end\Scripts\activate.bat
```
if you are using cmd.exe on Windows.

While your virtual environment is active, you can install MDANSE:
```
pip install MDANSE
```
which will allow you to execute MDANSE scripts, as long as your
virtual environment is active. (This means that you will have to
activate it when you start a new shell.)

If you experience problems with the installation, you may want to upgrade pip
```
pip install --upgrade pip
```
and try again.

### Optional dependencies

Most users prefer to install [MDANSE_GUI](https://pypi.org/project/MDANSE-GUI/) alongside MDANSE,
and use the GUI to convert, analyse and view trajectories and to visualise results.

Users who prefer running MDANSE scripts in the command line can include optional dependencies
by installing MDANSE with
```
pip install mdanse[cli]
```
This will install [tqdm](https://pypi.org/project/tqdm/), which will then be used to display
a progress bar when an MDANSE script is running in the shell.

## Quick start: workflow

The typical workflow of MDANSE:

1. Convert a trajectory from the file format generated by an MD simulation
   software into the MDANSE trajectory format,
2. Load the converted trajectory into MDANSE,
3. Perform an analysis,
4. Check the results with the plotter.

The most complete user documentation of MDANSE can be found on [our Read the Docs page](https://mdanse.readthedocs.io/en/protos).

Other information including example scripts can be found on the [MDANSE website](https://www.isis.stfc.ac.uk/Pages/MDANSEproject.aspx) 

## What can MDANSE do?

Firstly, MDANSE can read the output of many MD simulation packages.
It does this by providing converters for different file formats
into an .MDT file (HDF format), which is then used for all
calculations. The following MD packages are supported:

- CASTEP
- CHARMM
- CP2K
- DCD
- DFTB
- DL_POLY
- Forcite
- Gromacs
- LAMMPS
- NAMD
- VASP
- XPLOR
- ASE

The converted trajectory can then be loaded into MDANSE, where
it can be visualised via the Molecular Viewer and animated.
Then, various properties can be calculated, which can be
compared with neutron (or, for some analysis types, with X-ray)
experimental data, or used as a prediction of results of a
potential experiment. The following properties can be computed:

<details><summary>Dynamics</summary><ul>
<li>Density of States</li>
<li>Mean Square Displacement</li>
<li>Position Autocorrelation Function</li>
<li>Position Power Spectrum</li>
<li>Reorientational Time Correlation Function</li>
<li>Root Mean Square Deviation</li>
<li>Root Mean Square Fluctuation</li>
<li>van Hove function (self)</li>
<li>van Hove function (distinct)</li>
<li>Velocity Autocorrelation Function</li>
</ul></details>

<details><summary>Infrared</summary><ul>
<li>Dipole Autocorrelation Function</li>
<li>Infrared</li>
</ul></details>

<details><summary>Scattering</summary><ul>
<li>Current Correlation Function</li>
<li>Dynamic Coherent Structure Factor</li>
<li>Dynamic Incoherent Structure Factor</li>
<li>Elastic Incoherent Structure Factor</li>
<li>Gaussian Dynamic Incoherent Structure Factor</li>
<li>Neutron Dynamic Total Structure Factor</li>
<li>Scattering Length Density Profile</li>
<li>Static Structure Factor</li>
<li>Structure Factor from Scattering Function</li>
<li>X-Ray Static Structure Factor</li>
</ul></details>

<details><summary>Structure</summary><ul>
<li>Area Per Molecule</li>
<li>Average Structure</li>
<li>Coordination Number</li>
<li>Eccentricity</li>
<li>Molecular Trace</li>
<li>Pair Distribution Function</li>
<li>Radius of Gyration</li>
<li>Solvent Accessible Surface</li>
<li>Voronoi (volume per atom)</li>
</ul></details>

<details><summary>Thermodynamics</summary><ul>
<li>Density</li>
<li>Temperature</li>
</ul></details>

<details><summary>Trajectory</summary><ul>
<li>Center of Masses Trajectory</li>
<li>Trajectory Filter</li>
</ul></details>

Each of these analyses can be controlled using a number of parameters.
For example, the user can select a subset of trajectory frames or a
subset of atoms on which to perform the calculation, or specified atoms
can be substituted with different elements/isotopes. Finally, their results
can be saved in an MDA file (HDF5 format), or a set of DAT files
(text format), and those can then be plotted directly in MDANSE.

More detailed information on how MDANSE works, what it can do,
and the science can all be found on
[our Read the Docs page](https://mdanse.readthedocs.io/en/protos).

## Citing MDANSE

If you used MDANSE in your research, please cite the following paper:

>MDANSE: An Interactive Analysis Environment for Molecular Dynamics Simulations.
G. Goret, B. Aoun, E. Pellegrini. J Chem Inf Model. (2017) 57(1):1-5.

## License

MDANSE is licensed under GPL-3.0. See
[LICENSE](https://github.com/ISISNeutronMuon/MDANSE/blob/protos/LICENSE)
for more information.

## Acknowledgements

MDANSE started as a fork of [version 3 of the nMOLDYN program](https://github.com/khinsen/nMOLDYN3).
nMOLDYN was originally developed by Gerald Kneller in 1995 and
subsequently also by Konrad Hinsen, Tomasz Rog, Krzysztof Murzyn,
Slawomir Stachura, and Eric Pellegrini. MDANSE includes most of the
code of nMOLDYN3, and also code from the libraries
[MMTK](https://github.com/khinsen/MMTK),
[ScientificPython](https://github.com/khinsen/ScientificPython)
and [MDTraj](https://github.com/mdtraj/mdtraj).

For more information see:

>nMoldyn 3: Using task farming for a parallel spectroscopy-oriented analysis of molecular dynamics simulations.
K. Hinsen, E. Pellegrini, S. Stachura, G.R. Kneller J. Comput. Chem. (2012) 33:2043-2048 [https://doi.org/10.1002/jcc.23035][https://doi.org/10.1002/jcc.23035]. 

We are grateful to all the people who have helped in some way or
another to improve nMOLDYN and/or MDANSE along those years. 
Apart from the main developers mentioned above, we would like
to acknowledge explicitly the contributions done in the past 
by Bachir Aoun, Vania Calandrini, Paolo Calligari, Gael Goret,
Remi Perenon and Rastislav Turanyi.

The MDANSE project is supported by ISIS Neutron and Muon Source, Science
and Technology Facilities Council, UKRI.
In the past, it was supported by Ada Lovelace Centre
and the Institut Laue-Langevin (Grenoble, France). 
Past financial support from the French Agence Nationale de la Recherche (ANR) through contracts 
No. ANR-2010-COSI-001-01 and ANR-06-CIS6-012-01, and the Horizon 2020 Framework Programme of 
the European Union under project number 654000 is also acknowledged.

## Joining the project

MDANSE is currently maintained and developed by software developers
from ISIS and ILL, but we are fully open to new collaborators who
would like to contribute code, documentation, tutorials or usage examples.
If you want to join the project contact:

>Dr. Sanghamitra Mukhopadhyay (sanghamitra.mukhopadhyay@stfc.ac.uk) \
ISIS Neutron and Muon Source \
Rutherford Appleton Laboratory \
Didcot, UK

## Software Inquiries

You are welcome to use the
[issue tracker](https://github.com/ISISNeutronMuon/MDANSE/issues)
to submit ideas for
extending the MDANSE code or to report problems you encountered.
However, if you prefer to contact the MDANSE developers directly,
you can send us a message:
>MDANSE Help (MDANSE-help@stfc.ac.uk)
