"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from attio import errors, models, utils
from attio._hooks import HookContext
from attio.types import OptionalNullable, UNSET
from attio.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Dict, List, Mapping, Optional, Union


class Entries(BaseSDK):
    r"""Entries are elements in a list that reference a single parent record. Entries contain their own data from attributes defined on the list and also data from their parent record. See our [objects and lists guide](/docs/objects-and-lists) for more information."""

    def post_v2_lists_list_entries_query(
        self,
        *,
        list_id: str,
        filter_: Optional[Dict[str, Any]] = None,
        sorts: Optional[
            Union[
                List[models.PostV2ListsListEntriesQuerySortUnion],
                List[models.PostV2ListsListEntriesQuerySortUnionTypedDict],
            ]
        ] = None,
        limit: Optional[float] = None,
        offset: Optional[float] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.PostV2ListsListEntriesQueryData]:
        r"""List entries

        Lists entries in a given list, with the option to filter and sort results.

        Required scopes: `list_entry:read`, `list_configuration:read`.

        :param list_id:
        :param filter_: An object used to filter results to a subset of results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting).
        :param sorts: An object used to sort results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting).
        :param limit: The maximum number of results to return. Defaults to 500. See the [full guide to pagination here](/rest-api/how-to/pagination).
        :param offset: The number of results to skip over before returning. Defaults to 0. See the [full guide to pagination here](/rest-api/how-to/pagination).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PostV2ListsListEntriesQueryRequest(
            list_id=list_id,
            request_body=models.PostV2ListsListEntriesQueryRequestBody(
                filter_=filter_,
                sorts=utils.get_pydantic_model(
                    sorts, Optional[List[models.PostV2ListsListEntriesQuerySortUnion]]
                ),
                limit=limit,
                offset=offset,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v2/lists/{list}/entries/query",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PostV2ListsListEntriesQueryRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="post_/v2/lists/{list}/entries/query",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PostV2ListsListEntriesQueryResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2ListsListEntriesQueryNotFoundErrorData, http_res
            )
            raise errors.PostV2ListsListEntriesQueryNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def post_v2_lists_list_entries_query_async(
        self,
        *,
        list_id: str,
        filter_: Optional[Dict[str, Any]] = None,
        sorts: Optional[
            Union[
                List[models.PostV2ListsListEntriesQuerySortUnion],
                List[models.PostV2ListsListEntriesQuerySortUnionTypedDict],
            ]
        ] = None,
        limit: Optional[float] = None,
        offset: Optional[float] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.PostV2ListsListEntriesQueryData]:
        r"""List entries

        Lists entries in a given list, with the option to filter and sort results.

        Required scopes: `list_entry:read`, `list_configuration:read`.

        :param list_id:
        :param filter_: An object used to filter results to a subset of results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting).
        :param sorts: An object used to sort results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting).
        :param limit: The maximum number of results to return. Defaults to 500. See the [full guide to pagination here](/rest-api/how-to/pagination).
        :param offset: The number of results to skip over before returning. Defaults to 0. See the [full guide to pagination here](/rest-api/how-to/pagination).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PostV2ListsListEntriesQueryRequest(
            list_id=list_id,
            request_body=models.PostV2ListsListEntriesQueryRequestBody(
                filter_=filter_,
                sorts=utils.get_pydantic_model(
                    sorts, Optional[List[models.PostV2ListsListEntriesQuerySortUnion]]
                ),
                limit=limit,
                offset=offset,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v2/lists/{list}/entries/query",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PostV2ListsListEntriesQueryRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="post_/v2/lists/{list}/entries/query",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PostV2ListsListEntriesQueryResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2ListsListEntriesQueryNotFoundErrorData, http_res
            )
            raise errors.PostV2ListsListEntriesQueryNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def post_v2_lists_list_entries(
        self,
        *,
        list_id: str,
        data: Union[
            models.PostV2ListsListEntriesDataRequest,
            models.PostV2ListsListEntriesDataRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PostV2ListsListEntriesDataResponse:
        r"""Create an entry (add record to list)

        Adds a record to a list as a new list entry. This endpoint will throw on conflicts of unique attributes. Multiple list entries are allowed for the same parent record

        Required scopes: `list_entry:read-write`, `list_configuration:read`.

        :param list_id:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PostV2ListsListEntriesRequest(
            list_id=list_id,
            request_body=models.PostV2ListsListEntriesRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PostV2ListsListEntriesDataRequest
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v2/lists/{list}/entries",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PostV2ListsListEntriesRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="post_/v2/lists/{list}/entries",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PostV2ListsListEntriesResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2ListsListEntriesValueNotFoundErrorData, http_res
            )
            raise errors.PostV2ListsListEntriesValueNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2ListsListEntriesNotFoundErrorData, http_res
            )
            raise errors.PostV2ListsListEntriesNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def post_v2_lists_list_entries_async(
        self,
        *,
        list_id: str,
        data: Union[
            models.PostV2ListsListEntriesDataRequest,
            models.PostV2ListsListEntriesDataRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PostV2ListsListEntriesDataResponse:
        r"""Create an entry (add record to list)

        Adds a record to a list as a new list entry. This endpoint will throw on conflicts of unique attributes. Multiple list entries are allowed for the same parent record

        Required scopes: `list_entry:read-write`, `list_configuration:read`.

        :param list_id:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PostV2ListsListEntriesRequest(
            list_id=list_id,
            request_body=models.PostV2ListsListEntriesRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PostV2ListsListEntriesDataRequest
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v2/lists/{list}/entries",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PostV2ListsListEntriesRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="post_/v2/lists/{list}/entries",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PostV2ListsListEntriesResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2ListsListEntriesValueNotFoundErrorData, http_res
            )
            raise errors.PostV2ListsListEntriesValueNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PostV2ListsListEntriesNotFoundErrorData, http_res
            )
            raise errors.PostV2ListsListEntriesNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def put_v2_lists_list_entries(
        self,
        *,
        list_id: str,
        data: Union[
            models.PutV2ListsListEntriesDataRequest,
            models.PutV2ListsListEntriesDataRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PutV2ListsListEntriesDataResponse:
        r"""Assert a list entry by parent

        Use this endpoint to create or update a list entry for a given parent record. If an entry with the specified parent record is found, that entry will be updated. If no such entry is found, a new entry will be created instead. If there are multiple entries with the same parent record, this endpoint with return the \"MULTIPLE_MATCH_RESULTS\" error. When writing to multi-select attributes, all values will be either created or deleted as necessary to match the list of values supplied in the request body.

        Required scopes: `list_entry:read-write`, `list_configuration:read`.

        :param list_id:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PutV2ListsListEntriesRequest(
            list_id=list_id,
            request_body=models.PutV2ListsListEntriesRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PutV2ListsListEntriesDataRequest
                ),
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/v2/lists/{list}/entries",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PutV2ListsListEntriesRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="put_/v2/lists/{list}/entries",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PutV2ListsListEntriesResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.MultipleMatchResultsErrorData, http_res
            )
            raise errors.MultipleMatchResultsError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PutV2ListsListEntriesNotFoundErrorData, http_res
            )
            raise errors.PutV2ListsListEntriesNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def put_v2_lists_list_entries_async(
        self,
        *,
        list_id: str,
        data: Union[
            models.PutV2ListsListEntriesDataRequest,
            models.PutV2ListsListEntriesDataRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PutV2ListsListEntriesDataResponse:
        r"""Assert a list entry by parent

        Use this endpoint to create or update a list entry for a given parent record. If an entry with the specified parent record is found, that entry will be updated. If no such entry is found, a new entry will be created instead. If there are multiple entries with the same parent record, this endpoint with return the \"MULTIPLE_MATCH_RESULTS\" error. When writing to multi-select attributes, all values will be either created or deleted as necessary to match the list of values supplied in the request body.

        Required scopes: `list_entry:read-write`, `list_configuration:read`.

        :param list_id:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PutV2ListsListEntriesRequest(
            list_id=list_id,
            request_body=models.PutV2ListsListEntriesRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PutV2ListsListEntriesDataRequest
                ),
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/v2/lists/{list}/entries",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PutV2ListsListEntriesRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="put_/v2/lists/{list}/entries",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PutV2ListsListEntriesResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.MultipleMatchResultsErrorData, http_res
            )
            raise errors.MultipleMatchResultsError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PutV2ListsListEntriesNotFoundErrorData, http_res
            )
            raise errors.PutV2ListsListEntriesNotFoundError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def get_v2_lists_list_entries_entry_id_(
        self,
        *,
        list_id: str,
        entry_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetV2ListsListEntriesEntryIDData:
        r"""Get a list entry

        Gets a single list entry by its `entry_id`.

        Required scopes: `list_entry:read`, `list_configuration:read`.

        :param list_id:
        :param entry_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2ListsListEntriesEntryIDRequest(
            list_id=list_id,
            entry_id=entry_id,
        )

        req = self._build_request(
            method="GET",
            path="/v2/lists/{list}/entries/{entry_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/lists/{list}/entries/{entry_id}",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2ListsListEntriesEntryIDResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2ListsListEntriesEntryIDNotFoundErrorData, http_res
            )
            raise errors.GetV2ListsListEntriesEntryIDNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def get_v2_lists_list_entries_entry_id__async(
        self,
        *,
        list_id: str,
        entry_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetV2ListsListEntriesEntryIDData:
        r"""Get a list entry

        Gets a single list entry by its `entry_id`.

        Required scopes: `list_entry:read`, `list_configuration:read`.

        :param list_id:
        :param entry_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2ListsListEntriesEntryIDRequest(
            list_id=list_id,
            entry_id=entry_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v2/lists/{list}/entries/{entry_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/lists/{list}/entries/{entry_id}",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2ListsListEntriesEntryIDResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2ListsListEntriesEntryIDNotFoundErrorData, http_res
            )
            raise errors.GetV2ListsListEntriesEntryIDNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def patch_v2_lists_list_entries_entry_id_(
        self,
        *,
        list_id: str,
        entry_id: str,
        data: Union[
            models.PatchV2ListsListEntriesEntryIDDataRequest,
            models.PatchV2ListsListEntriesEntryIDDataRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PatchV2ListsListEntriesEntryIDDataResponse:
        r"""Update a list entry (append multiselect values)

        Use this endpoint to update list entries by `entry_id`. If the update payload includes multiselect attributes, the values supplied will be created and prepended to the list of values that already exist (if any). Use the `PUT` endpoint to overwrite or remove multiselect attribute values.

        Required scopes: `list_entry:read-write`, `list_configuration:read`.

        :param list_id:
        :param entry_id:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PatchV2ListsListEntriesEntryIDRequest(
            list_id=list_id,
            entry_id=entry_id,
            request_body=models.PatchV2ListsListEntriesEntryIDRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PatchV2ListsListEntriesEntryIDDataRequest
                ),
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/v2/lists/{list}/entries/{entry_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PatchV2ListsListEntriesEntryIDRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patch_/v2/lists/{list}/entries/{entry_id}",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PatchV2ListsListEntriesEntryIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2ListsListEntriesEntryIDImmutableValueErrorData, http_res
            )
            raise errors.PatchV2ListsListEntriesEntryIDImmutableValueError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2ListsListEntriesEntryIDNotFoundErrorData, http_res
            )
            raise errors.PatchV2ListsListEntriesEntryIDNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def patch_v2_lists_list_entries_entry_id__async(
        self,
        *,
        list_id: str,
        entry_id: str,
        data: Union[
            models.PatchV2ListsListEntriesEntryIDDataRequest,
            models.PatchV2ListsListEntriesEntryIDDataRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PatchV2ListsListEntriesEntryIDDataResponse:
        r"""Update a list entry (append multiselect values)

        Use this endpoint to update list entries by `entry_id`. If the update payload includes multiselect attributes, the values supplied will be created and prepended to the list of values that already exist (if any). Use the `PUT` endpoint to overwrite or remove multiselect attribute values.

        Required scopes: `list_entry:read-write`, `list_configuration:read`.

        :param list_id:
        :param entry_id:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PatchV2ListsListEntriesEntryIDRequest(
            list_id=list_id,
            entry_id=entry_id,
            request_body=models.PatchV2ListsListEntriesEntryIDRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PatchV2ListsListEntriesEntryIDDataRequest
                ),
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/v2/lists/{list}/entries/{entry_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PatchV2ListsListEntriesEntryIDRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="patch_/v2/lists/{list}/entries/{entry_id}",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PatchV2ListsListEntriesEntryIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2ListsListEntriesEntryIDImmutableValueErrorData, http_res
            )
            raise errors.PatchV2ListsListEntriesEntryIDImmutableValueError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PatchV2ListsListEntriesEntryIDNotFoundErrorData, http_res
            )
            raise errors.PatchV2ListsListEntriesEntryIDNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def put_v2_lists_list_entries_entry_id_(
        self,
        *,
        list_id: str,
        entry_id: str,
        data: Union[
            models.PutV2ListsListEntriesEntryIDDataRequest,
            models.PutV2ListsListEntriesEntryIDDataRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PutV2ListsListEntriesEntryIDDataResponse:
        r"""Update a list entry (overwrite multiselect values)

        Use this endpoint to update list entries by `entry_id`. If the update payload includes multiselect attributes, the values supplied will overwrite/remove the list of values that already exist (if any). Use the `PATCH` endpoint to add multiselect attribute values without removing those value that already exist.

        Required scopes: `list_entry:read-write`, `list_configuration:read`.

        :param list_id:
        :param entry_id:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PutV2ListsListEntriesEntryIDRequest(
            list_id=list_id,
            entry_id=entry_id,
            request_body=models.PutV2ListsListEntriesEntryIDRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PutV2ListsListEntriesEntryIDDataRequest
                ),
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/v2/lists/{list}/entries/{entry_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PutV2ListsListEntriesEntryIDRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="put_/v2/lists/{list}/entries/{entry_id}",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PutV2ListsListEntriesEntryIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PutV2ListsListEntriesEntryIDImmutableValueErrorData, http_res
            )
            raise errors.PutV2ListsListEntriesEntryIDImmutableValueError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PutV2ListsListEntriesEntryIDNotFoundErrorData, http_res
            )
            raise errors.PutV2ListsListEntriesEntryIDNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def put_v2_lists_list_entries_entry_id__async(
        self,
        *,
        list_id: str,
        entry_id: str,
        data: Union[
            models.PutV2ListsListEntriesEntryIDDataRequest,
            models.PutV2ListsListEntriesEntryIDDataRequestTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PutV2ListsListEntriesEntryIDDataResponse:
        r"""Update a list entry (overwrite multiselect values)

        Use this endpoint to update list entries by `entry_id`. If the update payload includes multiselect attributes, the values supplied will overwrite/remove the list of values that already exist (if any). Use the `PATCH` endpoint to add multiselect attribute values without removing those value that already exist.

        Required scopes: `list_entry:read-write`, `list_configuration:read`.

        :param list_id:
        :param entry_id:
        :param data:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PutV2ListsListEntriesEntryIDRequest(
            list_id=list_id,
            entry_id=entry_id,
            request_body=models.PutV2ListsListEntriesEntryIDRequestBody(
                data=utils.get_pydantic_model(
                    data, models.PutV2ListsListEntriesEntryIDDataRequest
                ),
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/v2/lists/{list}/entries/{entry_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.PutV2ListsListEntriesEntryIDRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="put_/v2/lists/{list}/entries/{entry_id}",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PutV2ListsListEntriesEntryIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.PutV2ListsListEntriesEntryIDImmutableValueErrorData, http_res
            )
            raise errors.PutV2ListsListEntriesEntryIDImmutableValueError(
                response_data, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.PutV2ListsListEntriesEntryIDNotFoundErrorData, http_res
            )
            raise errors.PutV2ListsListEntriesEntryIDNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def delete_v2_lists_list_entries_entry_id_(
        self,
        *,
        list_id: str,
        entry_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DeleteV2ListsListEntriesEntryIDResponse:
        r"""Delete a list entry

        Deletes a single list entry by its `entry_id`.

        Required scopes: `list_entry:read-write`, `list_configuration:read`.

        :param list_id:
        :param entry_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteV2ListsListEntriesEntryIDRequest(
            list_id=list_id,
            entry_id=entry_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/v2/lists/{list}/entries/{entry_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete_/v2/lists/{list}/entries/{entry_id}",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.DeleteV2ListsListEntriesEntryIDResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.DeleteV2ListsListEntriesEntryIDNotFoundErrorData, http_res
            )
            raise errors.DeleteV2ListsListEntriesEntryIDNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def delete_v2_lists_list_entries_entry_id__async(
        self,
        *,
        list_id: str,
        entry_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DeleteV2ListsListEntriesEntryIDResponse:
        r"""Delete a list entry

        Deletes a single list entry by its `entry_id`.

        Required scopes: `list_entry:read-write`, `list_configuration:read`.

        :param list_id:
        :param entry_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteV2ListsListEntriesEntryIDRequest(
            list_id=list_id,
            entry_id=entry_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/v2/lists/{list}/entries/{entry_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete_/v2/lists/{list}/entries/{entry_id}",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.DeleteV2ListsListEntriesEntryIDResponse, http_res
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.DeleteV2ListsListEntriesEntryIDNotFoundErrorData, http_res
            )
            raise errors.DeleteV2ListsListEntriesEntryIDNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def get_v2_lists_list_entries_entry_id_attributes_attribute_values(
        self,
        *,
        list_id: str,
        entry_id: str,
        attribute: str,
        show_historic: Optional[bool] = False,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.GetV2ListsListEntriesEntryIDAttributesAttributeValuesDataUnion]:
        r"""List attribute values for a list entry

        Gets all values for a given attribute on a list entry. This endpoint has the ability to return all historic values using the `show_historic` query param. Historic values are sorted from oldest to newest (by `active_from`).

        Required scopes: `list_entry:read`, `list_configuration:read`.

        :param list_id:
        :param entry_id:
        :param attribute:
        :param show_historic:
        :param limit:
        :param offset:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2ListsListEntriesEntryIDAttributesAttributeValuesRequest(
            list_id=list_id,
            entry_id=entry_id,
            attribute=attribute,
            show_historic=show_historic,
            limit=limit,
            offset=offset,
        )

        req = self._build_request(
            method="GET",
            path="/v2/lists/{list}/entries/{entry_id}/attributes/{attribute}/values",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/lists/{list}/entries/{entry_id}/attributes/{attribute}/values",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2ListsListEntriesEntryIDAttributesAttributeValuesResponse,
                http_res,
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2ListsListEntriesEntryIDAttributesAttributeValuesNotFoundErrorData,
                http_res,
            )
            raise errors.GetV2ListsListEntriesEntryIDAttributesAttributeValuesNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def get_v2_lists_list_entries_entry_id_attributes_attribute_values_async(
        self,
        *,
        list_id: str,
        entry_id: str,
        attribute: str,
        show_historic: Optional[bool] = False,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.GetV2ListsListEntriesEntryIDAttributesAttributeValuesDataUnion]:
        r"""List attribute values for a list entry

        Gets all values for a given attribute on a list entry. This endpoint has the ability to return all historic values using the `show_historic` query param. Historic values are sorted from oldest to newest (by `active_from`).

        Required scopes: `list_entry:read`, `list_configuration:read`.

        :param list_id:
        :param entry_id:
        :param attribute:
        :param show_historic:
        :param limit:
        :param offset:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetV2ListsListEntriesEntryIDAttributesAttributeValuesRequest(
            list_id=list_id,
            entry_id=entry_id,
            attribute=attribute,
            show_historic=show_historic,
            limit=limit,
            offset=offset,
        )

        req = self._build_request_async(
            method="GET",
            path="/v2/lists/{list}/entries/{entry_id}/attributes/{attribute}/values",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_/v2/lists/{list}/entries/{entry_id}/attributes/{attribute}/values",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetV2ListsListEntriesEntryIDAttributesAttributeValuesResponse,
                http_res,
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.GetV2ListsListEntriesEntryIDAttributesAttributeValuesNotFoundErrorData,
                http_res,
            )
            raise errors.GetV2ListsListEntriesEntryIDAttributesAttributeValuesNotFoundError(
                response_data, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)
