"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.errors import SDKError
from attio.models import patch_v2_tasks_task_id_op as models_patch_v2_tasks_task_id_op
from attio.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class PatchV2TasksTaskIDNotFoundErrorData(BaseModel):
    status_code: float

    type: models_patch_v2_tasks_task_id_op.PatchV2TasksTaskIDNotFoundType

    code: models_patch_v2_tasks_task_id_op.PatchV2TasksTaskIDNotFoundCode

    message: str


@dataclass(frozen=True)
class PatchV2TasksTaskIDNotFoundError(SDKError):
    r"""Not Found"""

    data: PatchV2TasksTaskIDNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PatchV2TasksTaskIDNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PatchV2TasksTaskIDValidationTypeErrorData(BaseModel):
    status_code: float

    type: models_patch_v2_tasks_task_id_op.PatchV2TasksTaskIDBadRequestType

    code: models_patch_v2_tasks_task_id_op.PatchV2TasksTaskIDCodeValidationType

    message: str


@dataclass(frozen=True)
class PatchV2TasksTaskIDValidationTypeError(SDKError):
    r"""Bad Request"""

    data: PatchV2TasksTaskIDValidationTypeErrorData = field(hash=False)

    def __init__(
        self,
        data: PatchV2TasksTaskIDValidationTypeErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
