"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.errors import SDKError
from attio.models import post_v2_commentsop as models_post_v2_commentsop
from attio.types import BaseModel
from dataclasses import dataclass, field
import httpx
import pydantic
from typing import Optional
from typing_extensions import Annotated


class PostV2CommentsValueNotFoundErrorData(BaseModel):
    status_code: Annotated[float, pydantic.Field(alias="statusCode")]

    type: models_post_v2_commentsop.PostV2CommentsBadRequestType

    code: models_post_v2_commentsop.PostV2CommentsCode

    message: str


@dataclass(frozen=True)
class PostV2CommentsValueNotFoundError(SDKError):
    r"""Bad Request"""

    data: PostV2CommentsValueNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2CommentsValueNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
