"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.errors import SDKError
from attio.models import post_v2_listsop as models_post_v2_listsop
from attio.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class PostV2ListsSlugConflictErrorData(BaseModel):
    status_code: float

    type: models_post_v2_listsop.PostV2ListsConflictType

    code: models_post_v2_listsop.PostV2ListsConflictCode

    message: str


@dataclass(frozen=True)
class PostV2ListsSlugConflictError(SDKError):
    r"""Conflict"""

    data: PostV2ListsSlugConflictErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2ListsSlugConflictErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PostV2ListsNotFoundErrorData(BaseModel):
    status_code: float

    type: models_post_v2_listsop.PostV2ListsNotFoundType

    code: models_post_v2_listsop.PostV2ListsNotFoundCode

    message: str


@dataclass(frozen=True)
class PostV2ListsNotFoundError(SDKError):
    r"""Not Found"""

    data: PostV2ListsNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2ListsNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class BillingErrorData(BaseModel):
    status_code: float

    type: models_post_v2_listsop.ForbiddenType

    code: models_post_v2_listsop.ForbiddenCode

    message: str


@dataclass(frozen=True)
class BillingError(SDKError):
    r"""Forbidden"""

    data: BillingErrorData = field(hash=False)

    def __init__(
        self,
        data: BillingErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PostV2ListsValueNotFoundErrorData(BaseModel):
    status_code: float

    type: models_post_v2_listsop.PostV2ListsBadRequestType

    code: models_post_v2_listsop.PostV2ListsCodeValueNotFound

    message: str


@dataclass(frozen=True)
class PostV2ListsValueNotFoundError(SDKError):
    r"""Bad Request"""

    data: PostV2ListsValueNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2ListsValueNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
