"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.errors import SDKError
from attio.models import post_v2_notesop as models_post_v2_notesop
from attio.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class PostV2NotesNotFoundErrorData(BaseModel):
    status_code: float

    type: models_post_v2_notesop.PostV2NotesType

    code: models_post_v2_notesop.PostV2NotesCode

    message: str


@dataclass(frozen=True)
class PostV2NotesNotFoundError(SDKError):
    r"""Not Found"""

    data: PostV2NotesNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2NotesNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
