"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.errors import SDKError
from attio.models import (
    post_v2_objects_object_recordsop as models_post_v2_objects_object_recordsop,
)
from attio.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Optional


class PostV2ObjectsObjectRecordsNotFoundErrorData(BaseModel):
    status_code: float

    type: models_post_v2_objects_object_recordsop.PostV2ObjectsObjectRecordsNotFoundType

    code: models_post_v2_objects_object_recordsop.PostV2ObjectsObjectRecordsNotFoundCode

    message: str


@dataclass(frozen=True)
class PostV2ObjectsObjectRecordsNotFoundError(SDKError):
    r"""Not Found"""

    data: PostV2ObjectsObjectRecordsNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2ObjectsObjectRecordsNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PostV2ObjectsObjectRecordsValueNotFoundErrorData(BaseModel):
    status_code: float

    type: (
        models_post_v2_objects_object_recordsop.PostV2ObjectsObjectRecordsBadRequestType
    )

    code: models_post_v2_objects_object_recordsop.PostV2ObjectsObjectRecordsCodeValueNotFound

    message: str


@dataclass(frozen=True)
class PostV2ObjectsObjectRecordsValueNotFoundError(SDKError):
    r"""Bad Request"""

    data: PostV2ObjectsObjectRecordsValueNotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: PostV2ObjectsObjectRecordsValueNotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
