"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal
from typing_extensions import NotRequired, TypedDict


class CommentIDTypedDict(TypedDict):
    workspace_id: str
    r"""The ID of the workspace the comment belongs to."""
    comment_id: str
    r"""The ID of the comment."""


class CommentID(BaseModel):
    workspace_id: str
    r"""The ID of the workspace the comment belongs to."""

    comment_id: str
    r"""The ID of the comment."""


class EntryTypedDict(TypedDict):
    r"""The entry the comment belongs to, `null` for comments on records."""

    entry_id: str
    r"""The ID of the entry the comment belongs to."""
    list_id: str
    r"""The ID of the list the entry belongs to."""


class Entry(BaseModel):
    r"""The entry the comment belongs to, `null` for comments on records."""

    entry_id: str
    r"""The ID of the entry the comment belongs to."""

    list_id: str
    r"""The ID of the list the entry belongs to."""


class RecordTypedDict(TypedDict):
    r"""The record the comment belongs to."""

    record_id: str
    r"""The ID of the record the comment belongs to."""
    object_id: str
    r"""The ID of the object the record belongs to."""


class Record(BaseModel):
    r"""The record the comment belongs to."""

    record_id: str
    r"""The ID of the record the comment belongs to."""

    object_id: str
    r"""The ID of the object the record belongs to."""


ResolvedByType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class ResolvedByTypedDict(TypedDict):
    r"""The actor that resolved this comment."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[ResolvedByType]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class ResolvedBy(BaseModel):
    r"""The actor that resolved this comment."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[ResolvedByType] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


AuthorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class AuthorTypedDict(TypedDict):
    r"""Who wrote this comment. Note that the API provides the ability for API tokens to write comments on behalf of other actors."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[AuthorType]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class Author(BaseModel):
    r"""Who wrote this comment. Note that the API provides the ability for API tokens to write comments on behalf of other actors."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[AuthorType] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CommentTypedDict(TypedDict):
    id: CommentIDTypedDict
    thread_id: str
    r"""The ID of the thread the comment belongs to."""
    content_plaintext: str
    r"""A plaintext representation of the content of the comment. References to workspace members are cast into email addresses, all other stylistic elements are removed."""
    entry: Nullable[EntryTypedDict]
    r"""The entry the comment belongs to, `null` for comments on records."""
    record: RecordTypedDict
    r"""The record the comment belongs to."""
    resolved_at: Nullable[str]
    r"""Whether the comment is resolved."""
    resolved_by: ResolvedByTypedDict
    r"""The actor that resolved this comment."""
    created_at: str
    r"""When the note was created."""
    author: AuthorTypedDict
    r"""Who wrote this comment. Note that the API provides the ability for API tokens to write comments on behalf of other actors."""


class Comment(BaseModel):
    id: CommentID

    thread_id: str
    r"""The ID of the thread the comment belongs to."""

    content_plaintext: str
    r"""A plaintext representation of the content of the comment. References to workspace members are cast into email addresses, all other stylistic elements are removed."""

    entry: Nullable[Entry]
    r"""The entry the comment belongs to, `null` for comments on records."""

    record: Record
    r"""The record the comment belongs to."""

    resolved_at: Nullable[str]
    r"""Whether the comment is resolved."""

    resolved_by: ResolvedBy
    r"""The actor that resolved this comment."""

    created_at: str
    r"""When the note was created."""

    author: Author
    r"""Who wrote this comment. Note that the API provides the ability for API tokens to write comments on behalf of other actors."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["entry", "resolved_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
