"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .meeting import Meeting, MeetingTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from attio.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


GetV2MeetingsSort = Literal[
    "start_asc",
    "start_desc",
]
r"""The order in which to sort the meetings. Defaults to start_asc."""


class GetV2MeetingsRequestTypedDict(TypedDict):
    limit: NotRequired[int]
    cursor: NotRequired[str]
    linked_object: NotRequired[str]
    linked_record_id: NotRequired[str]
    participants: NotRequired[str]
    sort: NotRequired[GetV2MeetingsSort]
    r"""The order in which to sort the meetings. Defaults to start_asc."""
    ends_from: NotRequired[Nullable[str]]
    starts_before: NotRequired[Nullable[str]]
    timezone: NotRequired[str]


class GetV2MeetingsRequest(BaseModel):
    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50

    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    linked_object: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    linked_record_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    participants: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ""

    sort: Annotated[
        Optional[GetV2MeetingsSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "start_asc"
    r"""The order in which to sort the meetings. Defaults to start_asc."""

    ends_from: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    starts_before: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    timezone: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "UTC"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "limit",
            "cursor",
            "linked_object",
            "linked_record_id",
            "participants",
            "sort",
            "ends_from",
            "starts_before",
            "timezone",
        ]
        nullable_fields = ["ends_from", "starts_before"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetV2MeetingsPaginationTypedDict(TypedDict):
    next_cursor: Nullable[str]


class GetV2MeetingsPagination(BaseModel):
    next_cursor: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next_cursor"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetV2MeetingsResponseTypedDict(TypedDict):
    r"""Success"""

    data: List[MeetingTypedDict]
    pagination: GetV2MeetingsPaginationTypedDict


class GetV2MeetingsResponse(BaseModel):
    r"""Success"""

    data: List[Meeting]

    pagination: GetV2MeetingsPagination
