"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Literal
from typing_extensions import NotRequired, TypedDict


class ListIDTypedDict(TypedDict):
    workspace_id: str
    r"""A UUID to identify the workspace this list belongs to."""
    list_id: str
    r"""A UUID to identify this list."""


class ListID(BaseModel):
    workspace_id: str
    r"""A UUID to identify the workspace this list belongs to."""

    list_id: str
    r"""A UUID to identify this list."""


WorkspaceAccess = Literal[
    "full-access",
    "read-and-write",
    "read-only",
]
r"""The level of access granted to all members of the workspace for this list. `null` values represent a private list that only grants access to specific workspace members via the `workspace_member_access` property."""


Level = Literal[
    "full-access",
    "read-and-write",
    "read-only",
]
r"""The level of access to the list."""


class WorkspaceMemberAccessTypedDict(TypedDict):
    workspace_member_id: str
    r"""A UUID to identify the workspace member to grant access to."""
    level: Level
    r"""The level of access to the list."""


class WorkspaceMemberAccess(BaseModel):
    workspace_member_id: str
    r"""A UUID to identify the workspace member to grant access to."""

    level: Level
    r"""The level of access to the list."""


ListType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class ListCreatedByActorTypedDict(TypedDict):
    r"""The actor which created this list."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[ListType]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class ListCreatedByActor(BaseModel):
    r"""The actor which created this list."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[ListType] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListTTypedDict(TypedDict):
    id: ListIDTypedDict
    api_slug: str
    r"""A human-readable slug for use in URLs and responses."""
    name: str
    r"""The name of the list, as viewed in the UI."""
    parent_object: List[str]
    r"""A UUID or slug to identify the allowed object type for records added to this list. All new Lists are expected to have exactly one parent object. However, some legacy lists may have multiple allowed parents so the return type of this field is an array."""
    workspace_access: Nullable[WorkspaceAccess]
    r"""The level of access granted to all members of the workspace for this list. `null` values represent a private list that only grants access to specific workspace members via the `workspace_member_access` property."""
    workspace_member_access: List[WorkspaceMemberAccessTypedDict]
    r"""The level of access granted to specific workspace members for this list. An empty array represents a list that has granted access to no workspace members."""
    created_by_actor: ListCreatedByActorTypedDict
    r"""The actor which created this list."""
    created_at: str
    r"""When the list was created."""


class ListT(BaseModel):
    id: ListID

    api_slug: str
    r"""A human-readable slug for use in URLs and responses."""

    name: str
    r"""The name of the list, as viewed in the UI."""

    parent_object: List[str]
    r"""A UUID or slug to identify the allowed object type for records added to this list. All new Lists are expected to have exactly one parent object. However, some legacy lists may have multiple allowed parents so the return type of this field is an array."""

    workspace_access: Nullable[WorkspaceAccess]
    r"""The level of access granted to all members of the workspace for this list. `null` values represent a private list that only grants access to specific workspace members via the `workspace_member_access` property."""

    workspace_member_access: List[WorkspaceMemberAccess]
    r"""The level of access granted to specific workspace members for this list. An empty array represents a list that has granted access to no workspace members."""

    created_by_actor: ListCreatedByActor
    r"""The actor which created this list."""

    created_at: str
    r"""When the list was created."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["workspace_access"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
