"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from attio.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import TypedDict


class ObjectIDTypedDict(TypedDict):
    workspace_id: str
    r"""A UUID to identify the workspace this object belongs to."""
    object_id: str
    r"""A UUID to identify the object."""


class ObjectID(BaseModel):
    workspace_id: str
    r"""A UUID to identify the workspace this object belongs to."""

    object_id: str
    r"""A UUID to identify the object."""


class ObjectTypedDict(TypedDict):
    id: ObjectIDTypedDict
    api_slug: Nullable[str]
    r"""A unique, human-readable slug to access the object through URLs and API calls. Formatted in snake case."""
    singular_noun: Nullable[str]
    r"""The singular form of the object's name."""
    plural_noun: Nullable[str]
    r"""The plural form of the object's name."""
    created_at: str
    r"""When the object was created."""


class Object(BaseModel):
    id: ObjectID

    api_slug: Nullable[str]
    r"""A unique, human-readable slug to access the object through URLs and API calls. Formatted in snake case."""

    singular_noun: Nullable[str]
    r"""The singular form of the object's name."""

    plural_noun: Nullable[str]
    r"""The plural form of the object's name."""

    created_at: str
    r"""When the object was created."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["api_slug", "singular_noun", "plural_noun"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
