"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .comment import Comment, CommentTypedDict
from attio.types import BaseModel
import pydantic
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


PostV2CommentsFormat3 = Literal["plaintext",]
r"""The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported."""


PostV2CommentsTypeWorkspaceMember3 = Literal["workspace-member",]


class PostV2CommentsAuthor3TypedDict(TypedDict):
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""

    type: PostV2CommentsTypeWorkspaceMember3
    id: str


class PostV2CommentsAuthor3(BaseModel):
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""

    type: PostV2CommentsTypeWorkspaceMember3

    id: str


class PostV2CommentsEntryTypedDict(TypedDict):
    list: str
    r"""If creating a top-level comment on a list entry, this is the slug or ID of that list."""
    entry_id: str
    r"""If creating a top-level comment on a list entry, this is the ID of that entry."""


class PostV2CommentsEntry(BaseModel):
    list: str
    r"""If creating a top-level comment on a list entry, this is the slug or ID of that list."""

    entry_id: str
    r"""If creating a top-level comment on a list entry, this is the ID of that entry."""


class PostV2CommentsDataPlaintext3TypedDict(TypedDict):
    format_: PostV2CommentsFormat3
    r"""The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported."""
    content: str
    r"""The content of the comment itself. Workspace members can be mentioned using their email address, otherwise email addresses will be presented to users as clickable mailto links."""
    author: PostV2CommentsAuthor3TypedDict
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""
    entry: PostV2CommentsEntryTypedDict
    created_at: NotRequired[str]
    r"""`created_at` will default to the current time. However, if you wish to backdate a comment for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed."""


class PostV2CommentsDataPlaintext3(BaseModel):
    format_: Annotated[PostV2CommentsFormat3, pydantic.Field(alias="format")]
    r"""The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported."""

    content: str
    r"""The content of the comment itself. Workspace members can be mentioned using their email address, otherwise email addresses will be presented to users as clickable mailto links."""

    author: PostV2CommentsAuthor3
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""

    entry: PostV2CommentsEntry

    created_at: Optional[str] = None
    r"""`created_at` will default to the current time. However, if you wish to backdate a comment for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed."""


PostV2CommentsFormat2 = Literal["plaintext",]
r"""The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported."""


PostV2CommentsTypeWorkspaceMember2 = Literal["workspace-member",]


class PostV2CommentsAuthor2TypedDict(TypedDict):
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""

    type: PostV2CommentsTypeWorkspaceMember2
    id: str


class PostV2CommentsAuthor2(BaseModel):
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""

    type: PostV2CommentsTypeWorkspaceMember2

    id: str


class PostV2CommentsRecordTypedDict(TypedDict):
    object: str
    r"""If creating a top-level comment on a record, this is the slug or ID of that object."""
    record_id: str
    r"""If creating a top-level comment on a record, this is the ID of that record."""


class PostV2CommentsRecord(BaseModel):
    object: str
    r"""If creating a top-level comment on a record, this is the slug or ID of that object."""

    record_id: str
    r"""If creating a top-level comment on a record, this is the ID of that record."""


class PostV2CommentsDataPlaintext2TypedDict(TypedDict):
    format_: PostV2CommentsFormat2
    r"""The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported."""
    content: str
    r"""The content of the comment itself. Workspace members can be mentioned using their email address, otherwise email addresses will be presented to users as clickable mailto links."""
    author: PostV2CommentsAuthor2TypedDict
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""
    record: PostV2CommentsRecordTypedDict
    created_at: NotRequired[str]
    r"""`created_at` will default to the current time. However, if you wish to backdate a comment for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed."""


class PostV2CommentsDataPlaintext2(BaseModel):
    format_: Annotated[PostV2CommentsFormat2, pydantic.Field(alias="format")]
    r"""The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported."""

    content: str
    r"""The content of the comment itself. Workspace members can be mentioned using their email address, otherwise email addresses will be presented to users as clickable mailto links."""

    author: PostV2CommentsAuthor2
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""

    record: PostV2CommentsRecord

    created_at: Optional[str] = None
    r"""`created_at` will default to the current time. However, if you wish to backdate a comment for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed."""


PostV2CommentsFormat1 = Literal["plaintext",]
r"""The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported."""


PostV2CommentsTypeWorkspaceMember1 = Literal["workspace-member",]


class PostV2CommentsAuthor1TypedDict(TypedDict):
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""

    type: PostV2CommentsTypeWorkspaceMember1
    id: str


class PostV2CommentsAuthor1(BaseModel):
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""

    type: PostV2CommentsTypeWorkspaceMember1

    id: str


class PostV2CommentsDataPlaintext1TypedDict(TypedDict):
    format_: PostV2CommentsFormat1
    r"""The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported."""
    content: str
    r"""The content of the comment itself. Workspace members can be mentioned using their email address, otherwise email addresses will be presented to users as clickable mailto links."""
    author: PostV2CommentsAuthor1TypedDict
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""
    thread_id: str
    r"""If responding to an existing thread, this would be the ID of that thread."""
    created_at: NotRequired[str]
    r"""`created_at` will default to the current time. However, if you wish to backdate a comment for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed."""


class PostV2CommentsDataPlaintext1(BaseModel):
    format_: Annotated[PostV2CommentsFormat1, pydantic.Field(alias="format")]
    r"""The format that the comment content is provided in. The `plaintext` format uses the line feed character `\n` to create new lines within the note content. Rich text formatting and links are not supported."""

    content: str
    r"""The content of the comment itself. Workspace members can be mentioned using their email address, otherwise email addresses will be presented to users as clickable mailto links."""

    author: PostV2CommentsAuthor1
    r"""The workspace member who wrote this comment. Note that other types of actors are not currently supported."""

    thread_id: str
    r"""If responding to an existing thread, this would be the ID of that thread."""

    created_at: Optional[str] = None
    r"""`created_at` will default to the current time. However, if you wish to backdate a comment for migration or other purposes, you can override with a custom `created_at` value. Note that dates before 1970 or in the future are not allowed."""


PostV2CommentsDataUnionTypedDict = TypeAliasType(
    "PostV2CommentsDataUnionTypedDict",
    Union[
        PostV2CommentsDataPlaintext1TypedDict,
        PostV2CommentsDataPlaintext2TypedDict,
        PostV2CommentsDataPlaintext3TypedDict,
    ],
)


PostV2CommentsDataUnion = TypeAliasType(
    "PostV2CommentsDataUnion",
    Union[
        PostV2CommentsDataPlaintext1,
        PostV2CommentsDataPlaintext2,
        PostV2CommentsDataPlaintext3,
    ],
)


class PostV2CommentsRequestTypedDict(TypedDict):
    data: PostV2CommentsDataUnionTypedDict


class PostV2CommentsRequest(BaseModel):
    data: PostV2CommentsDataUnion


PostV2CommentsBadRequestType = Literal["invalid_request_error",]


PostV2CommentsCode = Literal["value_not_found",]


class PostV2CommentsResponseTypedDict(TypedDict):
    r"""Success"""

    data: CommentTypedDict


class PostV2CommentsResponse(BaseModel):
    r"""Success"""

    data: Comment
