"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .select_option import SelectOption, SelectOptionTypedDict
from .status import Status, StatusTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from attio.utils import FieldMetadata, PathParamMetadata, RequestMetadata
from datetime import datetime
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


PostV2ListsListEntriesQueryDirection2 = Literal[
    "asc",
    "desc",
]
r"""The direction to sort the results by."""


class PostV2ListsListEntriesQuerySort2TypedDict(TypedDict):
    r"""Sort by path"""

    direction: PostV2ListsListEntriesQueryDirection2
    r"""The direction to sort the results by."""
    path: List[List[str]]
    r"""You may use the `path` property to traverse record reference attributes and parent records on list entries. `path` accepts an array of tuples where the first element of each tuple is the slug or ID of a list/object, and the second element is the slug or ID of an attribute on that list/object. The first element of the first tuple must correspond to the list or object that you are querying. For example, if you wanted to sort by the name of the parent record (a company) on a list with the slug \"sales\", you would pass the value `[['sales', 'parent_record'], ['companies', 'name']]`."""
    field: NotRequired[str]
    r"""Which field on the value to sort by e.g. \"last_name\" on a name value."""


class PostV2ListsListEntriesQuerySort2(BaseModel):
    r"""Sort by path"""

    direction: PostV2ListsListEntriesQueryDirection2
    r"""The direction to sort the results by."""

    path: List[List[str]]
    r"""You may use the `path` property to traverse record reference attributes and parent records on list entries. `path` accepts an array of tuples where the first element of each tuple is the slug or ID of a list/object, and the second element is the slug or ID of an attribute on that list/object. The first element of the first tuple must correspond to the list or object that you are querying. For example, if you wanted to sort by the name of the parent record (a company) on a list with the slug \"sales\", you would pass the value `[['sales', 'parent_record'], ['companies', 'name']]`."""

    field: Optional[str] = None
    r"""Which field on the value to sort by e.g. \"last_name\" on a name value."""


PostV2ListsListEntriesQueryDirection1 = Literal[
    "asc",
    "desc",
]
r"""The direction to sort the results by."""


class PostV2ListsListEntriesQuerySort1TypedDict(TypedDict):
    r"""Sort by attribute"""

    direction: PostV2ListsListEntriesQueryDirection1
    r"""The direction to sort the results by."""
    attribute: str
    r"""A slug or ID to identify the attribute to sort by."""
    field: NotRequired[str]
    r"""Which field on the value to sort by e.g. \"last_name\" on a name value."""


class PostV2ListsListEntriesQuerySort1(BaseModel):
    r"""Sort by attribute"""

    direction: PostV2ListsListEntriesQueryDirection1
    r"""The direction to sort the results by."""

    attribute: str
    r"""A slug or ID to identify the attribute to sort by."""

    field: Optional[str] = None
    r"""Which field on the value to sort by e.g. \"last_name\" on a name value."""


PostV2ListsListEntriesQuerySortUnionTypedDict = TypeAliasType(
    "PostV2ListsListEntriesQuerySortUnionTypedDict",
    Union[
        PostV2ListsListEntriesQuerySort1TypedDict,
        PostV2ListsListEntriesQuerySort2TypedDict,
    ],
)


PostV2ListsListEntriesQuerySortUnion = TypeAliasType(
    "PostV2ListsListEntriesQuerySortUnion",
    Union[PostV2ListsListEntriesQuerySort1, PostV2ListsListEntriesQuerySort2],
)


class PostV2ListsListEntriesQueryRequestBodyTypedDict(TypedDict):
    filter_: NotRequired[Dict[str, Any]]
    r"""An object used to filter results to a subset of results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting)."""
    sorts: NotRequired[List[PostV2ListsListEntriesQuerySortUnionTypedDict]]
    r"""An object used to sort results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting)."""
    limit: NotRequired[float]
    r"""The maximum number of results to return. Defaults to 500. See the [full guide to pagination here](/rest-api/how-to/pagination)."""
    offset: NotRequired[float]
    r"""The number of results to skip over before returning. Defaults to 0. See the [full guide to pagination here](/rest-api/how-to/pagination)."""


class PostV2ListsListEntriesQueryRequestBody(BaseModel):
    filter_: Annotated[Optional[Dict[str, Any]], pydantic.Field(alias="filter")] = None
    r"""An object used to filter results to a subset of results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting)."""

    sorts: Optional[List[PostV2ListsListEntriesQuerySortUnion]] = None
    r"""An object used to sort results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting)."""

    limit: Optional[float] = None
    r"""The maximum number of results to return. Defaults to 500. See the [full guide to pagination here](/rest-api/how-to/pagination)."""

    offset: Optional[float] = None
    r"""The number of results to skip over before returning. Defaults to 0. See the [full guide to pagination here](/rest-api/how-to/pagination)."""


class PostV2ListsListEntriesQueryRequestTypedDict(TypedDict):
    list_id: str
    request_body: PostV2ListsListEntriesQueryRequestBodyTypedDict


class PostV2ListsListEntriesQueryRequest(BaseModel):
    list_id: Annotated[
        str,
        pydantic.Field(alias="list"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    request_body: Annotated[
        PostV2ListsListEntriesQueryRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


PostV2ListsListEntriesQueryNotFoundType = Literal["invalid_request_error",]


PostV2ListsListEntriesQueryCode = Literal["not_found",]


class PostV2ListsListEntriesQueryIDTypedDict(TypedDict):
    workspace_id: str
    r"""A UUID identifying the workspace this entry belongs to."""
    list_id: str
    r"""A UUID identifying the list this entry is in."""
    entry_id: str
    r"""A UUID identifying this entry."""


class PostV2ListsListEntriesQueryID(BaseModel):
    workspace_id: str
    r"""A UUID identifying the workspace this entry belongs to."""

    list_id: str
    r"""A UUID identifying the list this entry is in."""

    entry_id: str
    r"""A UUID identifying this entry."""


PostV2ListsListEntriesQueryCreatedByActorType17 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor17TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType17]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor17(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType17] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeTimestamp = Literal["timestamp",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueTimestampTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor17TypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeTimestamp
    r"""The attribute type of the value."""
    value: str
    r"""A timestamp string value"""


class PostV2ListsListEntriesQueryEntryValueTimestamp(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor17
    r"""The actor that created this value."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeTimestamp
    r"""The attribute type of the value."""

    value: str
    r"""A timestamp string value"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType16 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor16TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType16]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor16(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType16] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeText = Literal["text",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueTextTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor16TypedDict
    r"""The actor that created this value."""
    value: str
    r"""A raw text field. Values are limited to 10MB."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeText
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueText(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor16
    r"""The actor that created this value."""

    value: str
    r"""A raw text field. Values are limited to 10MB."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeText
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType15 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor15TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType15]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor15(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType15] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeSelect = Literal["select",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueSelectTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor15TypedDict
    r"""The actor that created this value."""
    option: SelectOptionTypedDict
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeSelect
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueSelect(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor15
    r"""The actor that created this value."""

    option: SelectOption

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeSelect
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType14 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor14TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType14]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor14(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType14] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeRating = Literal["rating",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueRatingTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor14TypedDict
    r"""The actor that created this value."""
    value: float
    r"""A number between 0 and 5 (inclusive) to represent a star rating."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeRating
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueRating(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor14
    r"""The actor that created this value."""

    value: float
    r"""A number between 0 and 5 (inclusive) to represent a star rating."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeRating
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType13 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor13TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType13]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor13(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType13] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeStatus = Literal["status",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueStatusTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor13TypedDict
    r"""The actor that created this value."""
    status: StatusTypedDict
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeStatus
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueStatus(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor13
    r"""The actor that created this value."""

    status: Status

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeStatus
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType12 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor12TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType12]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor12(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType12] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCountryCode2 = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""


PostV2ListsListEntriesQueryAttributeTypePhoneNumber = Literal["phone-number",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValuePhoneNumberTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor12TypedDict
    r"""The actor that created this value."""
    original_phone_number: str
    r"""The raw, original phone number, as inputted."""
    country_code: PostV2ListsListEntriesQueryCountryCode2
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""
    phone_number: str
    attribute_type: PostV2ListsListEntriesQueryAttributeTypePhoneNumber
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValuePhoneNumber(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor12
    r"""The actor that created this value."""

    original_phone_number: str
    r"""The raw, original phone number, as inputted."""

    country_code: PostV2ListsListEntriesQueryCountryCode2
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""

    phone_number: str

    attribute_type: PostV2ListsListEntriesQueryAttributeTypePhoneNumber
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType11 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor11TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType11]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor11(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType11] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypePersonalName = Literal["personal-name",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValuePersonalNameTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor11TypedDict
    r"""The actor that created this value."""
    first_name: str
    r"""The first name."""
    last_name: str
    r"""The last name."""
    full_name: str
    r"""The full name."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypePersonalName
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValuePersonalName(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor11
    r"""The actor that created this value."""

    first_name: str
    r"""The first name."""

    last_name: str
    r"""The last name."""

    full_name: str
    r"""The full name."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypePersonalName
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType10 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor10TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType10]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor10(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType10] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeNumber = Literal["number",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueNumberTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor10TypedDict
    r"""The actor that created this value."""
    value: float
    r"""Numbers are persisted as 64 bit floats."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeNumber
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueNumber(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor10
    r"""The actor that created this value."""

    value: float
    r"""Numbers are persisted as 64 bit floats."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeNumber
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType9 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor9TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType9]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor9(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType9] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCountryCode1 = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""


PostV2ListsListEntriesQueryAttributeTypeLocation = Literal["location",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueLocationTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor9TypedDict
    r"""The actor that created this value."""
    line_1: Nullable[str]
    r"""The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_2: Nullable[str]
    r"""The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_3: Nullable[str]
    r"""The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_4: Nullable[str]
    r"""The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    locality: Nullable[str]
    r"""The town, neighborhood or area the location is in."""
    region: Nullable[str]
    r"""The state, county, province or region that the location is in."""
    postcode: Nullable[str]
    r"""The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    country_code: Nullable[PostV2ListsListEntriesQueryCountryCode1]
    r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""
    latitude: Nullable[str]
    r"""The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    longitude: Nullable[str]
    r"""The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeLocation
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueLocation(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor9
    r"""The actor that created this value."""

    line_1: Nullable[str]
    r"""The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_2: Nullable[str]
    r"""The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_3: Nullable[str]
    r"""The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_4: Nullable[str]
    r"""The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    locality: Nullable[str]
    r"""The town, neighborhood or area the location is in."""

    region: Nullable[str]
    r"""The state, county, province or region that the location is in."""

    postcode: Nullable[str]
    r"""The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    country_code: Nullable[PostV2ListsListEntriesQueryCountryCode1]
    r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""

    latitude: Nullable[str]
    r"""The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    longitude: Nullable[str]
    r"""The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeLocation
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "active_until",
            "line_1",
            "line_2",
            "line_3",
            "line_4",
            "locality",
            "region",
            "postcode",
            "country_code",
            "latitude",
            "longitude",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType8 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor8TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType8]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor8(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType8] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryInteractionType = Literal[
    "calendar-event",
    "call",
    "chat-thread",
    "email",
    "in-person-meeting",
    "meeting",
]
r"""The type of interaction e.g. calendar or email."""


PostV2ListsListEntriesQueryOwnerActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryOwnerActorTypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryOwnerActorType]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryOwnerActor(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryOwnerActorType] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeInteraction = Literal["interaction",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueInteractionTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor8TypedDict
    r"""The actor that created this value."""
    interaction_type: PostV2ListsListEntriesQueryInteractionType
    r"""The type of interaction e.g. calendar or email."""
    interacted_at: datetime
    r"""When the interaction occurred."""
    owner_actor: PostV2ListsListEntriesQueryOwnerActorTypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeInteraction
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueInteraction(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor8
    r"""The actor that created this value."""

    interaction_type: PostV2ListsListEntriesQueryInteractionType
    r"""The type of interaction e.g. calendar or email."""

    interacted_at: datetime
    r"""When the interaction occurred."""

    owner_actor: PostV2ListsListEntriesQueryOwnerActor
    r"""The actor that created this value."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeInteraction
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType7 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor7TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType7]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor7(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType7] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeRecordReference = Literal["record-reference",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueRecordReferenceTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor7TypedDict
    r"""The actor that created this value."""
    target_object: str
    r"""A slug identifying the object that the referenced record belongs to."""
    target_record_id: str
    r"""A UUID to identify the referenced record."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeRecordReference
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueRecordReference(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor7
    r"""The actor that created this value."""

    target_object: str
    r"""A slug identifying the object that the referenced record belongs to."""

    target_record_id: str
    r"""A UUID to identify the referenced record."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeRecordReference
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType6 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor6TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType6]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor6(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType6] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeEmailAddress = Literal["email-address",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueEmailAddressTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor6TypedDict
    r"""The actor that created this value."""
    original_email_address: str
    email_address: str
    email_domain: str
    email_root_domain: str
    email_local_specifier: str
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeEmailAddress
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueEmailAddress(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor6
    r"""The actor that created this value."""

    original_email_address: str

    email_address: str

    email_domain: str

    email_root_domain: str

    email_local_specifier: str

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeEmailAddress
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType5 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor5TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType5]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor5(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType5] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeDomain = Literal["domain",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueDomainTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor5TypedDict
    r"""The actor that created this value."""
    domain: str
    root_domain: str
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeDomain
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueDomain(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor5
    r"""The actor that created this value."""

    domain: str

    root_domain: str

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeDomain
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType4 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor4TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType4]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor4(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType4] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeDate = Literal["date",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueDateTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor4TypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeDate
    r"""The attribute type of the value."""
    value: str
    r"""A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, \"2023\" and \"2023-01\" will be coerced into \"2023-01-01\", and \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T14:00:00\", \"2023-01-02T15:00:00.000000000\", and \"2023-01-02T15:00:00.000000000+02:00\" will all be coerced to \"2023-01-02\". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value \"2023-01-02T23:00:00-10:00\" will be returned as \"2023-01-03\". The maximum date is \"9999-12-31\"."""


class PostV2ListsListEntriesQueryEntryValueDate(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor4
    r"""The actor that created this value."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeDate
    r"""The attribute type of the value."""

    value: str
    r"""A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, \"2023\" and \"2023-01\" will be coerced into \"2023-01-01\", and \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T14:00:00\", \"2023-01-02T15:00:00.000000000\", and \"2023-01-02T15:00:00.000000000+02:00\" will all be coerced to \"2023-01-02\". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value \"2023-01-02T23:00:00-10:00\" will be returned as \"2023-01-03\". The maximum date is \"9999-12-31\"."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType3 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor3TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType3]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor3(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType3] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCurrencyCode = Literal[
    "ARS",
    "AUD",
    "BRL",
    "BEL",
    "CAD",
    "CLP",
    "CNY",
    "COP",
    "CZK",
    "DKK",
    "EUR",
    "HKD",
    "ISK",
    "INR",
    "ILS",
    "JPY",
    "KRW",
    "MYR",
    "MXN",
    "NTD",
    "NZD",
    "NGN",
    "NOK",
    "XPF",
    "PEN",
    "PHP",
    "PLN",
    "GBP",
    "RWF",
    "SAR",
    "SGD",
    "ZAR",
    "SEK",
    "CHF",
    "AED",
    "UYU",
    "USD",
]
r"""The ISO4217 currency code representing the currency that the value is stored in."""


PostV2ListsListEntriesQueryAttributeTypeCurrency = Literal["currency",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueCurrencyTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor3TypedDict
    r"""The actor that created this value."""
    currency_value: float
    r"""A numerical representation of the currency value. A decimal with a max of 4 decimal places."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeCurrency
    r"""The attribute type of the value."""
    currency_code: NotRequired[Nullable[PostV2ListsListEntriesQueryCurrencyCode]]
    r"""The ISO4217 currency code representing the currency that the value is stored in."""


class PostV2ListsListEntriesQueryEntryValueCurrency(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor3
    r"""The actor that created this value."""

    currency_value: float
    r"""A numerical representation of the currency value. A decimal with a max of 4 decimal places."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeCurrency
    r"""The attribute type of the value."""

    currency_code: OptionalNullable[PostV2ListsListEntriesQueryCurrencyCode] = UNSET
    r"""The ISO4217 currency code representing the currency that the value is stored in."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["currency_code"]
        nullable_fields = ["active_until", "currency_code"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType2 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor2TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType2]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor2(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType2] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryAttributeTypeCheckbox = Literal["checkbox",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueCheckboxTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor2TypedDict
    r"""The actor that created this value."""
    value: bool
    r"""A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeCheckbox
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueCheckbox(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor2
    r"""The actor that created this value."""

    value: bool
    r"""A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeCheckbox
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryCreatedByActorType1 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor1TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesQueryCreatedByActorType1]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesQueryCreatedByActor1(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesQueryCreatedByActorType1] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryReferencedActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""


PostV2ListsListEntriesQueryAttributeTypeActorReference = Literal["actor-reference",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueActorReferenceTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor1TypedDict
    r"""The actor that created this value."""
    referenced_actor_type: PostV2ListsListEntriesQueryReferencedActorType
    r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""
    referenced_actor_id: Nullable[str]
    r"""The ID of the referenced actor."""
    attribute_type: PostV2ListsListEntriesQueryAttributeTypeActorReference
    r"""The attribute type of the value."""


class PostV2ListsListEntriesQueryEntryValueActorReference(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesQueryCreatedByActor1
    r"""The actor that created this value."""

    referenced_actor_type: PostV2ListsListEntriesQueryReferencedActorType
    r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""

    referenced_actor_id: Nullable[str]
    r"""The ID of the referenced actor."""

    attribute_type: PostV2ListsListEntriesQueryAttributeTypeActorReference
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until", "referenced_actor_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesQueryEntryValueUnionTypedDict = TypeAliasType(
    "PostV2ListsListEntriesQueryEntryValueUnionTypedDict",
    Union[
        PostV2ListsListEntriesQueryEntryValueNumberTypedDict,
        PostV2ListsListEntriesQueryEntryValueCheckboxTypedDict,
        PostV2ListsListEntriesQueryEntryValueTimestampTypedDict,
        PostV2ListsListEntriesQueryEntryValueDateTypedDict,
        PostV2ListsListEntriesQueryEntryValueTextTypedDict,
        PostV2ListsListEntriesQueryEntryValueSelectTypedDict,
        PostV2ListsListEntriesQueryEntryValueRatingTypedDict,
        PostV2ListsListEntriesQueryEntryValueStatusTypedDict,
        PostV2ListsListEntriesQueryEntryValueDomainTypedDict,
        PostV2ListsListEntriesQueryEntryValueRecordReferenceTypedDict,
        PostV2ListsListEntriesQueryEntryValueActorReferenceTypedDict,
        PostV2ListsListEntriesQueryEntryValueCurrencyTypedDict,
        PostV2ListsListEntriesQueryEntryValuePersonalNameTypedDict,
        PostV2ListsListEntriesQueryEntryValuePhoneNumberTypedDict,
        PostV2ListsListEntriesQueryEntryValueInteractionTypedDict,
        PostV2ListsListEntriesQueryEntryValueEmailAddressTypedDict,
        PostV2ListsListEntriesQueryEntryValueLocationTypedDict,
    ],
)


PostV2ListsListEntriesQueryEntryValueUnion = TypeAliasType(
    "PostV2ListsListEntriesQueryEntryValueUnion",
    Union[
        PostV2ListsListEntriesQueryEntryValueNumber,
        PostV2ListsListEntriesQueryEntryValueCheckbox,
        PostV2ListsListEntriesQueryEntryValueTimestamp,
        PostV2ListsListEntriesQueryEntryValueDate,
        PostV2ListsListEntriesQueryEntryValueText,
        PostV2ListsListEntriesQueryEntryValueSelect,
        PostV2ListsListEntriesQueryEntryValueRating,
        PostV2ListsListEntriesQueryEntryValueStatus,
        PostV2ListsListEntriesQueryEntryValueDomain,
        PostV2ListsListEntriesQueryEntryValueRecordReference,
        PostV2ListsListEntriesQueryEntryValueActorReference,
        PostV2ListsListEntriesQueryEntryValueCurrency,
        PostV2ListsListEntriesQueryEntryValuePersonalName,
        PostV2ListsListEntriesQueryEntryValuePhoneNumber,
        PostV2ListsListEntriesQueryEntryValueInteraction,
        PostV2ListsListEntriesQueryEntryValueEmailAddress,
        PostV2ListsListEntriesQueryEntryValueLocation,
    ],
)


class PostV2ListsListEntriesQueryDataTypedDict(TypedDict):
    id: PostV2ListsListEntriesQueryIDTypedDict
    parent_record_id: str
    r"""A UUID identifying the record that is parent of the list entry."""
    parent_object: str
    r"""A UUID or slug identifying the object that the parent record belongs to."""
    created_at: str
    r"""When this entry was created."""
    entry_values: Dict[str, List[PostV2ListsListEntriesQueryEntryValueUnionTypedDict]]
    r"""A list of attribute values for the list entry (not attribute values for its parent record)."""


class PostV2ListsListEntriesQueryData(BaseModel):
    id: PostV2ListsListEntriesQueryID

    parent_record_id: str
    r"""A UUID identifying the record that is parent of the list entry."""

    parent_object: str
    r"""A UUID or slug identifying the object that the parent record belongs to."""

    created_at: str
    r"""When this entry was created."""

    entry_values: Dict[str, List[PostV2ListsListEntriesQueryEntryValueUnion]]
    r"""A list of attribute values for the list entry (not attribute values for its parent record)."""


class PostV2ListsListEntriesQueryResponseTypedDict(TypedDict):
    r"""Success"""

    data: List[PostV2ListsListEntriesQueryDataTypedDict]


class PostV2ListsListEntriesQueryResponse(BaseModel):
    r"""Success"""

    data: List[PostV2ListsListEntriesQueryData]
