"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .select_option import SelectOption, SelectOptionTypedDict
from .status import Status, StatusTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from attio.utils import FieldMetadata, PathParamMetadata, RequestMetadata
from datetime import datetime
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Literal, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class PostV2ListsListEntriesDataRequestTypedDict(TypedDict):
    parent_record_id: str
    r"""A UUID identifying the record you want to add to the list. The record will become the 'parent' of the created list entry."""
    parent_object: str
    r"""A UUID or slug identifying the object that the added parent record belongs to."""
    entry_values: Dict[str, List[Any]]
    r"""An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types)."""


class PostV2ListsListEntriesDataRequest(BaseModel):
    parent_record_id: str
    r"""A UUID identifying the record you want to add to the list. The record will become the 'parent' of the created list entry."""

    parent_object: str
    r"""A UUID or slug identifying the object that the added parent record belongs to."""

    entry_values: Dict[str, List[Any]]
    r"""An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types)."""


class PostV2ListsListEntriesRequestBodyTypedDict(TypedDict):
    data: PostV2ListsListEntriesDataRequestTypedDict


class PostV2ListsListEntriesRequestBody(BaseModel):
    data: PostV2ListsListEntriesDataRequest


class PostV2ListsListEntriesRequestTypedDict(TypedDict):
    list_id: str
    request_body: PostV2ListsListEntriesRequestBodyTypedDict


class PostV2ListsListEntriesRequest(BaseModel):
    list_id: Annotated[
        str,
        pydantic.Field(alias="list"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    request_body: Annotated[
        PostV2ListsListEntriesRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


PostV2ListsListEntriesNotFoundType = Literal["invalid_request_error",]


PostV2ListsListEntriesNotFoundCode = Literal["not_found",]


PostV2ListsListEntriesBadRequestType = Literal["invalid_request_error",]


PostV2ListsListEntriesCodeValueNotFound = Literal["value_not_found",]


class PostV2ListsListEntriesIDTypedDict(TypedDict):
    workspace_id: str
    r"""A UUID identifying the workspace this entry belongs to."""
    list_id: str
    r"""A UUID identifying the list this entry is in."""
    entry_id: str
    r"""A UUID identifying this entry."""


class PostV2ListsListEntriesID(BaseModel):
    workspace_id: str
    r"""A UUID identifying the workspace this entry belongs to."""

    list_id: str
    r"""A UUID identifying the list this entry is in."""

    entry_id: str
    r"""A UUID identifying this entry."""


PostV2ListsListEntriesCreatedByActorType17 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor17TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType17]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor17(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType17] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeTimestamp = Literal["timestamp",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueTimestampTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor17TypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ListsListEntriesAttributeTypeTimestamp
    r"""The attribute type of the value."""
    value: str
    r"""A timestamp string value"""


class PostV2ListsListEntriesEntryValueTimestamp(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor17
    r"""The actor that created this value."""

    attribute_type: PostV2ListsListEntriesAttributeTypeTimestamp
    r"""The attribute type of the value."""

    value: str
    r"""A timestamp string value"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType16 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor16TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType16]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor16(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType16] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeText = Literal["text",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueTextTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor16TypedDict
    r"""The actor that created this value."""
    value: str
    r"""A raw text field. Values are limited to 10MB."""
    attribute_type: PostV2ListsListEntriesAttributeTypeText
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueText(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor16
    r"""The actor that created this value."""

    value: str
    r"""A raw text field. Values are limited to 10MB."""

    attribute_type: PostV2ListsListEntriesAttributeTypeText
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType15 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor15TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType15]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor15(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType15] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeSelect = Literal["select",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueSelectTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor15TypedDict
    r"""The actor that created this value."""
    option: SelectOptionTypedDict
    attribute_type: PostV2ListsListEntriesAttributeTypeSelect
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueSelect(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor15
    r"""The actor that created this value."""

    option: SelectOption

    attribute_type: PostV2ListsListEntriesAttributeTypeSelect
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType14 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor14TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType14]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor14(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType14] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeRating = Literal["rating",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueRatingTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor14TypedDict
    r"""The actor that created this value."""
    value: float
    r"""A number between 0 and 5 (inclusive) to represent a star rating."""
    attribute_type: PostV2ListsListEntriesAttributeTypeRating
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueRating(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor14
    r"""The actor that created this value."""

    value: float
    r"""A number between 0 and 5 (inclusive) to represent a star rating."""

    attribute_type: PostV2ListsListEntriesAttributeTypeRating
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType13 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor13TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType13]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor13(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType13] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeStatus = Literal["status",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueStatusTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor13TypedDict
    r"""The actor that created this value."""
    status: StatusTypedDict
    attribute_type: PostV2ListsListEntriesAttributeTypeStatus
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueStatus(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor13
    r"""The actor that created this value."""

    status: Status

    attribute_type: PostV2ListsListEntriesAttributeTypeStatus
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType12 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor12TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType12]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor12(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType12] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCountryCode2 = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""


PostV2ListsListEntriesAttributeTypePhoneNumber = Literal["phone-number",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValuePhoneNumberTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor12TypedDict
    r"""The actor that created this value."""
    original_phone_number: str
    r"""The raw, original phone number, as inputted."""
    country_code: PostV2ListsListEntriesCountryCode2
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""
    phone_number: str
    attribute_type: PostV2ListsListEntriesAttributeTypePhoneNumber
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValuePhoneNumber(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor12
    r"""The actor that created this value."""

    original_phone_number: str
    r"""The raw, original phone number, as inputted."""

    country_code: PostV2ListsListEntriesCountryCode2
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""

    phone_number: str

    attribute_type: PostV2ListsListEntriesAttributeTypePhoneNumber
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType11 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor11TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType11]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor11(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType11] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypePersonalName = Literal["personal-name",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValuePersonalNameTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor11TypedDict
    r"""The actor that created this value."""
    first_name: str
    r"""The first name."""
    last_name: str
    r"""The last name."""
    full_name: str
    r"""The full name."""
    attribute_type: PostV2ListsListEntriesAttributeTypePersonalName
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValuePersonalName(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor11
    r"""The actor that created this value."""

    first_name: str
    r"""The first name."""

    last_name: str
    r"""The last name."""

    full_name: str
    r"""The full name."""

    attribute_type: PostV2ListsListEntriesAttributeTypePersonalName
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType10 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor10TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType10]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor10(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType10] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeNumber = Literal["number",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueNumberTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor10TypedDict
    r"""The actor that created this value."""
    value: float
    r"""Numbers are persisted as 64 bit floats."""
    attribute_type: PostV2ListsListEntriesAttributeTypeNumber
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueNumber(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor10
    r"""The actor that created this value."""

    value: float
    r"""Numbers are persisted as 64 bit floats."""

    attribute_type: PostV2ListsListEntriesAttributeTypeNumber
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType9 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor9TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType9]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor9(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType9] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCountryCode1 = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""


PostV2ListsListEntriesAttributeTypeLocation = Literal["location",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueLocationTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor9TypedDict
    r"""The actor that created this value."""
    line_1: Nullable[str]
    r"""The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_2: Nullable[str]
    r"""The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_3: Nullable[str]
    r"""The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_4: Nullable[str]
    r"""The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    locality: Nullable[str]
    r"""The town, neighborhood or area the location is in."""
    region: Nullable[str]
    r"""The state, county, province or region that the location is in."""
    postcode: Nullable[str]
    r"""The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    country_code: Nullable[PostV2ListsListEntriesCountryCode1]
    r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""
    latitude: Nullable[str]
    r"""The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    longitude: Nullable[str]
    r"""The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    attribute_type: PostV2ListsListEntriesAttributeTypeLocation
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueLocation(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor9
    r"""The actor that created this value."""

    line_1: Nullable[str]
    r"""The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_2: Nullable[str]
    r"""The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_3: Nullable[str]
    r"""The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_4: Nullable[str]
    r"""The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    locality: Nullable[str]
    r"""The town, neighborhood or area the location is in."""

    region: Nullable[str]
    r"""The state, county, province or region that the location is in."""

    postcode: Nullable[str]
    r"""The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    country_code: Nullable[PostV2ListsListEntriesCountryCode1]
    r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""

    latitude: Nullable[str]
    r"""The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    longitude: Nullable[str]
    r"""The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    attribute_type: PostV2ListsListEntriesAttributeTypeLocation
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "active_until",
            "line_1",
            "line_2",
            "line_3",
            "line_4",
            "locality",
            "region",
            "postcode",
            "country_code",
            "latitude",
            "longitude",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType8 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor8TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType8]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor8(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType8] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesInteractionType = Literal[
    "calendar-event",
    "call",
    "chat-thread",
    "email",
    "in-person-meeting",
    "meeting",
]
r"""The type of interaction e.g. calendar or email."""


PostV2ListsListEntriesOwnerActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesOwnerActorTypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesOwnerActorType]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesOwnerActor(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesOwnerActorType] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeInteraction = Literal["interaction",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueInteractionTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor8TypedDict
    r"""The actor that created this value."""
    interaction_type: PostV2ListsListEntriesInteractionType
    r"""The type of interaction e.g. calendar or email."""
    interacted_at: datetime
    r"""When the interaction occurred."""
    owner_actor: PostV2ListsListEntriesOwnerActorTypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ListsListEntriesAttributeTypeInteraction
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueInteraction(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor8
    r"""The actor that created this value."""

    interaction_type: PostV2ListsListEntriesInteractionType
    r"""The type of interaction e.g. calendar or email."""

    interacted_at: datetime
    r"""When the interaction occurred."""

    owner_actor: PostV2ListsListEntriesOwnerActor
    r"""The actor that created this value."""

    attribute_type: PostV2ListsListEntriesAttributeTypeInteraction
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType7 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor7TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType7]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor7(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType7] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeRecordReference = Literal["record-reference",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueRecordReferenceTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor7TypedDict
    r"""The actor that created this value."""
    target_object: str
    r"""A slug identifying the object that the referenced record belongs to."""
    target_record_id: str
    r"""A UUID to identify the referenced record."""
    attribute_type: PostV2ListsListEntriesAttributeTypeRecordReference
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueRecordReference(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor7
    r"""The actor that created this value."""

    target_object: str
    r"""A slug identifying the object that the referenced record belongs to."""

    target_record_id: str
    r"""A UUID to identify the referenced record."""

    attribute_type: PostV2ListsListEntriesAttributeTypeRecordReference
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType6 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor6TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType6]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor6(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType6] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeEmailAddress = Literal["email-address",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueEmailAddressTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor6TypedDict
    r"""The actor that created this value."""
    original_email_address: str
    email_address: str
    email_domain: str
    email_root_domain: str
    email_local_specifier: str
    attribute_type: PostV2ListsListEntriesAttributeTypeEmailAddress
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueEmailAddress(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor6
    r"""The actor that created this value."""

    original_email_address: str

    email_address: str

    email_domain: str

    email_root_domain: str

    email_local_specifier: str

    attribute_type: PostV2ListsListEntriesAttributeTypeEmailAddress
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType5 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor5TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType5]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor5(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType5] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeDomain = Literal["domain",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueDomainTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor5TypedDict
    r"""The actor that created this value."""
    domain: str
    root_domain: str
    attribute_type: PostV2ListsListEntriesAttributeTypeDomain
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueDomain(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor5
    r"""The actor that created this value."""

    domain: str

    root_domain: str

    attribute_type: PostV2ListsListEntriesAttributeTypeDomain
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType4 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor4TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType4]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor4(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType4] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeDate = Literal["date",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueDateTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor4TypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ListsListEntriesAttributeTypeDate
    r"""The attribute type of the value."""
    value: str
    r"""A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, \"2023\" and \"2023-01\" will be coerced into \"2023-01-01\", and \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T14:00:00\", \"2023-01-02T15:00:00.000000000\", and \"2023-01-02T15:00:00.000000000+02:00\" will all be coerced to \"2023-01-02\". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value \"2023-01-02T23:00:00-10:00\" will be returned as \"2023-01-03\". The maximum date is \"9999-12-31\"."""


class PostV2ListsListEntriesEntryValueDate(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor4
    r"""The actor that created this value."""

    attribute_type: PostV2ListsListEntriesAttributeTypeDate
    r"""The attribute type of the value."""

    value: str
    r"""A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, \"2023\" and \"2023-01\" will be coerced into \"2023-01-01\", and \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T14:00:00\", \"2023-01-02T15:00:00.000000000\", and \"2023-01-02T15:00:00.000000000+02:00\" will all be coerced to \"2023-01-02\". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value \"2023-01-02T23:00:00-10:00\" will be returned as \"2023-01-03\". The maximum date is \"9999-12-31\"."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType3 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor3TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType3]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor3(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType3] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCurrencyCode = Literal[
    "ARS",
    "AUD",
    "BRL",
    "BEL",
    "CAD",
    "CLP",
    "CNY",
    "COP",
    "CZK",
    "DKK",
    "EUR",
    "HKD",
    "ISK",
    "INR",
    "ILS",
    "JPY",
    "KRW",
    "MYR",
    "MXN",
    "NTD",
    "NZD",
    "NGN",
    "NOK",
    "XPF",
    "PEN",
    "PHP",
    "PLN",
    "GBP",
    "RWF",
    "SAR",
    "SGD",
    "ZAR",
    "SEK",
    "CHF",
    "AED",
    "UYU",
    "USD",
]
r"""The ISO4217 currency code representing the currency that the value is stored in."""


PostV2ListsListEntriesAttributeTypeCurrency = Literal["currency",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueCurrencyTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor3TypedDict
    r"""The actor that created this value."""
    currency_value: float
    r"""A numerical representation of the currency value. A decimal with a max of 4 decimal places."""
    attribute_type: PostV2ListsListEntriesAttributeTypeCurrency
    r"""The attribute type of the value."""
    currency_code: NotRequired[Nullable[PostV2ListsListEntriesCurrencyCode]]
    r"""The ISO4217 currency code representing the currency that the value is stored in."""


class PostV2ListsListEntriesEntryValueCurrency(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor3
    r"""The actor that created this value."""

    currency_value: float
    r"""A numerical representation of the currency value. A decimal with a max of 4 decimal places."""

    attribute_type: PostV2ListsListEntriesAttributeTypeCurrency
    r"""The attribute type of the value."""

    currency_code: OptionalNullable[PostV2ListsListEntriesCurrencyCode] = UNSET
    r"""The ISO4217 currency code representing the currency that the value is stored in."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["currency_code"]
        nullable_fields = ["active_until", "currency_code"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType2 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor2TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType2]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor2(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType2] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesAttributeTypeCheckbox = Literal["checkbox",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueCheckboxTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor2TypedDict
    r"""The actor that created this value."""
    value: bool
    r"""A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted."""
    attribute_type: PostV2ListsListEntriesAttributeTypeCheckbox
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueCheckbox(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor2
    r"""The actor that created this value."""

    value: bool
    r"""A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted."""

    attribute_type: PostV2ListsListEntriesAttributeTypeCheckbox
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesCreatedByActorType1 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor1TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ListsListEntriesCreatedByActorType1]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ListsListEntriesCreatedByActor1(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ListsListEntriesCreatedByActorType1] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesReferencedActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""


PostV2ListsListEntriesAttributeTypeActorReference = Literal["actor-reference",]
r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueActorReferenceTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ListsListEntriesCreatedByActor1TypedDict
    r"""The actor that created this value."""
    referenced_actor_type: PostV2ListsListEntriesReferencedActorType
    r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""
    referenced_actor_id: Nullable[str]
    r"""The ID of the referenced actor."""
    attribute_type: PostV2ListsListEntriesAttributeTypeActorReference
    r"""The attribute type of the value."""


class PostV2ListsListEntriesEntryValueActorReference(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ListsListEntriesCreatedByActor1
    r"""The actor that created this value."""

    referenced_actor_type: PostV2ListsListEntriesReferencedActorType
    r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""

    referenced_actor_id: Nullable[str]
    r"""The ID of the referenced actor."""

    attribute_type: PostV2ListsListEntriesAttributeTypeActorReference
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until", "referenced_actor_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ListsListEntriesEntryValueUnionTypedDict = TypeAliasType(
    "PostV2ListsListEntriesEntryValueUnionTypedDict",
    Union[
        PostV2ListsListEntriesEntryValueNumberTypedDict,
        PostV2ListsListEntriesEntryValueCheckboxTypedDict,
        PostV2ListsListEntriesEntryValueTimestampTypedDict,
        PostV2ListsListEntriesEntryValueDateTypedDict,
        PostV2ListsListEntriesEntryValueTextTypedDict,
        PostV2ListsListEntriesEntryValueSelectTypedDict,
        PostV2ListsListEntriesEntryValueRatingTypedDict,
        PostV2ListsListEntriesEntryValueStatusTypedDict,
        PostV2ListsListEntriesEntryValueDomainTypedDict,
        PostV2ListsListEntriesEntryValueRecordReferenceTypedDict,
        PostV2ListsListEntriesEntryValueActorReferenceTypedDict,
        PostV2ListsListEntriesEntryValueCurrencyTypedDict,
        PostV2ListsListEntriesEntryValuePersonalNameTypedDict,
        PostV2ListsListEntriesEntryValuePhoneNumberTypedDict,
        PostV2ListsListEntriesEntryValueInteractionTypedDict,
        PostV2ListsListEntriesEntryValueEmailAddressTypedDict,
        PostV2ListsListEntriesEntryValueLocationTypedDict,
    ],
)


PostV2ListsListEntriesEntryValueUnion = TypeAliasType(
    "PostV2ListsListEntriesEntryValueUnion",
    Union[
        PostV2ListsListEntriesEntryValueNumber,
        PostV2ListsListEntriesEntryValueCheckbox,
        PostV2ListsListEntriesEntryValueTimestamp,
        PostV2ListsListEntriesEntryValueDate,
        PostV2ListsListEntriesEntryValueText,
        PostV2ListsListEntriesEntryValueSelect,
        PostV2ListsListEntriesEntryValueRating,
        PostV2ListsListEntriesEntryValueStatus,
        PostV2ListsListEntriesEntryValueDomain,
        PostV2ListsListEntriesEntryValueRecordReference,
        PostV2ListsListEntriesEntryValueActorReference,
        PostV2ListsListEntriesEntryValueCurrency,
        PostV2ListsListEntriesEntryValuePersonalName,
        PostV2ListsListEntriesEntryValuePhoneNumber,
        PostV2ListsListEntriesEntryValueInteraction,
        PostV2ListsListEntriesEntryValueEmailAddress,
        PostV2ListsListEntriesEntryValueLocation,
    ],
)


class PostV2ListsListEntriesDataResponseTypedDict(TypedDict):
    id: PostV2ListsListEntriesIDTypedDict
    parent_record_id: str
    r"""A UUID identifying the record that is parent of the list entry."""
    parent_object: str
    r"""A UUID or slug identifying the object that the parent record belongs to."""
    created_at: str
    r"""When this entry was created."""
    entry_values: Dict[str, List[PostV2ListsListEntriesEntryValueUnionTypedDict]]
    r"""A list of attribute values for the list entry (not attribute values for its parent record)."""


class PostV2ListsListEntriesDataResponse(BaseModel):
    id: PostV2ListsListEntriesID

    parent_record_id: str
    r"""A UUID identifying the record that is parent of the list entry."""

    parent_object: str
    r"""A UUID or slug identifying the object that the parent record belongs to."""

    created_at: str
    r"""When this entry was created."""

    entry_values: Dict[str, List[PostV2ListsListEntriesEntryValueUnion]]
    r"""A list of attribute values for the list entry (not attribute values for its parent record)."""


class PostV2ListsListEntriesResponseTypedDict(TypedDict):
    r"""Success"""

    data: PostV2ListsListEntriesDataResponseTypedDict


class PostV2ListsListEntriesResponse(BaseModel):
    r"""Success"""

    data: PostV2ListsListEntriesDataResponse
