"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .list import ListT, ListTTypedDict
from attio.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Literal
from typing_extensions import TypedDict


PostV2ListsWorkspaceAccess = Literal[
    "full-access",
    "read-and-write",
    "read-only",
]
r"""The level of access granted to all members of the workspace for this list. Pass `null` to keep the list private and only grant access to specific workspace members."""


PostV2ListsLevel = Literal[
    "full-access",
    "read-and-write",
    "read-only",
]
r"""The level of access to the list."""


class PostV2ListsWorkspaceMemberAccessTypedDict(TypedDict):
    workspace_member_id: str
    r"""A UUID to identify the workspace member to grant access to."""
    level: PostV2ListsLevel
    r"""The level of access to the list."""


class PostV2ListsWorkspaceMemberAccess(BaseModel):
    workspace_member_id: str
    r"""A UUID to identify the workspace member to grant access to."""

    level: PostV2ListsLevel
    r"""The level of access to the list."""


class PostV2ListsDataTypedDict(TypedDict):
    name: str
    r"""The human-readable name of the list."""
    api_slug: str
    r"""A unique, human-readable slug to access the list through API calls. Should be formatted in snake case."""
    parent_object: str
    r"""A UUID or slug to identify the allowed object type for records added to this list."""
    workspace_access: Nullable[PostV2ListsWorkspaceAccess]
    r"""The level of access granted to all members of the workspace for this list. Pass `null` to keep the list private and only grant access to specific workspace members."""
    workspace_member_access: List[PostV2ListsWorkspaceMemberAccessTypedDict]
    r"""The level of access granted to specific workspace members for this list. Pass an empty array to grant access to no workspace members."""


class PostV2ListsData(BaseModel):
    name: str
    r"""The human-readable name of the list."""

    api_slug: str
    r"""A unique, human-readable slug to access the list through API calls. Should be formatted in snake case."""

    parent_object: str
    r"""A UUID or slug to identify the allowed object type for records added to this list."""

    workspace_access: Nullable[PostV2ListsWorkspaceAccess]
    r"""The level of access granted to all members of the workspace for this list. Pass `null` to keep the list private and only grant access to specific workspace members."""

    workspace_member_access: List[PostV2ListsWorkspaceMemberAccess]
    r"""The level of access granted to specific workspace members for this list. Pass an empty array to grant access to no workspace members."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["workspace_access"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2ListsRequestTypedDict(TypedDict):
    data: PostV2ListsDataTypedDict


class PostV2ListsRequest(BaseModel):
    data: PostV2ListsData


PostV2ListsConflictType = Literal["invalid_request_error",]


PostV2ListsConflictCode = Literal["slug_conflict",]


PostV2ListsNotFoundType = Literal["invalid_request_error",]


PostV2ListsNotFoundCode = Literal["not_found",]


ForbiddenType = Literal["auth_error",]


ForbiddenCode = Literal["billing_error",]


PostV2ListsBadRequestType = Literal["invalid_request_error",]


PostV2ListsCodeValueNotFound = Literal["value_not_found",]


class PostV2ListsResponseTypedDict(TypedDict):
    r"""Success"""

    data: ListTTypedDict


class PostV2ListsResponse(BaseModel):
    r"""Success"""

    data: ListT
