"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .select_option import SelectOption, SelectOptionTypedDict
from .status import Status, StatusTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from attio.utils import FieldMetadata, PathParamMetadata, RequestMetadata
from datetime import datetime
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


PostV2ObjectsObjectRecordsQueryDirection2 = Literal[
    "asc",
    "desc",
]
r"""The direction to sort the results by."""


class PostV2ObjectsObjectRecordsQuerySort2TypedDict(TypedDict):
    r"""Sort by path"""

    direction: PostV2ObjectsObjectRecordsQueryDirection2
    r"""The direction to sort the results by."""
    path: List[List[str]]
    r"""You may use the `path` property to traverse record reference attributes and parent records on list entries. `path` accepts an array of tuples where the first element of each tuple is the slug or ID of a list/object, and the second element is the slug or ID of an attribute on that list/object. The first element of the first tuple must correspond to the list or object that you are querying. For example, if you wanted to sort by the name of the parent record (a company) on a list with the slug \"sales\", you would pass the value `[['sales', 'parent_record'], ['companies', 'name']]`."""
    field: NotRequired[str]
    r"""Which field on the value to sort by e.g. \"last_name\" on a name value."""


class PostV2ObjectsObjectRecordsQuerySort2(BaseModel):
    r"""Sort by path"""

    direction: PostV2ObjectsObjectRecordsQueryDirection2
    r"""The direction to sort the results by."""

    path: List[List[str]]
    r"""You may use the `path` property to traverse record reference attributes and parent records on list entries. `path` accepts an array of tuples where the first element of each tuple is the slug or ID of a list/object, and the second element is the slug or ID of an attribute on that list/object. The first element of the first tuple must correspond to the list or object that you are querying. For example, if you wanted to sort by the name of the parent record (a company) on a list with the slug \"sales\", you would pass the value `[['sales', 'parent_record'], ['companies', 'name']]`."""

    field: Optional[str] = None
    r"""Which field on the value to sort by e.g. \"last_name\" on a name value."""


PostV2ObjectsObjectRecordsQueryDirection1 = Literal[
    "asc",
    "desc",
]
r"""The direction to sort the results by."""


class PostV2ObjectsObjectRecordsQuerySort1TypedDict(TypedDict):
    r"""Sort by attribute"""

    direction: PostV2ObjectsObjectRecordsQueryDirection1
    r"""The direction to sort the results by."""
    attribute: str
    r"""A slug or ID to identify the attribute to sort by."""
    field: NotRequired[str]
    r"""Which field on the value to sort by e.g. \"last_name\" on a name value."""


class PostV2ObjectsObjectRecordsQuerySort1(BaseModel):
    r"""Sort by attribute"""

    direction: PostV2ObjectsObjectRecordsQueryDirection1
    r"""The direction to sort the results by."""

    attribute: str
    r"""A slug or ID to identify the attribute to sort by."""

    field: Optional[str] = None
    r"""Which field on the value to sort by e.g. \"last_name\" on a name value."""


PostV2ObjectsObjectRecordsQuerySortUnionTypedDict = TypeAliasType(
    "PostV2ObjectsObjectRecordsQuerySortUnionTypedDict",
    Union[
        PostV2ObjectsObjectRecordsQuerySort1TypedDict,
        PostV2ObjectsObjectRecordsQuerySort2TypedDict,
    ],
)


PostV2ObjectsObjectRecordsQuerySortUnion = TypeAliasType(
    "PostV2ObjectsObjectRecordsQuerySortUnion",
    Union[PostV2ObjectsObjectRecordsQuerySort1, PostV2ObjectsObjectRecordsQuerySort2],
)


class PostV2ObjectsObjectRecordsQueryRequestBodyTypedDict(TypedDict):
    filter_: NotRequired[Dict[str, Any]]
    r"""An object used to filter results to a subset of results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting)."""
    sorts: NotRequired[List[PostV2ObjectsObjectRecordsQuerySortUnionTypedDict]]
    r"""An object used to sort results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting)."""
    limit: NotRequired[float]
    r"""The maximum number of results to return. Defaults to 500. See the [full guide to pagination here](/rest-api/how-to/pagination)."""
    offset: NotRequired[float]
    r"""The number of results to skip over before returning. Defaults to 0. See the [full guide to pagination here](/rest-api/how-to/pagination)."""


class PostV2ObjectsObjectRecordsQueryRequestBody(BaseModel):
    filter_: Annotated[Optional[Dict[str, Any]], pydantic.Field(alias="filter")] = None
    r"""An object used to filter results to a subset of results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting)."""

    sorts: Optional[List[PostV2ObjectsObjectRecordsQuerySortUnion]] = None
    r"""An object used to sort results. See the [full guide to filtering and sorting here](/rest-api/how-to/filtering-and-sorting)."""

    limit: Optional[float] = None
    r"""The maximum number of results to return. Defaults to 500. See the [full guide to pagination here](/rest-api/how-to/pagination)."""

    offset: Optional[float] = None
    r"""The number of results to skip over before returning. Defaults to 0. See the [full guide to pagination here](/rest-api/how-to/pagination)."""


class PostV2ObjectsObjectRecordsQueryRequestTypedDict(TypedDict):
    object: str
    request_body: PostV2ObjectsObjectRecordsQueryRequestBodyTypedDict


class PostV2ObjectsObjectRecordsQueryRequest(BaseModel):
    object: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    request_body: Annotated[
        PostV2ObjectsObjectRecordsQueryRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


PostV2ObjectsObjectRecordsQueryNotFoundType = Literal["invalid_request_error",]


PostV2ObjectsObjectRecordsQueryNotFoundCode = Literal["not_found",]


PostV2ObjectsObjectRecordsQueryBadRequestType = Literal["invalid_request_error",]


CodeFilterError = Literal["filter_error",]


class PostV2ObjectsObjectRecordsQueryIDTypedDict(TypedDict):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""
    object_id: str
    r"""A UUID identifying the object this record belongs to."""
    record_id: str
    r"""A UUID identifying this record."""


class PostV2ObjectsObjectRecordsQueryID(BaseModel):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""

    object_id: str
    r"""A UUID identifying the object this record belongs to."""

    record_id: str
    r"""A UUID identifying this record."""


PostV2ObjectsObjectRecordsQueryCreatedByActorType17 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor17TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType17]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor17(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType17] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeTimestamp = Literal["timestamp",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueTimestampTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor17TypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeTimestamp
    r"""The attribute type of the value."""
    value: str
    r"""A timestamp string value"""


class PostV2ObjectsObjectRecordsQueryValueTimestamp(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor17
    r"""The actor that created this value."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeTimestamp
    r"""The attribute type of the value."""

    value: str
    r"""A timestamp string value"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType16 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor16TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType16]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor16(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType16] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeText = Literal["text",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueTextTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor16TypedDict
    r"""The actor that created this value."""
    value: str
    r"""A raw text field. Values are limited to 10MB."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeText
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueText(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor16
    r"""The actor that created this value."""

    value: str
    r"""A raw text field. Values are limited to 10MB."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeText
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType15 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor15TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType15]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor15(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType15] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeSelect = Literal["select",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueSelectTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor15TypedDict
    r"""The actor that created this value."""
    option: SelectOptionTypedDict
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeSelect
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueSelect(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor15
    r"""The actor that created this value."""

    option: SelectOption

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeSelect
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType14 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor14TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType14]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor14(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType14] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeRating = Literal["rating",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueRatingTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor14TypedDict
    r"""The actor that created this value."""
    value: float
    r"""A number between 0 and 5 (inclusive) to represent a star rating."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeRating
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueRating(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor14
    r"""The actor that created this value."""

    value: float
    r"""A number between 0 and 5 (inclusive) to represent a star rating."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeRating
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType13 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor13TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType13]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor13(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType13] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeStatus = Literal["status",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueStatusTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor13TypedDict
    r"""The actor that created this value."""
    status: StatusTypedDict
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeStatus
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueStatus(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor13
    r"""The actor that created this value."""

    status: Status

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeStatus
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType12 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor12TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType12]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor12(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType12] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCountryCode2 = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""


PostV2ObjectsObjectRecordsQueryAttributeTypePhoneNumber = Literal["phone-number",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValuePhoneNumberTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor12TypedDict
    r"""The actor that created this value."""
    original_phone_number: str
    r"""The raw, original phone number, as inputted."""
    country_code: PostV2ObjectsObjectRecordsQueryCountryCode2
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""
    phone_number: str
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypePhoneNumber
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValuePhoneNumber(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor12
    r"""The actor that created this value."""

    original_phone_number: str
    r"""The raw, original phone number, as inputted."""

    country_code: PostV2ObjectsObjectRecordsQueryCountryCode2
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""

    phone_number: str

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypePhoneNumber
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType11 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor11TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType11]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor11(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType11] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypePersonalName = Literal["personal-name",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValuePersonalNameTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor11TypedDict
    r"""The actor that created this value."""
    first_name: str
    r"""The first name."""
    last_name: str
    r"""The last name."""
    full_name: str
    r"""The full name."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypePersonalName
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValuePersonalName(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor11
    r"""The actor that created this value."""

    first_name: str
    r"""The first name."""

    last_name: str
    r"""The last name."""

    full_name: str
    r"""The full name."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypePersonalName
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType10 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor10TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType10]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor10(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType10] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeNumber = Literal["number",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueNumberTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor10TypedDict
    r"""The actor that created this value."""
    value: float
    r"""Numbers are persisted as 64 bit floats."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeNumber
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueNumber(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor10
    r"""The actor that created this value."""

    value: float
    r"""Numbers are persisted as 64 bit floats."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeNumber
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType9 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor9TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType9]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor9(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType9] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCountryCode1 = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""


PostV2ObjectsObjectRecordsQueryAttributeTypeLocation = Literal["location",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueLocationTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor9TypedDict
    r"""The actor that created this value."""
    line_1: Nullable[str]
    r"""The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_2: Nullable[str]
    r"""The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_3: Nullable[str]
    r"""The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_4: Nullable[str]
    r"""The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    locality: Nullable[str]
    r"""The town, neighborhood or area the location is in."""
    region: Nullable[str]
    r"""The state, county, province or region that the location is in."""
    postcode: Nullable[str]
    r"""The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    country_code: Nullable[PostV2ObjectsObjectRecordsQueryCountryCode1]
    r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""
    latitude: Nullable[str]
    r"""The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    longitude: Nullable[str]
    r"""The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeLocation
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueLocation(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor9
    r"""The actor that created this value."""

    line_1: Nullable[str]
    r"""The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_2: Nullable[str]
    r"""The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_3: Nullable[str]
    r"""The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_4: Nullable[str]
    r"""The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    locality: Nullable[str]
    r"""The town, neighborhood or area the location is in."""

    region: Nullable[str]
    r"""The state, county, province or region that the location is in."""

    postcode: Nullable[str]
    r"""The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    country_code: Nullable[PostV2ObjectsObjectRecordsQueryCountryCode1]
    r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""

    latitude: Nullable[str]
    r"""The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    longitude: Nullable[str]
    r"""The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeLocation
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "active_until",
            "line_1",
            "line_2",
            "line_3",
            "line_4",
            "locality",
            "region",
            "postcode",
            "country_code",
            "latitude",
            "longitude",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType8 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor8TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType8]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor8(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType8] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryInteractionType = Literal[
    "calendar-event",
    "call",
    "chat-thread",
    "email",
    "in-person-meeting",
    "meeting",
]
r"""The type of interaction e.g. calendar or email."""


PostV2ObjectsObjectRecordsQueryOwnerActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryOwnerActorTypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryOwnerActorType]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryOwnerActor(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryOwnerActorType] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeInteraction = Literal["interaction",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueInteractionTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor8TypedDict
    r"""The actor that created this value."""
    interaction_type: PostV2ObjectsObjectRecordsQueryInteractionType
    r"""The type of interaction e.g. calendar or email."""
    interacted_at: datetime
    r"""When the interaction occurred."""
    owner_actor: PostV2ObjectsObjectRecordsQueryOwnerActorTypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeInteraction
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueInteraction(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor8
    r"""The actor that created this value."""

    interaction_type: PostV2ObjectsObjectRecordsQueryInteractionType
    r"""The type of interaction e.g. calendar or email."""

    interacted_at: datetime
    r"""When the interaction occurred."""

    owner_actor: PostV2ObjectsObjectRecordsQueryOwnerActor
    r"""The actor that created this value."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeInteraction
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType7 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor7TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType7]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor7(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType7] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeRecordReference = Literal[
    "record-reference",
]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueRecordReferenceTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor7TypedDict
    r"""The actor that created this value."""
    target_object: str
    r"""A slug identifying the object that the referenced record belongs to."""
    target_record_id: str
    r"""A UUID to identify the referenced record."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeRecordReference
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueRecordReference(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor7
    r"""The actor that created this value."""

    target_object: str
    r"""A slug identifying the object that the referenced record belongs to."""

    target_record_id: str
    r"""A UUID to identify the referenced record."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeRecordReference
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType6 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor6TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType6]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor6(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType6] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeEmailAddress = Literal["email-address",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueEmailAddressTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor6TypedDict
    r"""The actor that created this value."""
    original_email_address: str
    email_address: str
    email_domain: str
    email_root_domain: str
    email_local_specifier: str
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeEmailAddress
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueEmailAddress(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor6
    r"""The actor that created this value."""

    original_email_address: str

    email_address: str

    email_domain: str

    email_root_domain: str

    email_local_specifier: str

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeEmailAddress
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType5 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor5TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType5]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor5(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType5] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeDomain = Literal["domain",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueDomainTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor5TypedDict
    r"""The actor that created this value."""
    domain: str
    root_domain: str
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeDomain
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueDomain(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor5
    r"""The actor that created this value."""

    domain: str

    root_domain: str

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeDomain
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType4 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor4TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType4]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor4(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType4] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeDate = Literal["date",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueDateTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor4TypedDict
    r"""The actor that created this value."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeDate
    r"""The attribute type of the value."""
    value: str
    r"""A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, \"2023\" and \"2023-01\" will be coerced into \"2023-01-01\", and \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T14:00:00\", \"2023-01-02T15:00:00.000000000\", and \"2023-01-02T15:00:00.000000000+02:00\" will all be coerced to \"2023-01-02\". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value \"2023-01-02T23:00:00-10:00\" will be returned as \"2023-01-03\". The maximum date is \"9999-12-31\"."""


class PostV2ObjectsObjectRecordsQueryValueDate(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor4
    r"""The actor that created this value."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeDate
    r"""The attribute type of the value."""

    value: str
    r"""A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, \"2023\" and \"2023-01\" will be coerced into \"2023-01-01\", and \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T14:00:00\", \"2023-01-02T15:00:00.000000000\", and \"2023-01-02T15:00:00.000000000+02:00\" will all be coerced to \"2023-01-02\". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value \"2023-01-02T23:00:00-10:00\" will be returned as \"2023-01-03\". The maximum date is \"9999-12-31\"."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType3 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor3TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType3]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor3(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType3] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCurrencyCode = Literal[
    "ARS",
    "AUD",
    "BRL",
    "BEL",
    "CAD",
    "CLP",
    "CNY",
    "COP",
    "CZK",
    "DKK",
    "EUR",
    "HKD",
    "ISK",
    "INR",
    "ILS",
    "JPY",
    "KRW",
    "MYR",
    "MXN",
    "NTD",
    "NZD",
    "NGN",
    "NOK",
    "XPF",
    "PEN",
    "PHP",
    "PLN",
    "GBP",
    "RWF",
    "SAR",
    "SGD",
    "ZAR",
    "SEK",
    "CHF",
    "AED",
    "UYU",
    "USD",
]
r"""The ISO4217 currency code representing the currency that the value is stored in."""


PostV2ObjectsObjectRecordsQueryAttributeTypeCurrency = Literal["currency",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueCurrencyTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor3TypedDict
    r"""The actor that created this value."""
    currency_value: float
    r"""A numerical representation of the currency value. A decimal with a max of 4 decimal places."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeCurrency
    r"""The attribute type of the value."""
    currency_code: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCurrencyCode]]
    r"""The ISO4217 currency code representing the currency that the value is stored in."""


class PostV2ObjectsObjectRecordsQueryValueCurrency(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor3
    r"""The actor that created this value."""

    currency_value: float
    r"""A numerical representation of the currency value. A decimal with a max of 4 decimal places."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeCurrency
    r"""The attribute type of the value."""

    currency_code: OptionalNullable[PostV2ObjectsObjectRecordsQueryCurrencyCode] = UNSET
    r"""The ISO4217 currency code representing the currency that the value is stored in."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["currency_code"]
        nullable_fields = ["active_until", "currency_code"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType2 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor2TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType2]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor2(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType2] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryAttributeTypeCheckbox = Literal["checkbox",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueCheckboxTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor2TypedDict
    r"""The actor that created this value."""
    value: bool
    r"""A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeCheckbox
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueCheckbox(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor2
    r"""The actor that created this value."""

    value: bool
    r"""A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeCheckbox
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryCreatedByActorType1 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor1TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType1]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PostV2ObjectsObjectRecordsQueryCreatedByActor1(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PostV2ObjectsObjectRecordsQueryCreatedByActorType1] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryReferencedActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""


PostV2ObjectsObjectRecordsQueryAttributeTypeActorReference = Literal["actor-reference",]
r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueActorReferenceTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor1TypedDict
    r"""The actor that created this value."""
    referenced_actor_type: PostV2ObjectsObjectRecordsQueryReferencedActorType
    r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""
    referenced_actor_id: Nullable[str]
    r"""The ID of the referenced actor."""
    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeActorReference
    r"""The attribute type of the value."""


class PostV2ObjectsObjectRecordsQueryValueActorReference(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PostV2ObjectsObjectRecordsQueryCreatedByActor1
    r"""The actor that created this value."""

    referenced_actor_type: PostV2ObjectsObjectRecordsQueryReferencedActorType
    r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""

    referenced_actor_id: Nullable[str]
    r"""The ID of the referenced actor."""

    attribute_type: PostV2ObjectsObjectRecordsQueryAttributeTypeActorReference
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until", "referenced_actor_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PostV2ObjectsObjectRecordsQueryValueUnionTypedDict = TypeAliasType(
    "PostV2ObjectsObjectRecordsQueryValueUnionTypedDict",
    Union[
        PostV2ObjectsObjectRecordsQueryValueNumberTypedDict,
        PostV2ObjectsObjectRecordsQueryValueCheckboxTypedDict,
        PostV2ObjectsObjectRecordsQueryValueTimestampTypedDict,
        PostV2ObjectsObjectRecordsQueryValueDateTypedDict,
        PostV2ObjectsObjectRecordsQueryValueTextTypedDict,
        PostV2ObjectsObjectRecordsQueryValueSelectTypedDict,
        PostV2ObjectsObjectRecordsQueryValueRatingTypedDict,
        PostV2ObjectsObjectRecordsQueryValueStatusTypedDict,
        PostV2ObjectsObjectRecordsQueryValueDomainTypedDict,
        PostV2ObjectsObjectRecordsQueryValueRecordReferenceTypedDict,
        PostV2ObjectsObjectRecordsQueryValueActorReferenceTypedDict,
        PostV2ObjectsObjectRecordsQueryValueCurrencyTypedDict,
        PostV2ObjectsObjectRecordsQueryValuePersonalNameTypedDict,
        PostV2ObjectsObjectRecordsQueryValuePhoneNumberTypedDict,
        PostV2ObjectsObjectRecordsQueryValueInteractionTypedDict,
        PostV2ObjectsObjectRecordsQueryValueEmailAddressTypedDict,
        PostV2ObjectsObjectRecordsQueryValueLocationTypedDict,
    ],
)


PostV2ObjectsObjectRecordsQueryValueUnion = TypeAliasType(
    "PostV2ObjectsObjectRecordsQueryValueUnion",
    Union[
        PostV2ObjectsObjectRecordsQueryValueNumber,
        PostV2ObjectsObjectRecordsQueryValueCheckbox,
        PostV2ObjectsObjectRecordsQueryValueTimestamp,
        PostV2ObjectsObjectRecordsQueryValueDate,
        PostV2ObjectsObjectRecordsQueryValueText,
        PostV2ObjectsObjectRecordsQueryValueSelect,
        PostV2ObjectsObjectRecordsQueryValueRating,
        PostV2ObjectsObjectRecordsQueryValueStatus,
        PostV2ObjectsObjectRecordsQueryValueDomain,
        PostV2ObjectsObjectRecordsQueryValueRecordReference,
        PostV2ObjectsObjectRecordsQueryValueActorReference,
        PostV2ObjectsObjectRecordsQueryValueCurrency,
        PostV2ObjectsObjectRecordsQueryValuePersonalName,
        PostV2ObjectsObjectRecordsQueryValuePhoneNumber,
        PostV2ObjectsObjectRecordsQueryValueInteraction,
        PostV2ObjectsObjectRecordsQueryValueEmailAddress,
        PostV2ObjectsObjectRecordsQueryValueLocation,
    ],
)


class PostV2ObjectsObjectRecordsQueryDataTypedDict(TypedDict):
    id: PostV2ObjectsObjectRecordsQueryIDTypedDict
    created_at: str
    r"""When this record was created."""
    web_url: str
    r"""A URL that links directly to the record page in the Attio web application."""
    values: Dict[str, List[PostV2ObjectsObjectRecordsQueryValueUnionTypedDict]]
    r"""A record type with an attribute `api_slug` as the key, and an array of value objects as the values."""


class PostV2ObjectsObjectRecordsQueryData(BaseModel):
    id: PostV2ObjectsObjectRecordsQueryID

    created_at: str
    r"""When this record was created."""

    web_url: str
    r"""A URL that links directly to the record page in the Attio web application."""

    values: Dict[str, List[PostV2ObjectsObjectRecordsQueryValueUnion]]
    r"""A record type with an attribute `api_slug` as the key, and an array of value objects as the values."""


class PostV2ObjectsObjectRecordsQueryResponseTypedDict(TypedDict):
    r"""Success"""

    data: List[PostV2ObjectsObjectRecordsQueryDataTypedDict]


class PostV2ObjectsObjectRecordsQueryResponse(BaseModel):
    r"""Success"""

    data: List[PostV2ObjectsObjectRecordsQueryData]
