"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .status import Status, StatusTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from attio.utils import FieldMetadata, PathParamMetadata, RequestMetadata
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


PostV2TargetIdentifierAttributesAttributeStatusesTarget = Literal[
    "lists",
    "objects",
]
r"""Whether the attribute is on an object or a list. Please note that company and person objects do not support status attributes at this time."""


class PostV2TargetIdentifierAttributesAttributeStatusesDataTypedDict(TypedDict):
    title: str
    r"""The Title of the status"""
    celebration_enabled: NotRequired[bool]
    r"""Whether arriving at this status triggers a celebration effect"""
    target_time_in_status: NotRequired[Nullable[str]]
    r"""Target time for a record to spend in given status expressed as a ISO-8601 duration string"""


class PostV2TargetIdentifierAttributesAttributeStatusesData(BaseModel):
    title: str
    r"""The Title of the status"""

    celebration_enabled: Optional[bool] = False
    r"""Whether arriving at this status triggers a celebration effect"""

    target_time_in_status: OptionalNullable[str] = UNSET
    r"""Target time for a record to spend in given status expressed as a ISO-8601 duration string"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["celebration_enabled", "target_time_in_status"]
        nullable_fields = ["target_time_in_status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2TargetIdentifierAttributesAttributeStatusesRequestBodyTypedDict(TypedDict):
    data: PostV2TargetIdentifierAttributesAttributeStatusesDataTypedDict


class PostV2TargetIdentifierAttributesAttributeStatusesRequestBody(BaseModel):
    data: PostV2TargetIdentifierAttributesAttributeStatusesData


class PostV2TargetIdentifierAttributesAttributeStatusesRequestTypedDict(TypedDict):
    target: PostV2TargetIdentifierAttributesAttributeStatusesTarget
    r"""Whether the attribute is on an object or a list. Please note that company and person objects do not support status attributes at this time."""
    identifier: str
    attribute: str
    request_body: PostV2TargetIdentifierAttributesAttributeStatusesRequestBodyTypedDict


class PostV2TargetIdentifierAttributesAttributeStatusesRequest(BaseModel):
    target: Annotated[
        PostV2TargetIdentifierAttributesAttributeStatusesTarget,
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Whether the attribute is on an object or a list. Please note that company and person objects do not support status attributes at this time."""

    identifier: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    attribute: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    request_body: Annotated[
        PostV2TargetIdentifierAttributesAttributeStatusesRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


PostV2TargetIdentifierAttributesAttributeStatusesConflictType = Literal[
    "invalid_request_error",
]


PostV2TargetIdentifierAttributesAttributeStatusesConflictCode = Literal[
    "slug_conflict",
]


PostV2TargetIdentifierAttributesAttributeStatusesNotFoundType = Literal[
    "invalid_request_error",
]


PostV2TargetIdentifierAttributesAttributeStatusesNotFoundCode = Literal["not_found",]


PostV2TargetIdentifierAttributesAttributeStatusesBadRequestType = Literal[
    "invalid_request_error",
]


PostV2TargetIdentifierAttributesAttributeStatusesCodeValidationType = Literal[
    "validation_type",
]


class PostV2TargetIdentifierAttributesAttributeStatusesResponseTypedDict(TypedDict):
    r"""Success"""

    data: StatusTypedDict


class PostV2TargetIdentifierAttributesAttributeStatusesResponse(BaseModel):
    r"""Success"""

    data: Status
