"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .select_option import SelectOption, SelectOptionTypedDict
from .status import Status, StatusTypedDict
from attio.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from attio.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
from datetime import datetime
from pydantic import model_serializer
from typing import Any, Dict, List, Literal, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class PutV2ObjectsObjectRecordsDataRequestTypedDict(TypedDict):
    values: Dict[str, List[Any]]
    r"""An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types)."""


class PutV2ObjectsObjectRecordsDataRequest(BaseModel):
    values: Dict[str, List[Any]]
    r"""An object with an attribute `api_slug` or `attribute_id` as the key, and a single value (for single-select attributes), or an array of values (for single or multi-select attributes) as the values. For complete documentation on values for all attribute types, please see our [attribute type docs](/docs/attribute-types)."""


class PutV2ObjectsObjectRecordsRequestBodyTypedDict(TypedDict):
    data: PutV2ObjectsObjectRecordsDataRequestTypedDict


class PutV2ObjectsObjectRecordsRequestBody(BaseModel):
    data: PutV2ObjectsObjectRecordsDataRequest


class PutV2ObjectsObjectRecordsRequestTypedDict(TypedDict):
    object: str
    matching_attribute: str
    request_body: PutV2ObjectsObjectRecordsRequestBodyTypedDict


class PutV2ObjectsObjectRecordsRequest(BaseModel):
    object: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]

    matching_attribute: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]

    request_body: Annotated[
        PutV2ObjectsObjectRecordsRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


PutV2ObjectsObjectRecordsNotFoundType = Literal["invalid_request_error",]


PutV2ObjectsObjectRecordsNotFoundCode = Literal["not_found",]


PutV2ObjectsObjectRecordsBadRequestType = Literal["invalid_request_error",]


PutV2ObjectsObjectRecordsCodeValueNotFound = Literal["value_not_found",]


class PutV2ObjectsObjectRecordsIDTypedDict(TypedDict):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""
    object_id: str
    r"""A UUID identifying the object this record belongs to."""
    record_id: str
    r"""A UUID identifying this record."""


class PutV2ObjectsObjectRecordsID(BaseModel):
    workspace_id: str
    r"""A UUID identifying the workspace this record belongs to."""

    object_id: str
    r"""A UUID identifying the object this record belongs to."""

    record_id: str
    r"""A UUID identifying this record."""


PutV2ObjectsObjectRecordsCreatedByActorType17 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor17TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType17]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor17(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType17] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeTimestamp = Literal["timestamp",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueTimestampTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor17TypedDict
    r"""The actor that created this value."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeTimestamp
    r"""The attribute type of the value."""
    value: str
    r"""A timestamp string value"""


class PutV2ObjectsObjectRecordsValueTimestamp(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor17
    r"""The actor that created this value."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeTimestamp
    r"""The attribute type of the value."""

    value: str
    r"""A timestamp string value"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType16 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor16TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType16]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor16(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType16] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeText = Literal["text",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueTextTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor16TypedDict
    r"""The actor that created this value."""
    value: str
    r"""A raw text field. Values are limited to 10MB."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeText
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueText(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor16
    r"""The actor that created this value."""

    value: str
    r"""A raw text field. Values are limited to 10MB."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeText
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType15 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor15TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType15]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor15(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType15] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeSelect = Literal["select",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueSelectTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor15TypedDict
    r"""The actor that created this value."""
    option: SelectOptionTypedDict
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeSelect
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueSelect(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor15
    r"""The actor that created this value."""

    option: SelectOption

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeSelect
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType14 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor14TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType14]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor14(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType14] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeRating = Literal["rating",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueRatingTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor14TypedDict
    r"""The actor that created this value."""
    value: float
    r"""A number between 0 and 5 (inclusive) to represent a star rating."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeRating
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueRating(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor14
    r"""The actor that created this value."""

    value: float
    r"""A number between 0 and 5 (inclusive) to represent a star rating."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeRating
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType13 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor13TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType13]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor13(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType13] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeStatus = Literal["status",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueStatusTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor13TypedDict
    r"""The actor that created this value."""
    status: StatusTypedDict
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeStatus
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueStatus(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor13
    r"""The actor that created this value."""

    status: Status

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeStatus
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType12 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor12TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType12]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor12(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType12] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCountryCode2 = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""


PutV2ObjectsObjectRecordsAttributeTypePhoneNumber = Literal["phone-number",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValuePhoneNumberTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor12TypedDict
    r"""The actor that created this value."""
    original_phone_number: str
    r"""The raw, original phone number, as inputted."""
    country_code: PutV2ObjectsObjectRecordsCountryCode2
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""
    phone_number: str
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypePhoneNumber
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValuePhoneNumber(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor12
    r"""The actor that created this value."""

    original_phone_number: str
    r"""The raw, original phone number, as inputted."""

    country_code: PutV2ObjectsObjectRecordsCountryCode2
    r"""The ISO 3166-1 alpha-2 country code representing the country that this phone number belongs to."""

    phone_number: str

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypePhoneNumber
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType11 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor11TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType11]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor11(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType11] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypePersonalName = Literal["personal-name",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValuePersonalNameTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor11TypedDict
    r"""The actor that created this value."""
    first_name: str
    r"""The first name."""
    last_name: str
    r"""The last name."""
    full_name: str
    r"""The full name."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypePersonalName
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValuePersonalName(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor11
    r"""The actor that created this value."""

    first_name: str
    r"""The first name."""

    last_name: str
    r"""The last name."""

    full_name: str
    r"""The full name."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypePersonalName
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType10 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor10TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType10]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor10(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType10] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeNumber = Literal["number",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueNumberTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor10TypedDict
    r"""The actor that created this value."""
    value: float
    r"""Numbers are persisted as 64 bit floats."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeNumber
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueNumber(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor10
    r"""The actor that created this value."""

    value: float
    r"""Numbers are persisted as 64 bit floats."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeNumber
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType9 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor9TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType9]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor9(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType9] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCountryCode1 = Literal[
    "AF",
    "AX",
    "AL",
    "DZ",
    "AS",
    "AD",
    "AO",
    "AI",
    "AQ",
    "AG",
    "AR",
    "AM",
    "AW",
    "AU",
    "AT",
    "AZ",
    "BS",
    "BH",
    "BD",
    "BB",
    "BY",
    "BE",
    "BZ",
    "BJ",
    "BM",
    "BT",
    "BO",
    "BA",
    "BW",
    "BV",
    "BR",
    "IO",
    "BN",
    "BG",
    "BF",
    "BI",
    "KH",
    "CM",
    "CA",
    "CV",
    "KY",
    "CF",
    "TD",
    "CL",
    "CN",
    "CX",
    "CC",
    "CO",
    "KM",
    "CG",
    "CD",
    "CK",
    "CR",
    "CI",
    "HR",
    "CU",
    "CW",
    "CY",
    "CZ",
    "DK",
    "DJ",
    "DM",
    "DO",
    "EC",
    "EG",
    "SV",
    "GQ",
    "ER",
    "EE",
    "ET",
    "FK",
    "FO",
    "FJ",
    "FI",
    "FR",
    "GF",
    "PF",
    "TF",
    "GA",
    "GM",
    "GE",
    "DE",
    "GH",
    "GI",
    "GR",
    "GL",
    "GD",
    "GP",
    "GU",
    "GT",
    "GG",
    "GN",
    "GW",
    "GY",
    "HT",
    "HM",
    "VA",
    "HN",
    "HK",
    "HU",
    "IS",
    "IN",
    "ID",
    "IR",
    "IQ",
    "IE",
    "IM",
    "IL",
    "IT",
    "JM",
    "JP",
    "JE",
    "JO",
    "KZ",
    "KE",
    "KI",
    "KR",
    "KW",
    "KG",
    "LA",
    "LV",
    "LB",
    "LS",
    "LR",
    "LY",
    "LI",
    "LT",
    "LU",
    "MO",
    "MK",
    "MG",
    "MW",
    "MY",
    "MV",
    "ML",
    "MT",
    "MH",
    "MQ",
    "MR",
    "MU",
    "YT",
    "MX",
    "FM",
    "MD",
    "MC",
    "MN",
    "ME",
    "MS",
    "MA",
    "MZ",
    "MM",
    "NA",
    "NR",
    "NP",
    "NL",
    "AN",
    "NC",
    "NZ",
    "NI",
    "NE",
    "NG",
    "NU",
    "NF",
    "MP",
    "NO",
    "OM",
    "PK",
    "PW",
    "PS",
    "PA",
    "PG",
    "PY",
    "PE",
    "PH",
    "PN",
    "PL",
    "PT",
    "PR",
    "QA",
    "RE",
    "RO",
    "RU",
    "RW",
    "BL",
    "SH",
    "KN",
    "LC",
    "MF",
    "PM",
    "VC",
    "WS",
    "SM",
    "ST",
    "SA",
    "SN",
    "SS",
    "RS",
    "SC",
    "SL",
    "SG",
    "SK",
    "SI",
    "SB",
    "SO",
    "ZA",
    "GS",
    "ES",
    "LK",
    "SD",
    "SR",
    "SJ",
    "SZ",
    "SE",
    "CH",
    "SY",
    "TW",
    "TJ",
    "TZ",
    "TH",
    "TL",
    "TG",
    "TK",
    "TO",
    "TT",
    "TN",
    "TR",
    "TM",
    "TC",
    "TV",
    "UG",
    "UA",
    "AE",
    "GB",
    "US",
    "UM",
    "UY",
    "UZ",
    "VU",
    "VE",
    "VN",
    "VG",
    "VI",
    "WF",
    "EH",
    "YE",
    "ZM",
    "ZW",
    "BQ",
    "KP",
    "SX",
    "XK",
    "AC",
]
r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""


PutV2ObjectsObjectRecordsAttributeTypeLocation = Literal["location",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueLocationTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor9TypedDict
    r"""The actor that created this value."""
    line_1: Nullable[str]
    r"""The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_2: Nullable[str]
    r"""The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_3: Nullable[str]
    r"""The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    line_4: Nullable[str]
    r"""The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""
    locality: Nullable[str]
    r"""The town, neighborhood or area the location is in."""
    region: Nullable[str]
    r"""The state, county, province or region that the location is in."""
    postcode: Nullable[str]
    r"""The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    country_code: Nullable[PutV2ObjectsObjectRecordsCountryCode1]
    r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""
    latitude: Nullable[str]
    r"""The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    longitude: Nullable[str]
    r"""The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeLocation
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueLocation(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor9
    r"""The actor that created this value."""

    line_1: Nullable[str]
    r"""The first line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_2: Nullable[str]
    r"""The second line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_3: Nullable[str]
    r"""The third line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    line_4: Nullable[str]
    r"""The fourth line of the address. Note that this value is not currently represented in the UI but will be persisted and readable through API calls."""

    locality: Nullable[str]
    r"""The town, neighborhood or area the location is in."""

    region: Nullable[str]
    r"""The state, county, province or region that the location is in."""

    postcode: Nullable[str]
    r"""The postcode or zip code for the location. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    country_code: Nullable[PutV2ObjectsObjectRecordsCountryCode1]
    r"""The ISO 3166-1 alpha-2 country code for the country this location is in."""

    latitude: Nullable[str]
    r"""The latitude of the location. Validated by the regular expression `/^[-+]?([1-8]?\d(\.\d+)?|90(\.0+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    longitude: Nullable[str]
    r"""The longitude of the location. Validated by the regular expression `/^[-+]?(180(\.0+)?|((1[0-7]\d)|([1-9]?\d))(\.\d+)?)$/`. Values are stored with up to 9 decimal places of precision. Note that this value is not currently represented in the UI but will be persisted and readable through API calls.}"""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeLocation
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "active_until",
            "line_1",
            "line_2",
            "line_3",
            "line_4",
            "locality",
            "region",
            "postcode",
            "country_code",
            "latitude",
            "longitude",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType8 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor8TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType8]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor8(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType8] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsInteractionType = Literal[
    "calendar-event",
    "call",
    "chat-thread",
    "email",
    "in-person-meeting",
    "meeting",
]
r"""The type of interaction e.g. calendar or email."""


PutV2ObjectsObjectRecordsOwnerActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsOwnerActorTypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsOwnerActorType]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsOwnerActor(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsOwnerActorType] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeInteraction = Literal["interaction",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueInteractionTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor8TypedDict
    r"""The actor that created this value."""
    interaction_type: PutV2ObjectsObjectRecordsInteractionType
    r"""The type of interaction e.g. calendar or email."""
    interacted_at: datetime
    r"""When the interaction occurred."""
    owner_actor: PutV2ObjectsObjectRecordsOwnerActorTypedDict
    r"""The actor that created this value."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeInteraction
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueInteraction(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor8
    r"""The actor that created this value."""

    interaction_type: PutV2ObjectsObjectRecordsInteractionType
    r"""The type of interaction e.g. calendar or email."""

    interacted_at: datetime
    r"""When the interaction occurred."""

    owner_actor: PutV2ObjectsObjectRecordsOwnerActor
    r"""The actor that created this value."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeInteraction
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType7 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor7TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType7]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor7(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType7] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeRecordReference = Literal["record-reference",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueRecordReferenceTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor7TypedDict
    r"""The actor that created this value."""
    target_object: str
    r"""A slug identifying the object that the referenced record belongs to."""
    target_record_id: str
    r"""A UUID to identify the referenced record."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeRecordReference
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueRecordReference(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor7
    r"""The actor that created this value."""

    target_object: str
    r"""A slug identifying the object that the referenced record belongs to."""

    target_record_id: str
    r"""A UUID to identify the referenced record."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeRecordReference
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType6 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor6TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType6]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor6(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType6] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeEmailAddress = Literal["email-address",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueEmailAddressTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor6TypedDict
    r"""The actor that created this value."""
    original_email_address: str
    email_address: str
    email_domain: str
    email_root_domain: str
    email_local_specifier: str
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeEmailAddress
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueEmailAddress(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor6
    r"""The actor that created this value."""

    original_email_address: str

    email_address: str

    email_domain: str

    email_root_domain: str

    email_local_specifier: str

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeEmailAddress
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType5 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor5TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType5]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor5(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType5] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeDomain = Literal["domain",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueDomainTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor5TypedDict
    r"""The actor that created this value."""
    domain: str
    root_domain: str
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeDomain
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueDomain(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor5
    r"""The actor that created this value."""

    domain: str

    root_domain: str

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeDomain
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType4 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor4TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType4]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor4(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType4] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeDate = Literal["date",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueDateTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor4TypedDict
    r"""The actor that created this value."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeDate
    r"""The attribute type of the value."""
    value: str
    r"""A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, \"2023\" and \"2023-01\" will be coerced into \"2023-01-01\", and \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T14:00:00\", \"2023-01-02T15:00:00.000000000\", and \"2023-01-02T15:00:00.000000000+02:00\" will all be coerced to \"2023-01-02\". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value \"2023-01-02T23:00:00-10:00\" will be returned as \"2023-01-03\". The maximum date is \"9999-12-31\"."""


class PutV2ObjectsObjectRecordsValueDate(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor4
    r"""The actor that created this value."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeDate
    r"""The attribute type of the value."""

    value: str
    r"""A date represents a single calendar year, month and day, independent of timezone. If hours, months, seconds or timezones are provided, they will be trimmed. For example, \"2023\" and \"2023-01\" will be coerced into \"2023-01-01\", and \"2023-01-02\", \"2023-01-02T13:00\", \"2023-01-02T14:00:00\", \"2023-01-02T15:00:00.000000000\", and \"2023-01-02T15:00:00.000000000+02:00\" will all be coerced to \"2023-01-02\". If a timezone is provided that would result in a different calendar date in UTC, the date will be coerced to UTC and then the timezone component will be trimmed. For example, the value \"2023-01-02T23:00:00-10:00\" will be returned as \"2023-01-03\". The maximum date is \"9999-12-31\"."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType3 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor3TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType3]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor3(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType3] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCurrencyCode = Literal[
    "ARS",
    "AUD",
    "BRL",
    "BEL",
    "CAD",
    "CLP",
    "CNY",
    "COP",
    "CZK",
    "DKK",
    "EUR",
    "HKD",
    "ISK",
    "INR",
    "ILS",
    "JPY",
    "KRW",
    "MYR",
    "MXN",
    "NTD",
    "NZD",
    "NGN",
    "NOK",
    "XPF",
    "PEN",
    "PHP",
    "PLN",
    "GBP",
    "RWF",
    "SAR",
    "SGD",
    "ZAR",
    "SEK",
    "CHF",
    "AED",
    "UYU",
    "USD",
]
r"""The ISO4217 currency code representing the currency that the value is stored in."""


PutV2ObjectsObjectRecordsAttributeTypeCurrency = Literal["currency",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueCurrencyTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor3TypedDict
    r"""The actor that created this value."""
    currency_value: float
    r"""A numerical representation of the currency value. A decimal with a max of 4 decimal places."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeCurrency
    r"""The attribute type of the value."""
    currency_code: NotRequired[Nullable[PutV2ObjectsObjectRecordsCurrencyCode]]
    r"""The ISO4217 currency code representing the currency that the value is stored in."""


class PutV2ObjectsObjectRecordsValueCurrency(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor3
    r"""The actor that created this value."""

    currency_value: float
    r"""A numerical representation of the currency value. A decimal with a max of 4 decimal places."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeCurrency
    r"""The attribute type of the value."""

    currency_code: OptionalNullable[PutV2ObjectsObjectRecordsCurrencyCode] = UNSET
    r"""The ISO4217 currency code representing the currency that the value is stored in."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["currency_code"]
        nullable_fields = ["active_until", "currency_code"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType2 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor2TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType2]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor2(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType2] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsAttributeTypeCheckbox = Literal["checkbox",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueCheckboxTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor2TypedDict
    r"""The actor that created this value."""
    value: bool
    r"""A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeCheckbox
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueCheckbox(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor2
    r"""The actor that created this value."""

    value: bool
    r"""A boolean representing whether the checkbox is checked or not. The string values 'true' and 'false' are also accepted."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeCheckbox
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsCreatedByActorType1 = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor1TypedDict(TypedDict):
    r"""The actor that created this value."""

    id: NotRequired[Nullable[str]]
    r"""An ID to identify the actor."""
    type: NotRequired[Nullable[PutV2ObjectsObjectRecordsCreatedByActorType1]]
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""


class PutV2ObjectsObjectRecordsCreatedByActor1(BaseModel):
    r"""The actor that created this value."""

    id: OptionalNullable[str] = UNSET
    r"""An ID to identify the actor."""

    type: OptionalNullable[PutV2ObjectsObjectRecordsCreatedByActorType1] = UNSET
    r"""The type of actor. [Read more information on actor types here](/docs/actors)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "type"]
        nullable_fields = ["id", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsReferencedActorType = Literal[
    "api-token",
    "workspace-member",
    "system",
    "app",
]
r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""


PutV2ObjectsObjectRecordsAttributeTypeActorReference = Literal["actor-reference",]
r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueActorReferenceTypedDict(TypedDict):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""
    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""
    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor1TypedDict
    r"""The actor that created this value."""
    referenced_actor_type: PutV2ObjectsObjectRecordsReferencedActorType
    r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""
    referenced_actor_id: Nullable[str]
    r"""The ID of the referenced actor."""
    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeActorReference
    r"""The attribute type of the value."""


class PutV2ObjectsObjectRecordsValueActorReference(BaseModel):
    active_from: datetime
    r"""The point in time at which this value was made \"active\". `active_from` can be considered roughly analogous to `created_at`."""

    active_until: Nullable[datetime]
    r"""The point in time at which this value was deactivated. If `null`, the value is active."""

    created_by_actor: PutV2ObjectsObjectRecordsCreatedByActor1
    r"""The actor that created this value."""

    referenced_actor_type: PutV2ObjectsObjectRecordsReferencedActorType
    r"""The type of the referenced actor. [Read more information on actor types here](/docs/actors)."""

    referenced_actor_id: Nullable[str]
    r"""The ID of the referenced actor."""

    attribute_type: PutV2ObjectsObjectRecordsAttributeTypeActorReference
    r"""The attribute type of the value."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["active_until", "referenced_actor_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


PutV2ObjectsObjectRecordsValueUnionTypedDict = TypeAliasType(
    "PutV2ObjectsObjectRecordsValueUnionTypedDict",
    Union[
        PutV2ObjectsObjectRecordsValueNumberTypedDict,
        PutV2ObjectsObjectRecordsValueCheckboxTypedDict,
        PutV2ObjectsObjectRecordsValueTimestampTypedDict,
        PutV2ObjectsObjectRecordsValueDateTypedDict,
        PutV2ObjectsObjectRecordsValueTextTypedDict,
        PutV2ObjectsObjectRecordsValueSelectTypedDict,
        PutV2ObjectsObjectRecordsValueRatingTypedDict,
        PutV2ObjectsObjectRecordsValueStatusTypedDict,
        PutV2ObjectsObjectRecordsValueDomainTypedDict,
        PutV2ObjectsObjectRecordsValueRecordReferenceTypedDict,
        PutV2ObjectsObjectRecordsValueActorReferenceTypedDict,
        PutV2ObjectsObjectRecordsValueCurrencyTypedDict,
        PutV2ObjectsObjectRecordsValuePersonalNameTypedDict,
        PutV2ObjectsObjectRecordsValuePhoneNumberTypedDict,
        PutV2ObjectsObjectRecordsValueInteractionTypedDict,
        PutV2ObjectsObjectRecordsValueEmailAddressTypedDict,
        PutV2ObjectsObjectRecordsValueLocationTypedDict,
    ],
)


PutV2ObjectsObjectRecordsValueUnion = TypeAliasType(
    "PutV2ObjectsObjectRecordsValueUnion",
    Union[
        PutV2ObjectsObjectRecordsValueNumber,
        PutV2ObjectsObjectRecordsValueCheckbox,
        PutV2ObjectsObjectRecordsValueTimestamp,
        PutV2ObjectsObjectRecordsValueDate,
        PutV2ObjectsObjectRecordsValueText,
        PutV2ObjectsObjectRecordsValueSelect,
        PutV2ObjectsObjectRecordsValueRating,
        PutV2ObjectsObjectRecordsValueStatus,
        PutV2ObjectsObjectRecordsValueDomain,
        PutV2ObjectsObjectRecordsValueRecordReference,
        PutV2ObjectsObjectRecordsValueActorReference,
        PutV2ObjectsObjectRecordsValueCurrency,
        PutV2ObjectsObjectRecordsValuePersonalName,
        PutV2ObjectsObjectRecordsValuePhoneNumber,
        PutV2ObjectsObjectRecordsValueInteraction,
        PutV2ObjectsObjectRecordsValueEmailAddress,
        PutV2ObjectsObjectRecordsValueLocation,
    ],
)


class PutV2ObjectsObjectRecordsDataResponseTypedDict(TypedDict):
    id: PutV2ObjectsObjectRecordsIDTypedDict
    created_at: str
    r"""When this record was created."""
    web_url: str
    r"""A URL that links directly to the record page in the Attio web application."""
    values: Dict[str, List[PutV2ObjectsObjectRecordsValueUnionTypedDict]]
    r"""A record type with an attribute `api_slug` as the key, and an array of value objects as the values."""


class PutV2ObjectsObjectRecordsDataResponse(BaseModel):
    id: PutV2ObjectsObjectRecordsID

    created_at: str
    r"""When this record was created."""

    web_url: str
    r"""A URL that links directly to the record page in the Attio web application."""

    values: Dict[str, List[PutV2ObjectsObjectRecordsValueUnion]]
    r"""A record type with an attribute `api_slug` as the key, and an array of value objects as the values."""


class PutV2ObjectsObjectRecordsResponseTypedDict(TypedDict):
    r"""Success"""

    data: PutV2ObjectsObjectRecordsDataResponseTypedDict


class PutV2ObjectsObjectRecordsResponse(BaseModel):
    r"""Success"""

    data: PutV2ObjectsObjectRecordsDataResponse
