"""big af table

Revision ID: d162c084f522
Revises: 06d989926550
Create Date: 2024-06-25 16:29:17.081234

"""

from collections.abc import Sequence
from typing import Union

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision: str = "d162c084f522"
down_revision: Union[str, None] = "06d989926550"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "big_table",
        sa.Column("big_table_id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("string_field", sa.String(), nullable=False),
        sa.Column("integer_field", sa.Integer(), nullable=False),
        sa.Column("json_field", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("array_field", postgresql.ARRAY(sa.Integer()), nullable=False),
        sa.PrimaryKeyConstraint("big_table_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "test",
        sa.Column("jj", sa.VARCHAR(), autoincrement=False, nullable=True),
    )
    op.drop_table("big_table")
    # ### end Alembic commands ###
