# coding: utf-8

"""
ExportresourceApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ExportresourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_exports_using_get(self, **kwargs):
        """
        getExports
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_exports_using_get(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool with_meta: withMeta
        :param int page: Results page you want to retrieve (0..N)
        :param int size: Number of records per page.
        :param str sort: Sorts by value specified, for example 'name'
        :param str x_auth_token: auth token
        :return: GetExportListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['with_meta', 'page', 'size', 'sort', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_exports_using_get" % key
                )
            params[key] = val
        del params['kwargs']


        resource_path = '/api/0.1/exports'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'with_meta' in params:
            query_params['withMeta'] = params['with_meta']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'size' in params:
            query_params['size'] = params['size']
        if 'sort' in params:
            query_params['sort'] = params['sort']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='GetExportListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_export_using_post(self, entity, **kwargs):
        """
        postExport
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_export_using_post(entity, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExportConfig entity: entity (required)
        :param str x_auth_token: auth token
        :return: Id
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_export_using_post" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'entity' is set
        if ('entity' not in params) or (params['entity'] is None):
            raise ValueError("Missing the required parameter `entity` when calling `post_export_using_post`")

        resource_path = '/api/0.1/exports'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'entity' in params:
            body_params = params['entity']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Id',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def update_instances_export_work_queue_using_put(self, current_export_queue_id_, current_export_queue_id, action, status, export_queue_id, **kwargs):
        """
        updateInstancesExportWorkQueue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_instances_export_work_queue_using_put(current_export_queue_id_, current_export_queue_id, action, status, export_queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str current_export_queue_id_: currentExportQueueId (required)
        :param str current_export_queue_id:  (required)
        :param str action: action (required)
        :param str status: status (required)
        :param str export_queue_id: exportQueueId (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['current_export_queue_id_', 'current_export_queue_id', 'action', 'status', 'export_queue_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instances_export_work_queue_using_put" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'current_export_queue_id_' is set
        if ('current_export_queue_id_' not in params) or (params['current_export_queue_id_'] is None):
            raise ValueError("Missing the required parameter `current_export_queue_id_` when calling `update_instances_export_work_queue_using_put`")
        # verify the required parameter 'current_export_queue_id' is set
        if ('current_export_queue_id' not in params) or (params['current_export_queue_id'] is None):
            raise ValueError("Missing the required parameter `current_export_queue_id` when calling `update_instances_export_work_queue_using_put`")
        # verify the required parameter 'action' is set
        if ('action' not in params) or (params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `update_instances_export_work_queue_using_put`")
        # verify the required parameter 'status' is set
        if ('status' not in params) or (params['status'] is None):
            raise ValueError("Missing the required parameter `status` when calling `update_instances_export_work_queue_using_put`")
        # verify the required parameter 'export_queue_id' is set
        if ('export_queue_id' not in params) or (params['export_queue_id'] is None):
            raise ValueError("Missing the required parameter `export_queue_id` when calling `update_instances_export_work_queue_using_put`")

        resource_path = '/api/0.1/exports/instances'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        query_params = {}
        if 'current_export_queue_id_' in params:
            query_params['currentExportQueueId '] = params['current_export_queue_id_']
        if 'current_export_queue_id' in params:
            query_params['currentExportQueueId'] = params['current_export_queue_id']
        if 'action' in params:
            query_params['action'] = params['action']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'export_queue_id' in params:
            query_params['exportQueueId'] = params['export_queue_id']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_out_of_bound_instances_using_get(self, **kwargs):
        """
        getOutOfBoundInstances
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_out_of_bound_instances_using_get(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_out_of_bound_instances_using_get" % key
                )
            params[key] = val
        del params['kwargs']


        resource_path = '/api/0.1/exports/oobInstances'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_export_using_get(self, config_id, **kwargs):
        """
        getExport
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_export_using_get(config_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param bool with_meta: withMeta
        :param str x_auth_token: auth token
        :return: Export
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'with_meta', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_export_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_export_using_get`")

        resource_path = '/api/0.1/exports/{configId}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}
        if 'with_meta' in params:
            query_params['withMeta'] = params['with_meta']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Export',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_export_using_put(self, config_id, entity, **kwargs):
        """
        putExport
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_export_using_put(config_id, entity, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param ExportConfig entity: entity (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'entity', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_export_using_put" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `put_export_using_put`")
        # verify the required parameter 'entity' is set
        if ('entity' not in params) or (params['entity'] is None):
            raise ValueError("Missing the required parameter `entity` when calling `put_export_using_put`")

        resource_path = '/api/0.1/exports/{configId}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'entity' in params:
            body_params = params['entity']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_config_using_delete(self, config_id, **kwargs):
        """
        deleteConfig
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_config_using_delete(config_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_config_using_delete" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `delete_config_using_delete`")

        resource_path = '/api/0.1/exports/{configId}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_instances_using_get(self, config_id, **kwargs):
        """
        getInstances
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_instances_using_get(config_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param int page: Results page you want to retrieve (0..N)
        :param int size: Number of records per page.
        :param str sort: Sorts by value specified, for example 'instanceStartTime'
        :param str x_auth_token: auth token
        :return: ExportInstancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'page', 'size', 'sort', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instances_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_instances_using_get`")

        resource_path = '/api/0.1/exports/{configId}/instances'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}
        if 'page' in params:
            query_params['page'] = params['page']
        if 'size' in params:
            query_params['size'] = params['size']
        if 'sort' in params:
            query_params['sort'] = params['sort']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportInstancesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_instances_using_post(self, config_id, action, **kwargs):
        """
        postInstances
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_instances_using_post(config_id, action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str action: action (required)
        :param str x_auth_token: auth token
        :return: Id
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'action', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_instances_using_post" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `post_instances_using_post`")
        # verify the required parameter 'action' is set
        if ('action' not in params) or (params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `post_instances_using_post`")

        resource_path = '/api/0.1/exports/{configId}/instances'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Id',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def instance_action_using_post(self, config_id, instance_id, action, **kwargs):
        """
        instanceAction
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.instance_action_using_post(config_id, instance_id, action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str instance_id: instanceId (required)
        :param str action: action (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'instance_id', 'action', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method instance_action_using_post" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `instance_action_using_post`")
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params) or (params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `instance_action_using_post`")
        # verify the required parameter 'action' is set
        if ('action' not in params) or (params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `instance_action_using_post`")

        resource_path = '/api/0.1/exports/{configId}/instances/{instanceId}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']

        query_params = {}
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_instance_results_using_get(self, config_id, instance_id, **kwargs):
        """
        getInstanceResults
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_instance_results_using_get(config_id, instance_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str instance_id: instanceId (required)
        :param Object page: Results page you want to retrieve (0..N)
        :param Object size: Number of records per page.
        :param str sort: Sorts by value specified, for example 'dataVersion'
        :param str x_auth_token: auth token
        :return: Results
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'instance_id', 'page', 'size', 'sort', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instance_results_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_instance_results_using_get`")
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params) or (params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `get_instance_results_using_get`")

        resource_path = '/api/0.1/exports/{configId}/instances/{instanceId}/results'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']

        query_params = {}
        if 'page' in params:
            query_params['page'] = params['page']
        if 'size' in params:
            query_params['size'] = params['size']
        if 'sort' in params:
            query_params['sort'] = params['sort']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Results',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_results_using_get(self, config_id, **kwargs):
        """
        getResults
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_results_using_get(config_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param int offset: offset
        :param str x_auth_token: auth token
        :return: Results
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'offset', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_results_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_results_using_get`")

        resource_path = '/api/0.1/exports/{configId}/results'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}
        if 'offset' in params:
            query_params['offset'] = params['offset']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Results',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_files_using_get(self, config_id, result_id, **kwargs):
        """
        getFiles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_files_using_get(config_id, result_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str result_id: resultId (required)
        :param str x_auth_token: auth token
        :return: ExportFilesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'result_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_files_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_files_using_get`")
        # verify the required parameter 'result_id' is set
        if ('result_id' not in params) or (params['result_id'] is None):
            raise ValueError("Missing the required parameter `result_id` when calling `get_files_using_get`")

        resource_path = '/api/0.1/exports/{configId}/results/{resultId}/files'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']
        if 'result_id' in params:
            path_params['resultId'] = params['result_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportFilesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_file_using_get(self, config_id, result_id, file_id, **kwargs):
        """
        getFile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_file_using_get(config_id, result_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str result_id: resultId (required)
        :param str file_id: fileId (required)
        :param str x_auth_token: auth token
        :return: ResultFileUrlDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'result_id', 'file_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_file_using_get`")
        # verify the required parameter 'result_id' is set
        if ('result_id' not in params) or (params['result_id'] is None):
            raise ValueError("Missing the required parameter `result_id` when calling `get_file_using_get`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `get_file_using_get`")

        resource_path = '/api/0.1/exports/{configId}/results/{resultId}/files/{fileId}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']
        if 'result_id' in params:
            path_params['resultId'] = params['result_id']
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ResultFileUrlDTO',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_exports_using_get1(self, **kwargs):
        """
        getExports
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_exports_using_get1(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool with_meta: withMeta
        :param int page: Results page you want to retrieve (0..N)
        :param int size: Number of records per page.
        :param str sort: Sorts by value specified, for example 'name'
        :param str x_auth_token: auth token
        :return: GetExportListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['with_meta', 'page', 'size', 'sort', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_exports_using_get1" % key
                )
            params[key] = val
        del params['kwargs']


        resource_path = '/api/latest/exports'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'with_meta' in params:
            query_params['withMeta'] = params['with_meta']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'size' in params:
            query_params['size'] = params['size']
        if 'sort' in params:
            query_params['sort'] = params['sort']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='GetExportListResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_export_using_post1(self, entity, **kwargs):
        """
        postExport
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_export_using_post1(entity, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExportConfig entity: entity (required)
        :param str x_auth_token: auth token
        :return: Id
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_export_using_post1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'entity' is set
        if ('entity' not in params) or (params['entity'] is None):
            raise ValueError("Missing the required parameter `entity` when calling `post_export_using_post1`")

        resource_path = '/api/latest/exports'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'entity' in params:
            body_params = params['entity']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Id',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def update_instances_export_work_queue_using_put1(self, current_export_queue_id_, current_export_queue_id, action, status, export_queue_id, **kwargs):
        """
        updateInstancesExportWorkQueue
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_instances_export_work_queue_using_put1(current_export_queue_id_, current_export_queue_id, action, status, export_queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str current_export_queue_id_: currentExportQueueId (required)
        :param str current_export_queue_id:  (required)
        :param str action: action (required)
        :param str status: status (required)
        :param str export_queue_id: exportQueueId (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['current_export_queue_id_', 'current_export_queue_id', 'action', 'status', 'export_queue_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instances_export_work_queue_using_put1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'current_export_queue_id_' is set
        if ('current_export_queue_id_' not in params) or (params['current_export_queue_id_'] is None):
            raise ValueError("Missing the required parameter `current_export_queue_id_` when calling `update_instances_export_work_queue_using_put1`")
        # verify the required parameter 'current_export_queue_id' is set
        if ('current_export_queue_id' not in params) or (params['current_export_queue_id'] is None):
            raise ValueError("Missing the required parameter `current_export_queue_id` when calling `update_instances_export_work_queue_using_put1`")
        # verify the required parameter 'action' is set
        if ('action' not in params) or (params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `update_instances_export_work_queue_using_put1`")
        # verify the required parameter 'status' is set
        if ('status' not in params) or (params['status'] is None):
            raise ValueError("Missing the required parameter `status` when calling `update_instances_export_work_queue_using_put1`")
        # verify the required parameter 'export_queue_id' is set
        if ('export_queue_id' not in params) or (params['export_queue_id'] is None):
            raise ValueError("Missing the required parameter `export_queue_id` when calling `update_instances_export_work_queue_using_put1`")

        resource_path = '/api/latest/exports/instances'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        query_params = {}
        if 'current_export_queue_id_' in params:
            query_params['currentExportQueueId '] = params['current_export_queue_id_']
        if 'current_export_queue_id' in params:
            query_params['currentExportQueueId'] = params['current_export_queue_id']
        if 'action' in params:
            query_params['action'] = params['action']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'export_queue_id' in params:
            query_params['exportQueueId'] = params['export_queue_id']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_out_of_bound_instances_using_get1(self, **kwargs):
        """
        getOutOfBoundInstances
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_out_of_bound_instances_using_get1(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_out_of_bound_instances_using_get1" % key
                )
            params[key] = val
        del params['kwargs']


        resource_path = '/api/latest/exports/oobInstances'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_export_using_get1(self, config_id, **kwargs):
        """
        getExport
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_export_using_get1(config_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param bool with_meta: withMeta
        :param str x_auth_token: auth token
        :return: Export
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'with_meta', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_export_using_get1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_export_using_get1`")

        resource_path = '/api/latest/exports/{configId}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}
        if 'with_meta' in params:
            query_params['withMeta'] = params['with_meta']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Export',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_export_using_put1(self, config_id, entity, **kwargs):
        """
        putExport
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_export_using_put1(config_id, entity, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param ExportConfig entity: entity (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'entity', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_export_using_put1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `put_export_using_put1`")
        # verify the required parameter 'entity' is set
        if ('entity' not in params) or (params['entity'] is None):
            raise ValueError("Missing the required parameter `entity` when calling `put_export_using_put1`")

        resource_path = '/api/latest/exports/{configId}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'entity' in params:
            body_params = params['entity']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_config_using_delete1(self, config_id, **kwargs):
        """
        deleteConfig
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_config_using_delete1(config_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_config_using_delete1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `delete_config_using_delete1`")

        resource_path = '/api/latest/exports/{configId}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_instances_using_get1(self, config_id, **kwargs):
        """
        getInstances
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_instances_using_get1(config_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param int page: Results page you want to retrieve (0..N)
        :param int size: Number of records per page.
        :param str sort: Sorts by value specified, for example 'instanceStartTime'
        :param str x_auth_token: auth token
        :return: ExportInstancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'page', 'size', 'sort', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instances_using_get1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_instances_using_get1`")

        resource_path = '/api/latest/exports/{configId}/instances'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}
        if 'page' in params:
            query_params['page'] = params['page']
        if 'size' in params:
            query_params['size'] = params['size']
        if 'sort' in params:
            query_params['sort'] = params['sort']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportInstancesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_instances_using_post1(self, config_id, action, **kwargs):
        """
        postInstances
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_instances_using_post1(config_id, action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str action: action (required)
        :param str x_auth_token: auth token
        :return: Id
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'action', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_instances_using_post1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `post_instances_using_post1`")
        # verify the required parameter 'action' is set
        if ('action' not in params) or (params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `post_instances_using_post1`")

        resource_path = '/api/latest/exports/{configId}/instances'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Id',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def instance_action_using_post1(self, config_id, instance_id, action, **kwargs):
        """
        instanceAction
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.instance_action_using_post1(config_id, instance_id, action, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str instance_id: instanceId (required)
        :param str action: action (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'instance_id', 'action', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method instance_action_using_post1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `instance_action_using_post1`")
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params) or (params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `instance_action_using_post1`")
        # verify the required parameter 'action' is set
        if ('action' not in params) or (params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `instance_action_using_post1`")

        resource_path = '/api/latest/exports/{configId}/instances/{instanceId}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']

        query_params = {}
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_instance_results_using_get1(self, config_id, instance_id, **kwargs):
        """
        getInstanceResults
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_instance_results_using_get1(config_id, instance_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str instance_id: instanceId (required)
        :param Object page: Results page you want to retrieve (0..N)
        :param Object size: Number of records per page.
        :param str sort: Sorts by value specified, for example 'dataVersion'
        :param str x_auth_token: auth token
        :return: Results
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'instance_id', 'page', 'size', 'sort', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instance_results_using_get1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_instance_results_using_get1`")
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params) or (params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `get_instance_results_using_get1`")

        resource_path = '/api/latest/exports/{configId}/instances/{instanceId}/results'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']

        query_params = {}
        if 'page' in params:
            query_params['page'] = params['page']
        if 'size' in params:
            query_params['size'] = params['size']
        if 'sort' in params:
            query_params['sort'] = params['sort']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Results',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_results_using_get1(self, config_id, **kwargs):
        """
        getResults
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_results_using_get1(config_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param int offset: offset
        :param str x_auth_token: auth token
        :return: Results
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'offset', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_results_using_get1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_results_using_get1`")

        resource_path = '/api/latest/exports/{configId}/results'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']

        query_params = {}
        if 'offset' in params:
            query_params['offset'] = params['offset']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Results',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_files_using_get1(self, config_id, result_id, **kwargs):
        """
        getFiles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_files_using_get1(config_id, result_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str result_id: resultId (required)
        :param str x_auth_token: auth token
        :return: ExportFilesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'result_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_files_using_get1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_files_using_get1`")
        # verify the required parameter 'result_id' is set
        if ('result_id' not in params) or (params['result_id'] is None):
            raise ValueError("Missing the required parameter `result_id` when calling `get_files_using_get1`")

        resource_path = '/api/latest/exports/{configId}/results/{resultId}/files'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']
        if 'result_id' in params:
            path_params['resultId'] = params['result_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportFilesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_file_using_get1(self, config_id, result_id, file_id, **kwargs):
        """
        getFile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_file_using_get1(config_id, result_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_id: configId (required)
        :param str result_id: resultId (required)
        :param str file_id: fileId (required)
        :param str x_auth_token: auth token
        :return: ResultFileUrlDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id', 'result_id', 'file_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_using_get1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'config_id' is set
        if ('config_id' not in params) or (params['config_id'] is None):
            raise ValueError("Missing the required parameter `config_id` when calling `get_file_using_get1`")
        # verify the required parameter 'result_id' is set
        if ('result_id' not in params) or (params['result_id'] is None):
            raise ValueError("Missing the required parameter `result_id` when calling `get_file_using_get1`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `get_file_using_get1`")

        resource_path = '/api/latest/exports/{configId}/results/{resultId}/files/{fileId}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']
        if 'result_id' in params:
            path_params['resultId'] = params['result_id']
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ResultFileUrlDTO',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
