# coding: utf-8

"""
ExportworkqueueresourceApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ExportworkqueueresourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_export_work_queues_using_get(self, **kwargs):
        """
        getExportWorkQueues
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_export_work_queues_using_get(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str x_auth_token: auth token
        :return: ExportWorkQueueList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_export_work_queues_using_get" % key
                )
            params[key] = val
        del params['kwargs']


        resource_path = '/api/0.1/exports/queues'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportWorkQueueList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def update_all_export_work_queues_with_action_using_put(self, action, cancel_running, **kwargs):
        """
        updateAllExportWorkQueuesWithAction
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_all_export_work_queues_with_action_using_put(action, cancel_running, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action: action (required)
        :param str cancel_running: cancelRunning (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action', 'cancel_running', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_all_export_work_queues_with_action_using_put" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action' is set
        if ('action' not in params) or (params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `update_all_export_work_queues_with_action_using_put`")
        # verify the required parameter 'cancel_running' is set
        if ('cancel_running' not in params) or (params['cancel_running'] is None):
            raise ValueError("Missing the required parameter `cancel_running` when calling `update_all_export_work_queues_with_action_using_put`")

        resource_path = '/api/0.1/exports/queues'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        query_params = {}
        if 'action' in params:
            query_params['action'] = params['action']
        if 'cancel_running' in params:
            query_params['cancelRunning'] = params['cancel_running']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_export_work_queue_request_using_post(self, entity, **kwargs):
        """
        postExportWorkQueueRequest
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_export_work_queue_request_using_post(entity, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExportWorkQueue entity: entity (required)
        :param str x_auth_token: auth token
        :return: Id
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_export_work_queue_request_using_post" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'entity' is set
        if ('entity' not in params) or (params['entity'] is None):
            raise ValueError("Missing the required parameter `entity` when calling `post_export_work_queue_request_using_post`")

        resource_path = '/api/0.1/exports/queues'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'entity' in params:
            body_params = params['entity']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Id',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def update_export_work_queue_with_action_using_put(self, queue_id, action, cancel_running, **kwargs):
        """
        updateExportWorkQueueWithAction
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_export_work_queue_with_action_using_put(queue_id, action, cancel_running, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: queueId (required)
        :param str action: action (required)
        :param str cancel_running: cancelRunning (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'action', 'cancel_running', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_export_work_queue_with_action_using_put" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `update_export_work_queue_with_action_using_put`")
        # verify the required parameter 'action' is set
        if ('action' not in params) or (params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `update_export_work_queue_with_action_using_put`")
        # verify the required parameter 'cancel_running' is set
        if ('cancel_running' not in params) or (params['cancel_running'] is None):
            raise ValueError("Missing the required parameter `cancel_running` when calling `update_export_work_queue_with_action_using_put`")

        resource_path = '/api/0.1/exports/queues/{queueId}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'action' in params:
            query_params['action'] = params['action']
        if 'cancel_running' in params:
            query_params['cancelRunning'] = params['cancel_running']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_export_work_queues_using_get1(self, **kwargs):
        """
        getExportWorkQueues
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_export_work_queues_using_get1(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str x_auth_token: auth token
        :return: ExportWorkQueueList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_export_work_queues_using_get1" % key
                )
            params[key] = val
        del params['kwargs']


        resource_path = '/api/latest/exports/queues'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportWorkQueueList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def update_all_export_work_queues_with_action_using_put1(self, action, cancel_running, **kwargs):
        """
        updateAllExportWorkQueuesWithAction
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_all_export_work_queues_with_action_using_put1(action, cancel_running, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action: action (required)
        :param str cancel_running: cancelRunning (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action', 'cancel_running', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_all_export_work_queues_with_action_using_put1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action' is set
        if ('action' not in params) or (params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `update_all_export_work_queues_with_action_using_put1`")
        # verify the required parameter 'cancel_running' is set
        if ('cancel_running' not in params) or (params['cancel_running'] is None):
            raise ValueError("Missing the required parameter `cancel_running` when calling `update_all_export_work_queues_with_action_using_put1`")

        resource_path = '/api/latest/exports/queues'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        query_params = {}
        if 'action' in params:
            query_params['action'] = params['action']
        if 'cancel_running' in params:
            query_params['cancelRunning'] = params['cancel_running']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_export_work_queue_request_using_post1(self, entity, **kwargs):
        """
        postExportWorkQueueRequest
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_export_work_queue_request_using_post1(entity, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExportWorkQueue entity: entity (required)
        :param str x_auth_token: auth token
        :return: Id
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_export_work_queue_request_using_post1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'entity' is set
        if ('entity' not in params) or (params['entity'] is None):
            raise ValueError("Missing the required parameter `entity` when calling `post_export_work_queue_request_using_post1`")

        resource_path = '/api/latest/exports/queues'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'entity' in params:
            body_params = params['entity']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Id',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def update_export_work_queue_with_action_using_put1(self, queue_id, action, cancel_running, **kwargs):
        """
        updateExportWorkQueueWithAction
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_export_work_queue_with_action_using_put1(queue_id, action, cancel_running, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str queue_id: queueId (required)
        :param str action: action (required)
        :param str cancel_running: cancelRunning (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['queue_id', 'action', 'cancel_running', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_export_work_queue_with_action_using_put1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `update_export_work_queue_with_action_using_put1`")
        # verify the required parameter 'action' is set
        if ('action' not in params) or (params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `update_export_work_queue_with_action_using_put1`")
        # verify the required parameter 'cancel_running' is set
        if ('cancel_running' not in params) or (params['cancel_running'] is None):
            raise ValueError("Missing the required parameter `cancel_running` when calling `update_export_work_queue_with_action_using_put1`")

        resource_path = '/api/latest/exports/queues/{queueId}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'action' in params:
            query_params['action'] = params['action']
        if 'cancel_running' in params:
            query_params['cancelRunning'] = params['cancel_running']

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
