# coding: utf-8

"""
TemplateresourceApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class TemplateresourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_templates_using_get2(self, **kwargs):
        """
        getTemplates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_templates_using_get2(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str x_auth_token: auth token
        :return: ExportTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_templates_using_get2" % key
                )
            params[key] = val
        del params['kwargs']


        resource_path = '/api/0.1/exports/templates'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportTemplateList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_template_using_post2(self, entity, **kwargs):
        """
        postTemplate
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_template_using_post2(entity, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExportTemplate entity: entity (required)
        :param str x_auth_token: auth token
        :return: Id
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_template_using_post2" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'entity' is set
        if ('entity' not in params) or (params['entity'] is None):
            raise ValueError("Missing the required parameter `entity` when calling `post_template_using_post2`")

        resource_path = '/api/0.1/exports/templates'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'entity' in params:
            body_params = params['entity']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Id',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_template_using_get(self, template_id, **kwargs):
        """
        getTemplate
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_using_get(template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str template_id: templateId (required)
        :param str x_auth_token: auth token
        :return: ExportTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_template_using_get`")

        resource_path = '/api/0.1/exports/templates/{templateId}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_template_using_put(self, template_id, entity, **kwargs):
        """
        putTemplate
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_template_using_put(template_id, entity, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str template_id: templateId (required)
        :param ExportTemplate entity: entity (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'entity', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_template_using_put" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `put_template_using_put`")
        # verify the required parameter 'entity' is set
        if ('entity' not in params) or (params['entity'] is None):
            raise ValueError("Missing the required parameter `entity` when calling `put_template_using_put`")

        resource_path = '/api/0.1/exports/templates/{templateId}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'entity' in params:
            body_params = params['entity']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_template_tags_using_get(self, template_id, **kwargs):
        """
        getTemplateTags
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_tags_using_get(template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str template_id: templateId (required)
        :param str x_auth_token: auth token
        :return: ExportTemplateTag
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_tags_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_template_tags_using_get`")

        resource_path = '/api/0.1/exports/templates/{templateId}/tags'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportTemplateTag',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_template_tags_using_post(self, template_id, tags, **kwargs):
        """
        postTemplateTags
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_template_tags_using_post(template_id, tags, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str template_id: templateId (required)
        :param ExportTemplateTag tags: tags (required)
        :param str x_auth_token: auth token
        :return: ExportTemplateTag
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'tags', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_template_tags_using_post" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `post_template_tags_using_post`")
        # verify the required parameter 'tags' is set
        if ('tags' not in params) or (params['tags'] is None):
            raise ValueError("Missing the required parameter `tags` when calling `post_template_tags_using_post`")

        resource_path = '/api/0.1/exports/templates/{templateId}/tags'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'tags' in params:
            body_params = params['tags']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportTemplateTag',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_templates_using_get3(self, **kwargs):
        """
        getTemplates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_templates_using_get3(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str x_auth_token: auth token
        :return: ExportTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_templates_using_get3" % key
                )
            params[key] = val
        del params['kwargs']


        resource_path = '/api/latest/exports/templates'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportTemplateList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_template_using_post3(self, entity, **kwargs):
        """
        postTemplate
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_template_using_post3(entity, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExportTemplate entity: entity (required)
        :param str x_auth_token: auth token
        :return: Id
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_template_using_post3" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'entity' is set
        if ('entity' not in params) or (params['entity'] is None):
            raise ValueError("Missing the required parameter `entity` when calling `post_template_using_post3`")

        resource_path = '/api/latest/exports/templates'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'entity' in params:
            body_params = params['entity']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Id',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_template_using_get1(self, template_id, **kwargs):
        """
        getTemplate
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_using_get1(template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str template_id: templateId (required)
        :param str x_auth_token: auth token
        :return: ExportTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_using_get1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_template_using_get1`")

        resource_path = '/api/latest/exports/templates/{templateId}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_template_using_put1(self, template_id, entity, **kwargs):
        """
        putTemplate
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_template_using_put1(template_id, entity, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str template_id: templateId (required)
        :param ExportTemplate entity: entity (required)
        :param str x_auth_token: auth token
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'entity', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_template_using_put1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `put_template_using_put1`")
        # verify the required parameter 'entity' is set
        if ('entity' not in params) or (params['entity'] is None):
            raise ValueError("Missing the required parameter `entity` when calling `put_template_using_put1`")

        resource_path = '/api/latest/exports/templates/{templateId}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'entity' in params:
            body_params = params['entity']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='InlineResponse200',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_template_tags_using_get1(self, template_id, **kwargs):
        """
        getTemplateTags
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_template_tags_using_get1(template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str template_id: templateId (required)
        :param str x_auth_token: auth token
        :return: ExportTemplateTag
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_tags_using_get1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `get_template_tags_using_get1`")

        resource_path = '/api/latest/exports/templates/{templateId}/tags'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportTemplateTag',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_template_tags_using_post1(self, template_id, tags, **kwargs):
        """
        postTemplateTags
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_template_tags_using_post1(template_id, tags, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str template_id: templateId (required)
        :param ExportTemplateTag tags: tags (required)
        :param str x_auth_token: auth token
        :return: ExportTemplateTag
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['template_id', 'tags', 'x_auth_token']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_template_tags_using_post1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'template_id' is set
        if ('template_id' not in params) or (params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `post_template_tags_using_post1`")
        # verify the required parameter 'tags' is set
        if ('tags' not in params) or (params['tags'] is None):
            raise ValueError("Missing the required parameter `tags` when calling `post_template_tags_using_post1`")

        resource_path = '/api/latest/exports/templates/{templateId}/tags'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'template_id' in params:
            path_params['templateId'] = params['template_id']

        query_params = {}

        header_params = {}
        if 'x_auth_token' in params:
            header_params['x-auth-token'] = params['x_auth_token']

        form_params = {}
        files = {}

        body_params = None
        if 'tags' in params:
            body_params = params['tags']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='ExportTemplateTag',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
