# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class ExportAccount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ExportAccount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'created_date': 'datetime',
            'export_limit': 'int',
            'export_work_queue_id': 'str',
            'id': 'str',
            'last_modified_date': 'datetime',
            'manage_client_id': 'int',
            'name': 'str',
            'templates': 'list[str]',
            'work_queue_id': 'str'
        }

        self.attribute_map = {
            'created_date': 'createdDate',
            'export_limit': 'exportLimit',
            'export_work_queue_id': 'exportWorkQueueId',
            'id': 'id',
            'last_modified_date': 'lastModifiedDate',
            'manage_client_id': 'manageClientId',
            'name': 'name',
            'templates': 'templates',
            'work_queue_id': 'workQueueId'
        }

        self._created_date = None
        self._export_limit = None
        self._export_work_queue_id = None
        self._id = None
        self._last_modified_date = None
        self._manage_client_id = None
        self._name = None
        self._templates = None
        self._work_queue_id = None

    @property
    def created_date(self):
        """
        Gets the created_date of this ExportAccount.


        :return: The created_date of this ExportAccount.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this ExportAccount.


        :param created_date: The created_date of this ExportAccount.
        :type: datetime
        """
        self._created_date = created_date

    @property
    def export_limit(self):
        """
        Gets the export_limit of this ExportAccount.


        :return: The export_limit of this ExportAccount.
        :rtype: int
        """
        return self._export_limit

    @export_limit.setter
    def export_limit(self, export_limit):
        """
        Sets the export_limit of this ExportAccount.


        :param export_limit: The export_limit of this ExportAccount.
        :type: int
        """
        self._export_limit = export_limit

    @property
    def export_work_queue_id(self):
        """
        Gets the export_work_queue_id of this ExportAccount.


        :return: The export_work_queue_id of this ExportAccount.
        :rtype: str
        """
        return self._export_work_queue_id

    @export_work_queue_id.setter
    def export_work_queue_id(self, export_work_queue_id):
        """
        Sets the export_work_queue_id of this ExportAccount.


        :param export_work_queue_id: The export_work_queue_id of this ExportAccount.
        :type: str
        """
        self._export_work_queue_id = export_work_queue_id

    @property
    def id(self):
        """
        Gets the id of this ExportAccount.


        :return: The id of this ExportAccount.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ExportAccount.


        :param id: The id of this ExportAccount.
        :type: str
        """
        self._id = id

    @property
    def last_modified_date(self):
        """
        Gets the last_modified_date of this ExportAccount.


        :return: The last_modified_date of this ExportAccount.
        :rtype: datetime
        """
        return self._last_modified_date

    @last_modified_date.setter
    def last_modified_date(self, last_modified_date):
        """
        Sets the last_modified_date of this ExportAccount.


        :param last_modified_date: The last_modified_date of this ExportAccount.
        :type: datetime
        """
        self._last_modified_date = last_modified_date

    @property
    def manage_client_id(self):
        """
        Gets the manage_client_id of this ExportAccount.


        :return: The manage_client_id of this ExportAccount.
        :rtype: int
        """
        return self._manage_client_id

    @manage_client_id.setter
    def manage_client_id(self, manage_client_id):
        """
        Sets the manage_client_id of this ExportAccount.


        :param manage_client_id: The manage_client_id of this ExportAccount.
        :type: int
        """
        self._manage_client_id = manage_client_id

    @property
    def name(self):
        """
        Gets the name of this ExportAccount.


        :return: The name of this ExportAccount.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ExportAccount.


        :param name: The name of this ExportAccount.
        :type: str
        """
        self._name = name

    @property
    def templates(self):
        """
        Gets the templates of this ExportAccount.


        :return: The templates of this ExportAccount.
        :rtype: list[str]
        """
        return self._templates

    @templates.setter
    def templates(self, templates):
        """
        Sets the templates of this ExportAccount.


        :param templates: The templates of this ExportAccount.
        :type: list[str]
        """
        self._templates = templates

    @property
    def work_queue_id(self):
        """
        Gets the work_queue_id of this ExportAccount.


        :return: The work_queue_id of this ExportAccount.
        :rtype: str
        """
        return self._work_queue_id

    @work_queue_id.setter
    def work_queue_id(self, work_queue_id):
        """
        Sets the work_queue_id of this ExportAccount.


        :param work_queue_id: The work_queue_id of this ExportAccount.
        :type: str
        """
        self._work_queue_id = work_queue_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

