# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class ExportConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ExportConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'active': 'bool',
            'end_time': 'datetime',
            'interval': 'str',
            'meta_data': 'ExportConfigMetaData',
            'name': 'str',
            'properties': 'object',
            'start_time': 'datetime',
            'template_id': 'str',
            'time_unit': 'str'
        }

        self.attribute_map = {
            'active': 'active',
            'end_time': 'endTime',
            'interval': 'interval',
            'meta_data': 'metaData',
            'name': 'name',
            'properties': 'properties',
            'start_time': 'startTime',
            'template_id': 'templateId',
            'time_unit': 'timeUnit'
        }

        self._active = None
        self._end_time = None
        self._interval = None
        self._meta_data = None
        self._name = None
        self._properties = None
        self._start_time = None
        self._template_id = None
        self._time_unit = None

    @property
    def active(self):
        """
        Gets the active of this ExportConfig.


        :return: The active of this ExportConfig.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this ExportConfig.


        :param active: The active of this ExportConfig.
        :type: bool
        """
        self._active = active

    @property
    def end_time(self):
        """
        Gets the end_time of this ExportConfig.


        :return: The end_time of this ExportConfig.
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """
        Sets the end_time of this ExportConfig.


        :param end_time: The end_time of this ExportConfig.
        :type: datetime
        """
        self._end_time = end_time

    @property
    def interval(self):
        """
        Gets the interval of this ExportConfig.
        Must be a factor of 24. 1,2,3,4,6,8,12,24 for Hours time unit. Must be between 1 and 7 for Days time unit.

        :return: The interval of this ExportConfig.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """
        Sets the interval of this ExportConfig.
        Must be a factor of 24. 1,2,3,4,6,8,12,24 for Hours time unit. Must be between 1 and 7 for Days time unit.

        :param interval: The interval of this ExportConfig.
        :type: str
        """
        self._interval = interval

    @property
    def meta_data(self):
        """
        Gets the meta_data of this ExportConfig.


        :return: The meta_data of this ExportConfig.
        :rtype: ExportConfigMetaData
        """
        return self._meta_data

    @meta_data.setter
    def meta_data(self, meta_data):
        """
        Sets the meta_data of this ExportConfig.


        :param meta_data: The meta_data of this ExportConfig.
        :type: ExportConfigMetaData
        """
        self._meta_data = meta_data

    @property
    def name(self):
        """
        Gets the name of this ExportConfig.


        :return: The name of this ExportConfig.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ExportConfig.


        :param name: The name of this ExportConfig.
        :type: str
        """
        self._name = name

    @property
    def properties(self):
        """
        Gets the properties of this ExportConfig.


        :return: The properties of this ExportConfig.
        :rtype: object
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this ExportConfig.


        :param properties: The properties of this ExportConfig.
        :type: object
        """
        self._properties = properties

    @property
    def start_time(self):
        """
        Gets the start_time of this ExportConfig.


        :return: The start_time of this ExportConfig.
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Sets the start_time of this ExportConfig.


        :param start_time: The start_time of this ExportConfig.
        :type: datetime
        """
        self._start_time = start_time

    @property
    def template_id(self):
        """
        Gets the template_id of this ExportConfig.


        :return: The template_id of this ExportConfig.
        :rtype: str
        """
        return self._template_id

    @template_id.setter
    def template_id(self, template_id):
        """
        Sets the template_id of this ExportConfig.


        :param template_id: The template_id of this ExportConfig.
        :type: str
        """
        self._template_id = template_id

    @property
    def time_unit(self):
        """
        Gets the time_unit of this ExportConfig.


        :return: The time_unit of this ExportConfig.
        :rtype: str
        """
        return self._time_unit

    @time_unit.setter
    def time_unit(self, time_unit):
        """
        Sets the time_unit of this ExportConfig.


        :param time_unit: The time_unit of this ExportConfig.
        :type: str
        """
        allowed_values = ["DAYS", "HOURS"]
        if time_unit not in allowed_values:
            raise ValueError(
                "Invalid value for `time_unit`, must be one of {0}"
                .format(allowed_values)
            )
        self._time_unit = time_unit

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

