# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class ExportConfigMetaData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ExportConfigMetaData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'number_of_pending_instances': 'int',
            'number_of_running_instances': 'int'
        }

        self.attribute_map = {
            'number_of_pending_instances': 'numberOfPendingInstances',
            'number_of_running_instances': 'numberOfRunningInstances'
        }

        self._number_of_pending_instances = None
        self._number_of_running_instances = None

    @property
    def number_of_pending_instances(self):
        """
        Gets the number_of_pending_instances of this ExportConfigMetaData.


        :return: The number_of_pending_instances of this ExportConfigMetaData.
        :rtype: int
        """
        return self._number_of_pending_instances

    @number_of_pending_instances.setter
    def number_of_pending_instances(self, number_of_pending_instances):
        """
        Sets the number_of_pending_instances of this ExportConfigMetaData.


        :param number_of_pending_instances: The number_of_pending_instances of this ExportConfigMetaData.
        :type: int
        """
        self._number_of_pending_instances = number_of_pending_instances

    @property
    def number_of_running_instances(self):
        """
        Gets the number_of_running_instances of this ExportConfigMetaData.


        :return: The number_of_running_instances of this ExportConfigMetaData.
        :rtype: int
        """
        return self._number_of_running_instances

    @number_of_running_instances.setter
    def number_of_running_instances(self, number_of_running_instances):
        """
        Sets the number_of_running_instances of this ExportConfigMetaData.


        :param number_of_running_instances: The number_of_running_instances of this ExportConfigMetaData.
        :type: int
        """
        self._number_of_running_instances = number_of_running_instances

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

