# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class ExportInstance(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ExportInstance - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'export_work_queue_id': 'str',
            'id': 'str',
            'instance_end_time': 'datetime',
            'instance_start_time': 'datetime',
            'status': 'str'
        }

        self.attribute_map = {
            'export_work_queue_id': 'exportWorkQueueId',
            'id': 'id',
            'instance_end_time': 'instanceEndTime',
            'instance_start_time': 'instanceStartTime',
            'status': 'status'
        }

        self._export_work_queue_id = None
        self._id = None
        self._instance_end_time = None
        self._instance_start_time = None
        self._status = None

    @property
    def export_work_queue_id(self):
        """
        Gets the export_work_queue_id of this ExportInstance.


        :return: The export_work_queue_id of this ExportInstance.
        :rtype: str
        """
        return self._export_work_queue_id

    @export_work_queue_id.setter
    def export_work_queue_id(self, export_work_queue_id):
        """
        Sets the export_work_queue_id of this ExportInstance.


        :param export_work_queue_id: The export_work_queue_id of this ExportInstance.
        :type: str
        """
        self._export_work_queue_id = export_work_queue_id

    @property
    def id(self):
        """
        Gets the id of this ExportInstance.


        :return: The id of this ExportInstance.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ExportInstance.


        :param id: The id of this ExportInstance.
        :type: str
        """
        self._id = id

    @property
    def instance_end_time(self):
        """
        Gets the instance_end_time of this ExportInstance.


        :return: The instance_end_time of this ExportInstance.
        :rtype: datetime
        """
        return self._instance_end_time

    @instance_end_time.setter
    def instance_end_time(self, instance_end_time):
        """
        Sets the instance_end_time of this ExportInstance.


        :param instance_end_time: The instance_end_time of this ExportInstance.
        :type: datetime
        """
        self._instance_end_time = instance_end_time

    @property
    def instance_start_time(self):
        """
        Gets the instance_start_time of this ExportInstance.


        :return: The instance_start_time of this ExportInstance.
        :rtype: datetime
        """
        return self._instance_start_time

    @instance_start_time.setter
    def instance_start_time(self, instance_start_time):
        """
        Sets the instance_start_time of this ExportInstance.


        :param instance_start_time: The instance_start_time of this ExportInstance.
        :type: datetime
        """
        self._instance_start_time = instance_start_time

    @property
    def status(self):
        """
        Gets the status of this ExportInstance.


        :return: The status of this ExportInstance.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ExportInstance.


        :param status: The status of this ExportInstance.
        :type: str
        """
        allowed_values = ["PENDING", "RUNNING", "COMPLETE", "DISABLED", "ERRORED"]
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status`, must be one of {0}"
                .format(allowed_values)
            )
        self._status = status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

