# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class ExportResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ExportResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'data_version': 'int',
            'estimated_total_size': 'int',
            'file_count': 'int',
            'id': 'str',
            'instance_end_time': 'datetime',
            'instance_start_time': 'datetime',
            'offset': 'int'
        }

        self.attribute_map = {
            'data_version': 'dataVersion',
            'estimated_total_size': 'estimatedTotalSize',
            'file_count': 'fileCount',
            'id': 'id',
            'instance_end_time': 'instanceEndTime',
            'instance_start_time': 'instanceStartTime',
            'offset': 'offset'
        }

        self._data_version = None
        self._estimated_total_size = None
        self._file_count = None
        self._id = None
        self._instance_end_time = None
        self._instance_start_time = None
        self._offset = None

    @property
    def data_version(self):
        """
        Gets the data_version of this ExportResult.


        :return: The data_version of this ExportResult.
        :rtype: int
        """
        return self._data_version

    @data_version.setter
    def data_version(self, data_version):
        """
        Sets the data_version of this ExportResult.


        :param data_version: The data_version of this ExportResult.
        :type: int
        """
        self._data_version = data_version

    @property
    def estimated_total_size(self):
        """
        Gets the estimated_total_size of this ExportResult.


        :return: The estimated_total_size of this ExportResult.
        :rtype: int
        """
        return self._estimated_total_size

    @estimated_total_size.setter
    def estimated_total_size(self, estimated_total_size):
        """
        Sets the estimated_total_size of this ExportResult.


        :param estimated_total_size: The estimated_total_size of this ExportResult.
        :type: int
        """
        self._estimated_total_size = estimated_total_size

    @property
    def file_count(self):
        """
        Gets the file_count of this ExportResult.


        :return: The file_count of this ExportResult.
        :rtype: int
        """
        return self._file_count

    @file_count.setter
    def file_count(self, file_count):
        """
        Sets the file_count of this ExportResult.


        :param file_count: The file_count of this ExportResult.
        :type: int
        """
        self._file_count = file_count

    @property
    def id(self):
        """
        Gets the id of this ExportResult.


        :return: The id of this ExportResult.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ExportResult.


        :param id: The id of this ExportResult.
        :type: str
        """
        self._id = id

    @property
    def instance_end_time(self):
        """
        Gets the instance_end_time of this ExportResult.
        string

        :return: The instance_end_time of this ExportResult.
        :rtype: datetime
        """
        return self._instance_end_time

    @instance_end_time.setter
    def instance_end_time(self, instance_end_time):
        """
        Sets the instance_end_time of this ExportResult.
        string

        :param instance_end_time: The instance_end_time of this ExportResult.
        :type: datetime
        """
        self._instance_end_time = instance_end_time

    @property
    def instance_start_time(self):
        """
        Gets the instance_start_time of this ExportResult.
        string

        :return: The instance_start_time of this ExportResult.
        :rtype: datetime
        """
        return self._instance_start_time

    @instance_start_time.setter
    def instance_start_time(self, instance_start_time):
        """
        Sets the instance_start_time of this ExportResult.
        string

        :param instance_start_time: The instance_start_time of this ExportResult.
        :type: datetime
        """
        self._instance_start_time = instance_start_time

    @property
    def offset(self):
        """
        Gets the offset of this ExportResult.


        :return: The offset of this ExportResult.
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """
        Sets the offset of this ExportResult.


        :param offset: The offset of this ExportResult.
        :type: int
        """
        self._offset = offset

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

