# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class ExportTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ExportTemplate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            '_global': 'bool',
            'id': 'str',
            'max_interval_millis': 'int',
            'min_interval_millis': 'int',
            'name': 'str',
            'properties': 'object',
            'query': 'str',
            'query_engine': 'str',
            'sink_query': 'str',
            'type': 'str'
        }

        self.attribute_map = {
            '_global': 'global',
            'id': 'id',
            'max_interval_millis': 'maxIntervalMillis',
            'min_interval_millis': 'minIntervalMillis',
            'name': 'name',
            'properties': 'properties',
            'query': 'query',
            'query_engine': 'queryEngine',
            'sink_query': 'sinkQuery',
            'type': 'type'
        }

        self.__global = None
        self._id = None
        self._max_interval_millis = None
        self._min_interval_millis = None
        self._name = None
        self._properties = None
        self._query = None
        self._query_engine = None
        self._sink_query = None
        self._type = None

    @property
    def _global(self):
        """
        Gets the _global of this ExportTemplate.


        :return: The _global of this ExportTemplate.
        :rtype: bool
        """
        return self.__global

    @_global.setter
    def _global(self, _global):
        """
        Sets the _global of this ExportTemplate.


        :param _global: The _global of this ExportTemplate.
        :type: bool
        """
        self.__global = _global

    @property
    def id(self):
        """
        Gets the id of this ExportTemplate.


        :return: The id of this ExportTemplate.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ExportTemplate.


        :param id: The id of this ExportTemplate.
        :type: str
        """
        self._id = id

    @property
    def max_interval_millis(self):
        """
        Gets the max_interval_millis of this ExportTemplate.


        :return: The max_interval_millis of this ExportTemplate.
        :rtype: int
        """
        return self._max_interval_millis

    @max_interval_millis.setter
    def max_interval_millis(self, max_interval_millis):
        """
        Sets the max_interval_millis of this ExportTemplate.


        :param max_interval_millis: The max_interval_millis of this ExportTemplate.
        :type: int
        """
        self._max_interval_millis = max_interval_millis

    @property
    def min_interval_millis(self):
        """
        Gets the min_interval_millis of this ExportTemplate.


        :return: The min_interval_millis of this ExportTemplate.
        :rtype: int
        """
        return self._min_interval_millis

    @min_interval_millis.setter
    def min_interval_millis(self, min_interval_millis):
        """
        Sets the min_interval_millis of this ExportTemplate.


        :param min_interval_millis: The min_interval_millis of this ExportTemplate.
        :type: int
        """
        self._min_interval_millis = min_interval_millis

    @property
    def name(self):
        """
        Gets the name of this ExportTemplate.


        :return: The name of this ExportTemplate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ExportTemplate.


        :param name: The name of this ExportTemplate.
        :type: str
        """
        self._name = name

    @property
    def properties(self):
        """
        Gets the properties of this ExportTemplate.


        :return: The properties of this ExportTemplate.
        :rtype: object
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this ExportTemplate.


        :param properties: The properties of this ExportTemplate.
        :type: object
        """
        self._properties = properties

    @property
    def query(self):
        """
        Gets the query of this ExportTemplate.


        :return: The query of this ExportTemplate.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this ExportTemplate.


        :param query: The query of this ExportTemplate.
        :type: str
        """
        self._query = query

    @property
    def query_engine(self):
        """
        Gets the query_engine of this ExportTemplate.


        :return: The query_engine of this ExportTemplate.
        :rtype: str
        """
        return self._query_engine

    @query_engine.setter
    def query_engine(self, query_engine):
        """
        Sets the query_engine of this ExportTemplate.


        :param query_engine: The query_engine of this ExportTemplate.
        :type: str
        """
        allowed_values = ["HIVE", "PRESTO"]
        if query_engine not in allowed_values:
            raise ValueError(
                "Invalid value for `query_engine`, must be one of {0}"
                .format(allowed_values)
            )
        self._query_engine = query_engine

    @property
    def sink_query(self):
        """
        Gets the sink_query of this ExportTemplate.


        :return: The sink_query of this ExportTemplate.
        :rtype: str
        """
        return self._sink_query

    @sink_query.setter
    def sink_query(self, sink_query):
        """
        Sets the sink_query of this ExportTemplate.


        :param sink_query: The sink_query of this ExportTemplate.
        :type: str
        """
        self._sink_query = sink_query

    @property
    def type(self):
        """
        Gets the type of this ExportTemplate.


        :return: The type of this ExportTemplate.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ExportTemplate.


        :param type: The type of this ExportTemplate.
        :type: str
        """
        allowed_values = ["INCREMENTAL", "SNAPSHOT"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )
        self._type = type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

