# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class ExportWorkQueue(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ExportWorkQueue - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'active': 'bool',
            'backfill': 'bool',
            'backfill_minute_threshold': 'int',
            'chief': 'bool',
            'cluster_tag': 'str',
            'id': 'str',
            'name': 'str',
            'out_of_bound_minutes': 'int',
            'slots': 'int'
        }

        self.attribute_map = {
            'active': 'active',
            'backfill': 'backfill',
            'backfill_minute_threshold': 'backfillMinuteThreshold',
            'chief': 'chief',
            'cluster_tag': 'clusterTag',
            'id': 'id',
            'name': 'name',
            'out_of_bound_minutes': 'outOfBoundMinutes',
            'slots': 'slots'
        }

        self._active = None
        self._backfill = None
        self._backfill_minute_threshold = None
        self._chief = None
        self._cluster_tag = None
        self._id = None
        self._name = None
        self._out_of_bound_minutes = None
        self._slots = None

    @property
    def active(self):
        """
        Gets the active of this ExportWorkQueue.


        :return: The active of this ExportWorkQueue.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this ExportWorkQueue.


        :param active: The active of this ExportWorkQueue.
        :type: bool
        """
        self._active = active

    @property
    def backfill(self):
        """
        Gets the backfill of this ExportWorkQueue.


        :return: The backfill of this ExportWorkQueue.
        :rtype: bool
        """
        return self._backfill

    @backfill.setter
    def backfill(self, backfill):
        """
        Sets the backfill of this ExportWorkQueue.


        :param backfill: The backfill of this ExportWorkQueue.
        :type: bool
        """
        self._backfill = backfill

    @property
    def backfill_minute_threshold(self):
        """
        Gets the backfill_minute_threshold of this ExportWorkQueue.


        :return: The backfill_minute_threshold of this ExportWorkQueue.
        :rtype: int
        """
        return self._backfill_minute_threshold

    @backfill_minute_threshold.setter
    def backfill_minute_threshold(self, backfill_minute_threshold):
        """
        Sets the backfill_minute_threshold of this ExportWorkQueue.


        :param backfill_minute_threshold: The backfill_minute_threshold of this ExportWorkQueue.
        :type: int
        """
        self._backfill_minute_threshold = backfill_minute_threshold

    @property
    def chief(self):
        """
        Gets the chief of this ExportWorkQueue.


        :return: The chief of this ExportWorkQueue.
        :rtype: bool
        """
        return self._chief

    @chief.setter
    def chief(self, chief):
        """
        Sets the chief of this ExportWorkQueue.


        :param chief: The chief of this ExportWorkQueue.
        :type: bool
        """
        self._chief = chief

    @property
    def cluster_tag(self):
        """
        Gets the cluster_tag of this ExportWorkQueue.


        :return: The cluster_tag of this ExportWorkQueue.
        :rtype: str
        """
        return self._cluster_tag

    @cluster_tag.setter
    def cluster_tag(self, cluster_tag):
        """
        Sets the cluster_tag of this ExportWorkQueue.


        :param cluster_tag: The cluster_tag of this ExportWorkQueue.
        :type: str
        """
        self._cluster_tag = cluster_tag

    @property
    def id(self):
        """
        Gets the id of this ExportWorkQueue.


        :return: The id of this ExportWorkQueue.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ExportWorkQueue.


        :param id: The id of this ExportWorkQueue.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ExportWorkQueue.


        :return: The name of this ExportWorkQueue.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ExportWorkQueue.


        :param name: The name of this ExportWorkQueue.
        :type: str
        """
        self._name = name

    @property
    def out_of_bound_minutes(self):
        """
        Gets the out_of_bound_minutes of this ExportWorkQueue.


        :return: The out_of_bound_minutes of this ExportWorkQueue.
        :rtype: int
        """
        return self._out_of_bound_minutes

    @out_of_bound_minutes.setter
    def out_of_bound_minutes(self, out_of_bound_minutes):
        """
        Sets the out_of_bound_minutes of this ExportWorkQueue.


        :param out_of_bound_minutes: The out_of_bound_minutes of this ExportWorkQueue.
        :type: int
        """
        self._out_of_bound_minutes = out_of_bound_minutes

    @property
    def slots(self):
        """
        Gets the slots of this ExportWorkQueue.


        :return: The slots of this ExportWorkQueue.
        :rtype: int
        """
        return self._slots

    @slots.setter
    def slots(self, slots):
        """
        Sets the slots of this ExportWorkQueue.


        :param slots: The slots of this ExportWorkQueue.
        :type: int
        """
        self._slots = slots

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

