# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class ModelAndView(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ModelAndView - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'empty': 'bool',
            'model': 'object',
            'model_map': 'dict(str, InlineResponse200)',
            'reference': 'bool',
            'view': 'View',
            'view_name': 'str'
        }

        self.attribute_map = {
            'empty': 'empty',
            'model': 'model',
            'model_map': 'modelMap',
            'reference': 'reference',
            'view': 'view',
            'view_name': 'viewName'
        }

        self._empty = None
        self._model = None
        self._model_map = None
        self._reference = None
        self._view = None
        self._view_name = None

    @property
    def empty(self):
        """
        Gets the empty of this ModelAndView.


        :return: The empty of this ModelAndView.
        :rtype: bool
        """
        return self._empty

    @empty.setter
    def empty(self, empty):
        """
        Sets the empty of this ModelAndView.


        :param empty: The empty of this ModelAndView.
        :type: bool
        """
        self._empty = empty

    @property
    def model(self):
        """
        Gets the model of this ModelAndView.


        :return: The model of this ModelAndView.
        :rtype: object
        """
        return self._model

    @model.setter
    def model(self, model):
        """
        Sets the model of this ModelAndView.


        :param model: The model of this ModelAndView.
        :type: object
        """
        self._model = model

    @property
    def model_map(self):
        """
        Gets the model_map of this ModelAndView.


        :return: The model_map of this ModelAndView.
        :rtype: dict(str, InlineResponse200)
        """
        return self._model_map

    @model_map.setter
    def model_map(self, model_map):
        """
        Sets the model_map of this ModelAndView.


        :param model_map: The model_map of this ModelAndView.
        :type: dict(str, InlineResponse200)
        """
        self._model_map = model_map

    @property
    def reference(self):
        """
        Gets the reference of this ModelAndView.


        :return: The reference of this ModelAndView.
        :rtype: bool
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """
        Sets the reference of this ModelAndView.


        :param reference: The reference of this ModelAndView.
        :type: bool
        """
        self._reference = reference

    @property
    def view(self):
        """
        Gets the view of this ModelAndView.


        :return: The view of this ModelAndView.
        :rtype: View
        """
        return self._view

    @view.setter
    def view(self, view):
        """
        Sets the view of this ModelAndView.


        :param view: The view of this ModelAndView.
        :type: View
        """
        self._view = view

    @property
    def view_name(self):
        """
        Gets the view_name of this ModelAndView.


        :return: The view_name of this ModelAndView.
        :rtype: str
        """
        return self._view_name

    @view_name.setter
    def view_name(self, view_name):
        """
        Sets the view_name of this ModelAndView.


        :param view_name: The view_name of this ModelAndView.
        :type: str
        """
        self._view_name = view_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

