# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class ResultFileUrlDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ResultFileUrlDTO - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'content_url': 'str',
            'estimated_size': 'int',
            'id': 'str'
        }

        self.attribute_map = {
            'content_url': 'contentUrl',
            'estimated_size': 'estimatedSize',
            'id': 'id'
        }

        self._content_url = None
        self._estimated_size = None
        self._id = None

    @property
    def content_url(self):
        """
        Gets the content_url of this ResultFileUrlDTO.


        :return: The content_url of this ResultFileUrlDTO.
        :rtype: str
        """
        return self._content_url

    @content_url.setter
    def content_url(self, content_url):
        """
        Sets the content_url of this ResultFileUrlDTO.


        :param content_url: The content_url of this ResultFileUrlDTO.
        :type: str
        """
        self._content_url = content_url

    @property
    def estimated_size(self):
        """
        Gets the estimated_size of this ResultFileUrlDTO.


        :return: The estimated_size of this ResultFileUrlDTO.
        :rtype: int
        """
        return self._estimated_size

    @estimated_size.setter
    def estimated_size(self, estimated_size):
        """
        Sets the estimated_size of this ResultFileUrlDTO.


        :param estimated_size: The estimated_size of this ResultFileUrlDTO.
        :type: int
        """
        self._estimated_size = estimated_size

    @property
    def id(self):
        """
        Gets the id of this ResultFileUrlDTO.


        :return: The id of this ResultFileUrlDTO.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ResultFileUrlDTO.


        :param id: The id of this ResultFileUrlDTO.
        :type: str
        """
        self._id = id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

