# This file is part of MOF-Synth.
# Copyright (C) 2023 Charalampos G. Livas

# MOF-Synth is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

"""
MOF-Synth is a Python package for synthesizability evaluation, with
emphasis on reticular chemistry.

.. note::
    Currently, optimizations are employed using  Universal Forcefield (UFF) potential.
"""

__author__ = 'Charalampos G. Livas'
__version__ = '1.0.2'
__copyright__ = "Copyright (c) 2023 Charalampos G. Livas"
__license__ = 'GPL-3.0-only'

from . utils import (
        main, run, check_opt, export_results
        )
