# Fc numbering from : https://imgt.org/IMGTScientificChart/Numbering/Hu_IGHGnber.html
# All species are human

sequences = [{ 'name': 'IgG1 G1m(z, non-a)', 'sequence': 'EPKSCDKTHTCPPCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAKGQPREPQVYTLPPSREEMTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK', 'subclass': 'IgG1', 'isotype':'IgG1', 'allotype': 'G1m17 | G1m(z)',
              'hinge_start_idx': 0, 'hinge_len': 15},
             { 'name': 'IgG1 G1m(f, non-a)', 'sequence': 'EPKSCDKTHTCPPCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAKGQPREPQVYTLPPSREEMTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK', 'subclass': 'IgG1', 'isotype':'IgG1', 'allotype': 'G1m3 | G1m(f)',
              'hinge_start_idx': 0, 'hinge_len': 15},
             { 'name': 'IgG1 G1m(a)', 'sequence': 'EPKSCDKTHTCPPCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAKGQPREPQVYTLPPSRDELTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK', 'subclass': 'IgG1', 'isotype':'IgG1', 'allotype': 'G1m1 | G1m(a)',
              'hinge_start_idx': 0, 'hinge_len': 15},
             { 'name': 'IgG1 nG1m(a)', 'sequence': 'EPKSCDKTHTCPPCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAKGQPREPQVYTLPPSREEMTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK', 'subclass': 'IgG1', 'isotype':'IgG1', 'allotype': 'nG1m1 | nG1m(a)',
              'hinge_start_idx': 0, 'hinge_len': 15},
             { 'name': 'IgG1 G1m(x)', 'sequence': 'EPKSCDKTHTCPPCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAKGQPREPQVYTLPPSRDELTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEGLHNHYTQKSLSLSPGK', 'subclass': 'IgG1', 'isotype':'IgG1', 'allotype': 'G1m2 | G1m(x)',
              'hinge_start_idx': 0, 'hinge_len': 15},
             { 'name': 'IgG1 nG1m(x)', 'sequence': 'EPKSCDKTHTCPPCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAKGQPREPQVYTLPPSRDELTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK', 'subclass': 'IgG1', 'isotype':'IgG1', 'allotype': 'nG1m2 | nG1m(x)',
              'hinge_start_idx': 0, 'hinge_len': 15},
             { 'name': 'IgG1 G1m(z,a)', 'sequence': 'EPKSCDKTHTCPPCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAKGQPREPQVYTLPPSRDELTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK', 'subclass': 'IgG1', 'isotype':'IgG1', 'allotype': 'G1m17 | G1m(z,a)',
              'hinge_start_idx': 0, 'hinge_len': 15},
             { 'name': 'IgG1 G1m(f,a)', 'sequence': 'EPKSCDKTHTCPPCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAKGQPREPQVYTLPPSRDELTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK', 'subclass': 'IgG1', 'isotype':'IgG1', 'allotype': 'G1m3 | G1m(f)',
              'hinge_start_idx': 0, 'hinge_len': 15},
             { 'name': 'IgG1 G1m(z,a,x)', 'sequence': 'EPKSCDKTHTCPPCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAKGQPREPQVYTLPPSRDELTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEGLHNHYTQKSLSLSPGK', 'subclass': 'IgG1', 'isotype':'IgG1', 'allotype': 'G1m17 | G1m(z,a)',
              'hinge_start_idx': 0, 'hinge_len': 15},
             { 'name': 'IgG2', 'sequence': 'ERKCCVECPPCPAPPVAGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVQFNWYVDGVEVHNAKTKPREEQFNSTFRVVSVLTVVHQDWLNGKEYKCKVSNKGLPAPIEKTISKTKGQPREPQVYTLPPSREEMTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPMLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK', 'subclass': 'IgG2', 'isotype':'IgG2', 'allotype': 'WT',
              'hinge_start_idx': 0, 'hinge_len': 12},
             { 'name': 'IgG3', 'sequence': 'ELKTPLGDTTHTCPRCPEPKSCDTPPPCPRCPEPKSCDTPPPCPRCPEPKSCDTPPPCPRCPAPELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVQFKWYVDGVEVHNAKTKPREEQYNSTFRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKTKGQPREPQVYTLPPSREEMTKNQVSLTCLVKGFYPSDIAVEWESSGQPENNYNTTPPMLDSDGSFFLYSKLTVDKSRWQQGNIFSCSVMHEALHNRFTQKSLSLSPGK', 'subclass': 'IgG3', 'isotype':'IgG3', 'allotype': 'WT',
              'hinge_start_idx': 0, 'hinge_len': 62},
             { 'name': 'IgG4', 'sequence': 'ESKYGPPCPPCPAPEFLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSQEDPEVQFNWYVDGVEVHNAKTKPREEQFNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKGLPSSIEKTISKAKGQPREPQVYTLPPSQEEMTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSRLTVDKSRWQEGNVFSCSVMHEALHNHYTQKSLSLSLGK', 'subclass': 'IgG4', 'isotype':'IgG4', 'allotype': 'WT',
              'hinge_start_idx': 0, 'hinge_len': 12},
             ]
hinge = [{'name': 'IgG1', 'sequence':'EPKSCDKTHTCPPCP', 'imgt': [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15], 'eu': [216,217,218,219,220,221,222,223,224,225,226,227,228,229,230], 'kabat':[226,227,228,232,233,234,235,236,237,238,239,240,241,242,243]},
         {'name': 'IgG2', 'sequence':'ERKCCVECPPCP', 'imgt': [1,2,3,4,5,6,7,8,9,10,11,12], 'eu': [216,217,218,219,220,222,224,226,227,228,229,230], 'kabat': [226,227,228,232,233,235,237,239,240,241,242,243]},
         {'name': 'IgG3', 'sequence':'ELKTPLGDTTHTCPRCPEPKSCDTPPPCPRCPEPKSCDTPPPCPRCPEPKSCDTPPPCPRCP', 'imgt': [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],
          'eu': [216,217,218,'-','-',219,220,221,222,223,224,225,226,227,228,'-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',229,230],
          'kabat':[226,227,228,229,230,232,233,234,235,236,237,238,239,240,241,'241A','241B','241C','241D','241E','241F','241G','241H','241I','241J','241K','241L','241M','241N','241O','241P','241Q','241R','241S','241T','241U','241V','241W','241X','241Y','241Z','241AA','241BB','241CC','241DD','241EE','241FF','241GG','241HH','241II','241JJ','241KK','241LL','241MM','241NN','241OO','241PP','241QQ','241RR','241SS',242,243]},
         {'name': 'IgG4', 'sequence':'ESKYGPPCPSCP', 'imgt': [1,2,3,4,5,6,7,8,9,10,11,12], 'eu': [216,217,218,'-','-',224,225,226,227,228,229,230], 'kabat':[226,227,228,229,230,237,238,239,240,241,242,243]},
         {'name': 'IgG4_S228P', 'sequence':'ESKYGPPCPPCP', 'imgt': [1,2,3,4,5,6,7,8,9,10,11,12], 'eu': [216,217,218,'-','-',224,225,226,227,228,229,230], 'kabat':[226,227,228,229,230,237,238,239,240,241,242,243]},
         ]

constant_domains = [{ 'isotype': 'IgG1', 'name': 'CH1', 'sequence':'ASTKGPSVFPLAPSSKSTSGGTAALGCLVKDYFPEPVTVSWNSGALTSGVHTFPAVLQSSGLYSLSSVVTVPSSSLGTQTYICNVNHKPSNTKVDKKV',
                     'annotation': ['-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98],
                     'eu': [118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215],
                     'kabat':[114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 156, 157, 162, 163, 164, 165, 166, 167, 168, 169, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 203, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223]},
                    { 'isotype': 'IgG1', 'name': 'CH2', 'sequence':'APELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVKFNWYVDGVEVHNAKTKPREEQYNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKAK', 
                     'annotation': ['-', '-', '-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'AB-TURN', 'AB-TURN', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110],
                     'eu': [231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340],
                     'kabat':[244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 295, 296, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 357, 358, 359, 360]},
                    { 'isotype': 'IgG1', 'name': 'CH3', 'sequence':'GQPREPQVYTLPPSRDELTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLSPGK',
                     'annotation': ['-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', '-', '-'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 'CHS 106', 'CHS 107'],
                     'eu': [341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447],
                     'kabat':[361, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 405, 406, 407, 408, 410, 411, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 430, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478]},
                    
                    { 'isotype': 'IgG2', 'name': 'CH1', 'sequence':'ASTKGPSVFPLAPCSRSTSESTAALGCLVKDYFPEPVTVSWNSGALTSGVHTFPAVLQSSGLYSLSSVVTVPSSNFGTQTYTCNVDHKPSNTKVDKTV',
                     'annotation': ['-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98],
                     'eu': [118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215],
                     'kabat':[114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 156, 157, 162, 163, 164, 165, 166, 167, 168, 169, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 203, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223]},
                    { 'isotype': 'IgG2', 'name': 'CH2', 'sequence':'APPVAGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVQFNWYVDGVEVHNAKTKPREEQFNSTFRVVSVLTVVHQDWLNGKEYKCKVSNKGLPAPIEKTISKTK', 
                     'annotation': ['-', '-', '-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'AB-TURN', 'AB-TURN', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110],
                     'eu': [231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340],
                     'kabat':[244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 295, 296, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 357, 358, 359, 360]},
                    { 'isotype': 'IgG2', 'name': 'CH3', 'sequence':'GQPREPQVYTLPPSREEMTKNQVSLTCLVKGFYPSDISVEWESNGQPENNYKTTPPMLDSDGSFFLYSKLTVDKSRWQQGNVFSCSVMHEALHNHYTQKLSLSPELQLEESCAEAQDGELDGLWTTITIFITLFLLSVCYSATITFFKVKWIFSSVVDLKQTIVPDYRNMIRQGA',
                     'annotation': ['-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', '-', '-'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 'CHS 106', 'CHS 107'],
                     'eu': [341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447],
                     'kabat':[361, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 405, 406, 407, 408, 410, 411, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 430, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478]},
                    
                    { 'isotype': 'IgG3', 'name': 'CH1', 'sequence':'ASTKGPSVFPLAPCSRSTSGGTAALGCLVKDYFPEPVTVSWNSGALTSGVHTFPAVLQSSGLYSLSSVVTVPSSSLGTQTYTCNVNHKPSNTKVDKRV',
                     'annotation': ['-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98],
                     'eu': [118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215],
                     'kabat':[114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 156, 157, 162, 163, 164, 165, 166, 167, 168, 169, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 203, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223]},
                    { 'isotype': 'IgG3', 'name': 'CH2', 'sequence':'APELLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSHEDPEVQFKWYVDGVEVHNAKTKPREEQYNSTFRVVSVLTVLHQDWLNGKEYKCKVSNKALPAPIEKTISKTK', 
                     'annotation': ['-', '-', '-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'AB-TURN', 'AB-TURN', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110],
                     'eu': [231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340],
                     'kabat':[244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 295, 296, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 357, 358, 359, 360]},
                    { 'isotype': 'IgG3', 'name': 'CH3', 'sequence':'GQPREPQVYTLPPSREEMTKNQVSLTCLVKGFYPSDIAVEWESSGQPENNYNTTPPMLDSDGSFFLYSKLTVDKSRWQQGNIFSCSVMHEALHNHFTQKSLSLSPGK',
                     'annotation': ['-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', '-', '-'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 'CHS 106', 'CHS 107'],
                     'eu': [341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447],
                     'kabat':[361, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 405, 406, 407, 408, 410, 411, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 430, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478]},
                    
                    
                    
                    { 'isotype': 'IgG4', 'name': 'CH1', 'sequence':'ASTKGPSVFPLAPCSRSTSESTAALGCLVKDYFPEPVTVSWNSGALTSGVHTFPAVLQSSGLYSLSSVVTVPSSSLGTKTYTCNVDHKPSNTKVDKRV',
                     'annotation': ['-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98],
                     'eu': [118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215],
                     'kabat':[114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 156, 157, 162, 163, 164, 165, 166, 167, 168, 169, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 203, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223]},
                    { 'isotype': 'IgG4', 'name': 'CH2', 'sequence':'APEFLGGPSVFLFPPKPKDTLMISRTPEVTCVVVDVSQEDPEVQFNWYVDGVEVHNAKTKPREEQFNSTYRVVSVLTVLHQDWLNGKEYKCKVSNKGLPSSIEKTISKAK', 
                     'annotation': ['-', '-', '-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'AB-TURN', 'AB-TURN', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110],
                     'eu': [231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340],
                     'kabat':[244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 295, 296, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 357, 358, 359, 360]},
                    { 'isotype': 'IgG4', 'name': 'CH3', 'sequence':'GQPREPQVYTLPPSQEEMTKNQVSLTCLVKGFYPSDIAVEWESNGQPENNYKTTPPVLDSDGSFFLYSRLTVDKSRWQQGNVFSCSVMHEALHNHYTQKSLSLS',
                     'annotation': ['-', '-', '-', '-', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'A-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'B-STRAND', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'BC-LOOP', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'C-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'CD-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'D-STRAND', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'DE-TURN', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'E-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'F-STRAND', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'FG-LOOP', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND', 'G-STRAND'],
                     'imgt':[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104],
                     'eu': [341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444],
                     'kabat':[361, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 405, 406, 407, 408, 410, 411, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 430, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475]},
                    
                    ]