# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOccCustomerGroupsResult',
    'AwaitableGetOccCustomerGroupsResult',
    'get_occ_customer_groups',
    'get_occ_customer_groups_output',
]

@pulumi.output_type
class GetOccCustomerGroupsResult:
    """
    A collection of values returned by getOccCustomerGroups.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, occ_customer_group_collections=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if occ_customer_group_collections and not isinstance(occ_customer_group_collections, list):
            raise TypeError("Expected argument 'occ_customer_group_collections' to be a list")
        pulumi.set(__self__, "occ_customer_group_collections", occ_customer_group_collections)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the tenancy containing the customer group.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the customer group.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOccCustomerGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The OCID of the customer group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="occCustomerGroupCollections")
    def occ_customer_group_collections(self) -> Sequence['outputs.GetOccCustomerGroupsOccCustomerGroupCollectionResult']:
        """
        The list of occ_customer_group_collection.
        """
        return pulumi.get(self, "occ_customer_group_collections")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        To determine whether the customer group is enabled/disabled.
        """
        return pulumi.get(self, "status")


class AwaitableGetOccCustomerGroupsResult(GetOccCustomerGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccCustomerGroupsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            occ_customer_group_collections=self.occ_customer_group_collections,
            status=self.status)


def get_occ_customer_groups(compartment_id: Optional[_builtins.str] = None,
                            display_name: Optional[_builtins.str] = None,
                            filters: Optional[Sequence[Union['GetOccCustomerGroupsFilterArgs', 'GetOccCustomerGroupsFilterArgsDict']]] = None,
                            id: Optional[_builtins.str] = None,
                            status: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccCustomerGroupsResult:
    """
    This data source provides the list of Occ Customer Groups in Oracle Cloud Infrastructure Capacity Management service.

    Lists all the customer groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_customer_groups = oci.CapacityManagement.get_occ_customer_groups(compartment_id=compartment_id,
        display_name=occ_customer_group_display_name,
        id=occ_customer_group_id,
        status=occ_customer_group_status)
    ```


    :param _builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param _builtins.str display_name: A filter to return only the resources that match the entire display name. The match is not case sensitive.
    :param _builtins.str id: A query filter to return the list result based on the customer group OCID. This is done for users who have INSPECT permission but do not have READ permission.
    :param _builtins.str status: A query filter to return the list result based on status.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getOccCustomerGroups:getOccCustomerGroups', __args__, opts=opts, typ=GetOccCustomerGroupsResult).value

    return AwaitableGetOccCustomerGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        occ_customer_group_collections=pulumi.get(__ret__, 'occ_customer_group_collections'),
        status=pulumi.get(__ret__, 'status'))
def get_occ_customer_groups_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOccCustomerGroupsFilterArgs', 'GetOccCustomerGroupsFilterArgsDict']]]]] = None,
                                   id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOccCustomerGroupsResult]:
    """
    This data source provides the list of Occ Customer Groups in Oracle Cloud Infrastructure Capacity Management service.

    Lists all the customer groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_customer_groups = oci.CapacityManagement.get_occ_customer_groups(compartment_id=compartment_id,
        display_name=occ_customer_group_display_name,
        id=occ_customer_group_id,
        status=occ_customer_group_status)
    ```


    :param _builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param _builtins.str display_name: A filter to return only the resources that match the entire display name. The match is not case sensitive.
    :param _builtins.str id: A query filter to return the list result based on the customer group OCID. This is done for users who have INSPECT permission but do not have READ permission.
    :param _builtins.str status: A query filter to return the list result based on status.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getOccCustomerGroups:getOccCustomerGroups', __args__, opts=opts, typ=GetOccCustomerGroupsResult)
    return __ret__.apply(lambda __response__: GetOccCustomerGroupsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        occ_customer_group_collections=pulumi.get(__response__, 'occ_customer_group_collections'),
        status=pulumi.get(__response__, 'status')))
