# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TargetAssetArgs', 'TargetAsset']

@pulumi.input_type
class TargetAssetArgs:
    def __init__(__self__, *,
                 is_excluded_from_execution: pulumi.Input[_builtins.bool],
                 migration_plan_id: pulumi.Input[_builtins.str],
                 preferred_shape_type: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 user_spec: pulumi.Input['TargetAssetUserSpecArgs'],
                 block_volumes_performance: Optional[pulumi.Input[_builtins.int]] = None,
                 ms_license: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TargetAsset resource.
        :param pulumi.Input[_builtins.bool] is_excluded_from_execution: (Updatable) A boolean indicating whether the asset should be migrated.
        :param pulumi.Input[_builtins.str] migration_plan_id: OCID of the associated migration plan.
        :param pulumi.Input[_builtins.str] preferred_shape_type: (Updatable) Preferred VM shape type that you provide.
        :param pulumi.Input[_builtins.str] type: (Updatable) The type of target asset.
        :param pulumi.Input['TargetAssetUserSpecArgs'] user_spec: (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        :param pulumi.Input[_builtins.int] block_volumes_performance: (Updatable) Performance of the block volumes.
        :param pulumi.Input[_builtins.str] ms_license: (Updatable) Microsoft license for the VM configuration.
        """
        pulumi.set(__self__, "is_excluded_from_execution", is_excluded_from_execution)
        pulumi.set(__self__, "migration_plan_id", migration_plan_id)
        pulumi.set(__self__, "preferred_shape_type", preferred_shape_type)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_spec", user_spec)
        if block_volumes_performance is not None:
            pulumi.set(__self__, "block_volumes_performance", block_volumes_performance)
        if ms_license is not None:
            pulumi.set(__self__, "ms_license", ms_license)

    @_builtins.property
    @pulumi.getter(name="isExcludedFromExecution")
    def is_excluded_from_execution(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) A boolean indicating whether the asset should be migrated.
        """
        return pulumi.get(self, "is_excluded_from_execution")

    @is_excluded_from_execution.setter
    def is_excluded_from_execution(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_excluded_from_execution", value)

    @_builtins.property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> pulumi.Input[_builtins.str]:
        """
        OCID of the associated migration plan.
        """
        return pulumi.get(self, "migration_plan_id")

    @migration_plan_id.setter
    def migration_plan_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "migration_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="preferredShapeType")
    def preferred_shape_type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Preferred VM shape type that you provide.
        """
        return pulumi.get(self, "preferred_shape_type")

    @preferred_shape_type.setter
    def preferred_shape_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "preferred_shape_type", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The type of target asset.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userSpec")
    def user_spec(self) -> pulumi.Input['TargetAssetUserSpecArgs']:
        """
        (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "user_spec")

    @user_spec.setter
    def user_spec(self, value: pulumi.Input['TargetAssetUserSpecArgs']):
        pulumi.set(self, "user_spec", value)

    @_builtins.property
    @pulumi.getter(name="blockVolumesPerformance")
    def block_volumes_performance(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Performance of the block volumes.
        """
        return pulumi.get(self, "block_volumes_performance")

    @block_volumes_performance.setter
    def block_volumes_performance(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "block_volumes_performance", value)

    @_builtins.property
    @pulumi.getter(name="msLicense")
    def ms_license(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Microsoft license for the VM configuration.
        """
        return pulumi.get(self, "ms_license")

    @ms_license.setter
    def ms_license(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ms_license", value)


@pulumi.input_type
class _TargetAssetState:
    def __init__(__self__, *,
                 block_volumes_performance: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compatibility_messages: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetCompatibilityMessageArgs']]]] = None,
                 created_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 estimated_costs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetEstimatedCostArgs']]]] = None,
                 is_excluded_from_execution: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 migration_assets: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetMigrationAssetArgs']]]] = None,
                 migration_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ms_license: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_shape_type: Optional[pulumi.Input[_builtins.str]] = None,
                 recommended_specs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetRecommendedSpecArgs']]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 test_specs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetTestSpecArgs']]]] = None,
                 time_assessed: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_spec: Optional[pulumi.Input['TargetAssetUserSpecArgs']] = None):
        """
        Input properties used for looking up and filtering TargetAsset resources.
        :param pulumi.Input[_builtins.int] block_volumes_performance: (Updatable) Performance of the block volumes.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssetCompatibilityMessageArgs']]] compatibility_messages: Messages about the compatibility issues.
        :param pulumi.Input[_builtins.str] created_resource_id: Created resource identifier
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssetEstimatedCostArgs']]] estimated_costs: Cost estimation description
        :param pulumi.Input[_builtins.bool] is_excluded_from_execution: (Updatable) A boolean indicating whether the asset should be migrated.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssetMigrationAssetArgs']]] migration_assets: Description of the migration asset.
        :param pulumi.Input[_builtins.str] migration_plan_id: OCID of the associated migration plan.
        :param pulumi.Input[_builtins.str] ms_license: (Updatable) Microsoft license for the VM configuration.
        :param pulumi.Input[_builtins.str] preferred_shape_type: (Updatable) Preferred VM shape type that you provide.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssetRecommendedSpecArgs']]] recommended_specs: Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        :param pulumi.Input[_builtins.str] state: The current state of the target asset.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssetTestSpecArgs']]] test_specs: Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        :param pulumi.Input[_builtins.str] time_assessed: The time when the assessment was done. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_created: The time when the target asset was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time when the target asset was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] type: (Updatable) The type of target asset.
        :param pulumi.Input['TargetAssetUserSpecArgs'] user_spec: (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        if block_volumes_performance is not None:
            pulumi.set(__self__, "block_volumes_performance", block_volumes_performance)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compatibility_messages is not None:
            pulumi.set(__self__, "compatibility_messages", compatibility_messages)
        if created_resource_id is not None:
            pulumi.set(__self__, "created_resource_id", created_resource_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if estimated_costs is not None:
            pulumi.set(__self__, "estimated_costs", estimated_costs)
        if is_excluded_from_execution is not None:
            pulumi.set(__self__, "is_excluded_from_execution", is_excluded_from_execution)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if migration_assets is not None:
            pulumi.set(__self__, "migration_assets", migration_assets)
        if migration_plan_id is not None:
            pulumi.set(__self__, "migration_plan_id", migration_plan_id)
        if ms_license is not None:
            pulumi.set(__self__, "ms_license", ms_license)
        if preferred_shape_type is not None:
            pulumi.set(__self__, "preferred_shape_type", preferred_shape_type)
        if recommended_specs is not None:
            pulumi.set(__self__, "recommended_specs", recommended_specs)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if test_specs is not None:
            pulumi.set(__self__, "test_specs", test_specs)
        if time_assessed is not None:
            pulumi.set(__self__, "time_assessed", time_assessed)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_spec is not None:
            pulumi.set(__self__, "user_spec", user_spec)

    @_builtins.property
    @pulumi.getter(name="blockVolumesPerformance")
    def block_volumes_performance(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Performance of the block volumes.
        """
        return pulumi.get(self, "block_volumes_performance")

    @block_volumes_performance.setter
    def block_volumes_performance(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "block_volumes_performance", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="compatibilityMessages")
    def compatibility_messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetCompatibilityMessageArgs']]]]:
        """
        Messages about the compatibility issues.
        """
        return pulumi.get(self, "compatibility_messages")

    @compatibility_messages.setter
    def compatibility_messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetCompatibilityMessageArgs']]]]):
        pulumi.set(self, "compatibility_messages", value)

    @_builtins.property
    @pulumi.getter(name="createdResourceId")
    def created_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Created resource identifier
        """
        return pulumi.get(self, "created_resource_id")

    @created_resource_id.setter
    def created_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="estimatedCosts")
    def estimated_costs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetEstimatedCostArgs']]]]:
        """
        Cost estimation description
        """
        return pulumi.get(self, "estimated_costs")

    @estimated_costs.setter
    def estimated_costs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetEstimatedCostArgs']]]]):
        pulumi.set(self, "estimated_costs", value)

    @_builtins.property
    @pulumi.getter(name="isExcludedFromExecution")
    def is_excluded_from_execution(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A boolean indicating whether the asset should be migrated.
        """
        return pulumi.get(self, "is_excluded_from_execution")

    @is_excluded_from_execution.setter
    def is_excluded_from_execution(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_excluded_from_execution", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="migrationAssets")
    def migration_assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetMigrationAssetArgs']]]]:
        """
        Description of the migration asset.
        """
        return pulumi.get(self, "migration_assets")

    @migration_assets.setter
    def migration_assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetMigrationAssetArgs']]]]):
        pulumi.set(self, "migration_assets", value)

    @_builtins.property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the associated migration plan.
        """
        return pulumi.get(self, "migration_plan_id")

    @migration_plan_id.setter
    def migration_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "migration_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="msLicense")
    def ms_license(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Microsoft license for the VM configuration.
        """
        return pulumi.get(self, "ms_license")

    @ms_license.setter
    def ms_license(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ms_license", value)

    @_builtins.property
    @pulumi.getter(name="preferredShapeType")
    def preferred_shape_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Preferred VM shape type that you provide.
        """
        return pulumi.get(self, "preferred_shape_type")

    @preferred_shape_type.setter
    def preferred_shape_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_shape_type", value)

    @_builtins.property
    @pulumi.getter(name="recommendedSpecs")
    def recommended_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetRecommendedSpecArgs']]]]:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "recommended_specs")

    @recommended_specs.setter
    def recommended_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetRecommendedSpecArgs']]]]):
        pulumi.set(self, "recommended_specs", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the target asset.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="testSpecs")
    def test_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetTestSpecArgs']]]]:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "test_specs")

    @test_specs.setter
    def test_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetTestSpecArgs']]]]):
        pulumi.set(self, "test_specs", value)

    @_builtins.property
    @pulumi.getter(name="timeAssessed")
    def time_assessed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the assessment was done. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_assessed")

    @time_assessed.setter
    def time_assessed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_assessed", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the target asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the target asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The type of target asset.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userSpec")
    def user_spec(self) -> Optional[pulumi.Input['TargetAssetUserSpecArgs']]:
        """
        (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "user_spec")

    @user_spec.setter
    def user_spec(self, value: Optional[pulumi.Input['TargetAssetUserSpecArgs']]):
        pulumi.set(self, "user_spec", value)


@pulumi.type_token("oci:CloudMigrations/targetAsset:TargetAsset")
class TargetAsset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_volumes_performance: Optional[pulumi.Input[_builtins.int]] = None,
                 is_excluded_from_execution: Optional[pulumi.Input[_builtins.bool]] = None,
                 migration_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ms_license: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_shape_type: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_spec: Optional[pulumi.Input[Union['TargetAssetUserSpecArgs', 'TargetAssetUserSpecArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Target Asset resource in Oracle Cloud Infrastructure Cloud Migrations service.

        Creates a target asset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target_asset = oci.cloudmigrations.TargetAsset("test_target_asset",
            is_excluded_from_execution=target_asset_is_excluded_from_execution,
            migration_plan_id=test_migration_plan["id"],
            preferred_shape_type=target_asset_preferred_shape_type,
            type=target_asset_type,
            user_spec={
                "agent_config": {
                    "are_all_plugins_disabled": target_asset_user_spec_agent_config_are_all_plugins_disabled,
                    "is_management_disabled": target_asset_user_spec_agent_config_is_management_disabled,
                    "is_monitoring_disabled": target_asset_user_spec_agent_config_is_monitoring_disabled,
                    "plugins_configs": [{
                        "desired_state": target_asset_user_spec_agent_config_plugins_config_desired_state,
                        "name": target_asset_user_spec_agent_config_plugins_config_name,
                    }],
                },
                "availability_domain": target_asset_user_spec_availability_domain,
                "capacity_reservation_id": test_capacity_reservation["id"],
                "compartment_id": compartment_id,
                "create_vnic_details": {
                    "assign_private_dns_record": target_asset_user_spec_create_vnic_details_assign_private_dns_record,
                    "assign_public_ip": target_asset_user_spec_create_vnic_details_assign_public_ip,
                    "defined_tags": {
                        "foo-namespace.bar-key": "value",
                    },
                    "display_name": target_asset_user_spec_create_vnic_details_display_name,
                    "freeform_tags": {
                        "bar-key": "value",
                    },
                    "hostname_label": target_asset_user_spec_create_vnic_details_hostname_label,
                    "nsg_ids": target_asset_user_spec_create_vnic_details_nsg_ids,
                    "private_ip": target_asset_user_spec_create_vnic_details_private_ip,
                    "skip_source_dest_check": target_asset_user_spec_create_vnic_details_skip_source_dest_check,
                    "subnet_id": test_subnet["id"],
                    "vlan_id": test_vlan["id"],
                },
                "dedicated_vm_host_id": test_dedicated_vm_host["id"],
                "defined_tags": {
                    "foo-namespace.bar-key": "value",
                },
                "display_name": target_asset_user_spec_display_name,
                "fault_domain": target_asset_user_spec_fault_domain,
                "freeform_tags": {
                    "bar-key": "value",
                },
                "hostname_label": target_asset_user_spec_hostname_label,
                "instance_options": {
                    "are_legacy_imds_endpoints_disabled": target_asset_user_spec_instance_options_are_legacy_imds_endpoints_disabled,
                },
                "ipxe_script": target_asset_user_spec_ipxe_script,
                "is_pv_encryption_in_transit_enabled": target_asset_user_spec_is_pv_encryption_in_transit_enabled,
                "preemptible_instance_config": {
                    "preemption_action": {
                        "type": target_asset_user_spec_preemptible_instance_config_preemption_action_type,
                        "preserve_boot_volume": target_asset_user_spec_preemptible_instance_config_preemption_action_preserve_boot_volume,
                    },
                },
                "shape": target_asset_user_spec_shape,
                "shape_config": {
                    "baseline_ocpu_utilization": target_asset_user_spec_shape_config_baseline_ocpu_utilization,
                    "memory_in_gbs": target_asset_user_spec_shape_config_memory_in_gbs,
                    "ocpus": target_asset_user_spec_shape_config_ocpus,
                },
                "source_details": {
                    "source_type": target_asset_user_spec_source_details_source_type,
                    "boot_volume_id": test_boot_volume["id"],
                    "boot_volume_size_in_gbs": target_asset_user_spec_source_details_boot_volume_size_in_gbs,
                    "boot_volume_vpus_per_gb": target_asset_user_spec_source_details_boot_volume_vpus_per_gb,
                    "image_id": test_image["id"],
                    "kms_key_id": test_key["id"],
                },
            },
            block_volumes_performance=target_asset_block_volumes_performance,
            ms_license=target_asset_ms_license)
        ```

        ## Import

        TargetAssets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudMigrations/targetAsset:TargetAsset test_target_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] block_volumes_performance: (Updatable) Performance of the block volumes.
        :param pulumi.Input[_builtins.bool] is_excluded_from_execution: (Updatable) A boolean indicating whether the asset should be migrated.
        :param pulumi.Input[_builtins.str] migration_plan_id: OCID of the associated migration plan.
        :param pulumi.Input[_builtins.str] ms_license: (Updatable) Microsoft license for the VM configuration.
        :param pulumi.Input[_builtins.str] preferred_shape_type: (Updatable) Preferred VM shape type that you provide.
        :param pulumi.Input[_builtins.str] type: (Updatable) The type of target asset.
        :param pulumi.Input[Union['TargetAssetUserSpecArgs', 'TargetAssetUserSpecArgsDict']] user_spec: (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TargetAssetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Target Asset resource in Oracle Cloud Infrastructure Cloud Migrations service.

        Creates a target asset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target_asset = oci.cloudmigrations.TargetAsset("test_target_asset",
            is_excluded_from_execution=target_asset_is_excluded_from_execution,
            migration_plan_id=test_migration_plan["id"],
            preferred_shape_type=target_asset_preferred_shape_type,
            type=target_asset_type,
            user_spec={
                "agent_config": {
                    "are_all_plugins_disabled": target_asset_user_spec_agent_config_are_all_plugins_disabled,
                    "is_management_disabled": target_asset_user_spec_agent_config_is_management_disabled,
                    "is_monitoring_disabled": target_asset_user_spec_agent_config_is_monitoring_disabled,
                    "plugins_configs": [{
                        "desired_state": target_asset_user_spec_agent_config_plugins_config_desired_state,
                        "name": target_asset_user_spec_agent_config_plugins_config_name,
                    }],
                },
                "availability_domain": target_asset_user_spec_availability_domain,
                "capacity_reservation_id": test_capacity_reservation["id"],
                "compartment_id": compartment_id,
                "create_vnic_details": {
                    "assign_private_dns_record": target_asset_user_spec_create_vnic_details_assign_private_dns_record,
                    "assign_public_ip": target_asset_user_spec_create_vnic_details_assign_public_ip,
                    "defined_tags": {
                        "foo-namespace.bar-key": "value",
                    },
                    "display_name": target_asset_user_spec_create_vnic_details_display_name,
                    "freeform_tags": {
                        "bar-key": "value",
                    },
                    "hostname_label": target_asset_user_spec_create_vnic_details_hostname_label,
                    "nsg_ids": target_asset_user_spec_create_vnic_details_nsg_ids,
                    "private_ip": target_asset_user_spec_create_vnic_details_private_ip,
                    "skip_source_dest_check": target_asset_user_spec_create_vnic_details_skip_source_dest_check,
                    "subnet_id": test_subnet["id"],
                    "vlan_id": test_vlan["id"],
                },
                "dedicated_vm_host_id": test_dedicated_vm_host["id"],
                "defined_tags": {
                    "foo-namespace.bar-key": "value",
                },
                "display_name": target_asset_user_spec_display_name,
                "fault_domain": target_asset_user_spec_fault_domain,
                "freeform_tags": {
                    "bar-key": "value",
                },
                "hostname_label": target_asset_user_spec_hostname_label,
                "instance_options": {
                    "are_legacy_imds_endpoints_disabled": target_asset_user_spec_instance_options_are_legacy_imds_endpoints_disabled,
                },
                "ipxe_script": target_asset_user_spec_ipxe_script,
                "is_pv_encryption_in_transit_enabled": target_asset_user_spec_is_pv_encryption_in_transit_enabled,
                "preemptible_instance_config": {
                    "preemption_action": {
                        "type": target_asset_user_spec_preemptible_instance_config_preemption_action_type,
                        "preserve_boot_volume": target_asset_user_spec_preemptible_instance_config_preemption_action_preserve_boot_volume,
                    },
                },
                "shape": target_asset_user_spec_shape,
                "shape_config": {
                    "baseline_ocpu_utilization": target_asset_user_spec_shape_config_baseline_ocpu_utilization,
                    "memory_in_gbs": target_asset_user_spec_shape_config_memory_in_gbs,
                    "ocpus": target_asset_user_spec_shape_config_ocpus,
                },
                "source_details": {
                    "source_type": target_asset_user_spec_source_details_source_type,
                    "boot_volume_id": test_boot_volume["id"],
                    "boot_volume_size_in_gbs": target_asset_user_spec_source_details_boot_volume_size_in_gbs,
                    "boot_volume_vpus_per_gb": target_asset_user_spec_source_details_boot_volume_vpus_per_gb,
                    "image_id": test_image["id"],
                    "kms_key_id": test_key["id"],
                },
            },
            block_volumes_performance=target_asset_block_volumes_performance,
            ms_license=target_asset_ms_license)
        ```

        ## Import

        TargetAssets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudMigrations/targetAsset:TargetAsset test_target_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param TargetAssetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetAssetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_volumes_performance: Optional[pulumi.Input[_builtins.int]] = None,
                 is_excluded_from_execution: Optional[pulumi.Input[_builtins.bool]] = None,
                 migration_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ms_license: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_shape_type: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_spec: Optional[pulumi.Input[Union['TargetAssetUserSpecArgs', 'TargetAssetUserSpecArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetAssetArgs.__new__(TargetAssetArgs)

            __props__.__dict__["block_volumes_performance"] = block_volumes_performance
            if is_excluded_from_execution is None and not opts.urn:
                raise TypeError("Missing required property 'is_excluded_from_execution'")
            __props__.__dict__["is_excluded_from_execution"] = is_excluded_from_execution
            if migration_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'migration_plan_id'")
            __props__.__dict__["migration_plan_id"] = migration_plan_id
            __props__.__dict__["ms_license"] = ms_license
            if preferred_shape_type is None and not opts.urn:
                raise TypeError("Missing required property 'preferred_shape_type'")
            __props__.__dict__["preferred_shape_type"] = preferred_shape_type
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if user_spec is None and not opts.urn:
                raise TypeError("Missing required property 'user_spec'")
            __props__.__dict__["user_spec"] = user_spec
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["compatibility_messages"] = None
            __props__.__dict__["created_resource_id"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["estimated_costs"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["migration_assets"] = None
            __props__.__dict__["recommended_specs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["test_specs"] = None
            __props__.__dict__["time_assessed"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(TargetAsset, __self__).__init__(
            'oci:CloudMigrations/targetAsset:TargetAsset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            block_volumes_performance: Optional[pulumi.Input[_builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compatibility_messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetAssetCompatibilityMessageArgs', 'TargetAssetCompatibilityMessageArgsDict']]]]] = None,
            created_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            estimated_costs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetAssetEstimatedCostArgs', 'TargetAssetEstimatedCostArgsDict']]]]] = None,
            is_excluded_from_execution: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            migration_assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetAssetMigrationAssetArgs', 'TargetAssetMigrationAssetArgsDict']]]]] = None,
            migration_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            ms_license: Optional[pulumi.Input[_builtins.str]] = None,
            preferred_shape_type: Optional[pulumi.Input[_builtins.str]] = None,
            recommended_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetAssetRecommendedSpecArgs', 'TargetAssetRecommendedSpecArgsDict']]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            test_specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetAssetTestSpecArgs', 'TargetAssetTestSpecArgsDict']]]]] = None,
            time_assessed: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_spec: Optional[pulumi.Input[Union['TargetAssetUserSpecArgs', 'TargetAssetUserSpecArgsDict']]] = None) -> 'TargetAsset':
        """
        Get an existing TargetAsset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] block_volumes_performance: (Updatable) Performance of the block volumes.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetAssetCompatibilityMessageArgs', 'TargetAssetCompatibilityMessageArgsDict']]]] compatibility_messages: Messages about the compatibility issues.
        :param pulumi.Input[_builtins.str] created_resource_id: Created resource identifier
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetAssetEstimatedCostArgs', 'TargetAssetEstimatedCostArgsDict']]]] estimated_costs: Cost estimation description
        :param pulumi.Input[_builtins.bool] is_excluded_from_execution: (Updatable) A boolean indicating whether the asset should be migrated.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetAssetMigrationAssetArgs', 'TargetAssetMigrationAssetArgsDict']]]] migration_assets: Description of the migration asset.
        :param pulumi.Input[_builtins.str] migration_plan_id: OCID of the associated migration plan.
        :param pulumi.Input[_builtins.str] ms_license: (Updatable) Microsoft license for the VM configuration.
        :param pulumi.Input[_builtins.str] preferred_shape_type: (Updatable) Preferred VM shape type that you provide.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetAssetRecommendedSpecArgs', 'TargetAssetRecommendedSpecArgsDict']]]] recommended_specs: Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        :param pulumi.Input[_builtins.str] state: The current state of the target asset.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetAssetTestSpecArgs', 'TargetAssetTestSpecArgsDict']]]] test_specs: Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        :param pulumi.Input[_builtins.str] time_assessed: The time when the assessment was done. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_created: The time when the target asset was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The time when the target asset was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[_builtins.str] type: (Updatable) The type of target asset.
        :param pulumi.Input[Union['TargetAssetUserSpecArgs', 'TargetAssetUserSpecArgsDict']] user_spec: (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetAssetState.__new__(_TargetAssetState)

        __props__.__dict__["block_volumes_performance"] = block_volumes_performance
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compatibility_messages"] = compatibility_messages
        __props__.__dict__["created_resource_id"] = created_resource_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["estimated_costs"] = estimated_costs
        __props__.__dict__["is_excluded_from_execution"] = is_excluded_from_execution
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["migration_assets"] = migration_assets
        __props__.__dict__["migration_plan_id"] = migration_plan_id
        __props__.__dict__["ms_license"] = ms_license
        __props__.__dict__["preferred_shape_type"] = preferred_shape_type
        __props__.__dict__["recommended_specs"] = recommended_specs
        __props__.__dict__["state"] = state
        __props__.__dict__["test_specs"] = test_specs
        __props__.__dict__["time_assessed"] = time_assessed
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["user_spec"] = user_spec
        return TargetAsset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="blockVolumesPerformance")
    def block_volumes_performance(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Performance of the block volumes.
        """
        return pulumi.get(self, "block_volumes_performance")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compatibilityMessages")
    def compatibility_messages(self) -> pulumi.Output[Sequence['outputs.TargetAssetCompatibilityMessage']]:
        """
        Messages about the compatibility issues.
        """
        return pulumi.get(self, "compatibility_messages")

    @_builtins.property
    @pulumi.getter(name="createdResourceId")
    def created_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        Created resource identifier
        """
        return pulumi.get(self, "created_resource_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="estimatedCosts")
    def estimated_costs(self) -> pulumi.Output[Sequence['outputs.TargetAssetEstimatedCost']]:
        """
        Cost estimation description
        """
        return pulumi.get(self, "estimated_costs")

    @_builtins.property
    @pulumi.getter(name="isExcludedFromExecution")
    def is_excluded_from_execution(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) A boolean indicating whether the asset should be migrated.
        """
        return pulumi.get(self, "is_excluded_from_execution")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="migrationAssets")
    def migration_assets(self) -> pulumi.Output[Sequence['outputs.TargetAssetMigrationAsset']]:
        """
        Description of the migration asset.
        """
        return pulumi.get(self, "migration_assets")

    @_builtins.property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID of the associated migration plan.
        """
        return pulumi.get(self, "migration_plan_id")

    @_builtins.property
    @pulumi.getter(name="msLicense")
    def ms_license(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Microsoft license for the VM configuration.
        """
        return pulumi.get(self, "ms_license")

    @_builtins.property
    @pulumi.getter(name="preferredShapeType")
    def preferred_shape_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Preferred VM shape type that you provide.
        """
        return pulumi.get(self, "preferred_shape_type")

    @_builtins.property
    @pulumi.getter(name="recommendedSpecs")
    def recommended_specs(self) -> pulumi.Output[Sequence['outputs.TargetAssetRecommendedSpec']]:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "recommended_specs")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the target asset.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="testSpecs")
    def test_specs(self) -> pulumi.Output[Sequence['outputs.TargetAssetTestSpec']]:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "test_specs")

    @_builtins.property
    @pulumi.getter(name="timeAssessed")
    def time_assessed(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the assessment was done. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_assessed")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the target asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the target asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The type of target asset.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userSpec")
    def user_spec(self) -> pulumi.Output['outputs.TargetAssetUserSpec']:
        """
        (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "user_spec")

