# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBootVolumeResult',
    'AwaitableGetBootVolumeResult',
    'get_boot_volume',
    'get_boot_volume_output',
]

@pulumi.output_type
class GetBootVolumeResult:
    """
    A collection of values returned by getBootVolume.
    """
    def __init__(__self__, auto_tuned_vpus_per_gb=None, autotune_policies=None, availability_domain=None, backup_policy_id=None, boot_volume_id=None, boot_volume_replicas=None, boot_volume_replicas_deletion=None, cluster_placement_group_id=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, image_id=None, is_auto_tune_enabled=None, is_hydrated=None, kms_key_id=None, size_in_gbs=None, size_in_mbs=None, source_details=None, state=None, system_tags=None, time_created=None, volume_group_id=None, vpus_per_gb=None, xrc_kms_key_id=None):
        if auto_tuned_vpus_per_gb and not isinstance(auto_tuned_vpus_per_gb, str):
            raise TypeError("Expected argument 'auto_tuned_vpus_per_gb' to be a str")
        pulumi.set(__self__, "auto_tuned_vpus_per_gb", auto_tuned_vpus_per_gb)
        if autotune_policies and not isinstance(autotune_policies, list):
            raise TypeError("Expected argument 'autotune_policies' to be a list")
        pulumi.set(__self__, "autotune_policies", autotune_policies)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_policy_id and not isinstance(backup_policy_id, str):
            raise TypeError("Expected argument 'backup_policy_id' to be a str")
        pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if boot_volume_id and not isinstance(boot_volume_id, str):
            raise TypeError("Expected argument 'boot_volume_id' to be a str")
        pulumi.set(__self__, "boot_volume_id", boot_volume_id)
        if boot_volume_replicas and not isinstance(boot_volume_replicas, list):
            raise TypeError("Expected argument 'boot_volume_replicas' to be a list")
        pulumi.set(__self__, "boot_volume_replicas", boot_volume_replicas)
        if boot_volume_replicas_deletion and not isinstance(boot_volume_replicas_deletion, bool):
            raise TypeError("Expected argument 'boot_volume_replicas_deletion' to be a bool")
        pulumi.set(__self__, "boot_volume_replicas_deletion", boot_volume_replicas_deletion)
        if cluster_placement_group_id and not isinstance(cluster_placement_group_id, str):
            raise TypeError("Expected argument 'cluster_placement_group_id' to be a str")
        pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if is_auto_tune_enabled and not isinstance(is_auto_tune_enabled, bool):
            raise TypeError("Expected argument 'is_auto_tune_enabled' to be a bool")
        pulumi.set(__self__, "is_auto_tune_enabled", is_auto_tune_enabled)
        if is_hydrated and not isinstance(is_hydrated, bool):
            raise TypeError("Expected argument 'is_hydrated' to be a bool")
        pulumi.set(__self__, "is_hydrated", is_hydrated)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if size_in_gbs and not isinstance(size_in_gbs, str):
            raise TypeError("Expected argument 'size_in_gbs' to be a str")
        pulumi.set(__self__, "size_in_gbs", size_in_gbs)
        if size_in_mbs and not isinstance(size_in_mbs, str):
            raise TypeError("Expected argument 'size_in_mbs' to be a str")
        pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        if source_details and not isinstance(source_details, list):
            raise TypeError("Expected argument 'source_details' to be a list")
        pulumi.set(__self__, "source_details", source_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if volume_group_id and not isinstance(volume_group_id, str):
            raise TypeError("Expected argument 'volume_group_id' to be a str")
        pulumi.set(__self__, "volume_group_id", volume_group_id)
        if vpus_per_gb and not isinstance(vpus_per_gb, str):
            raise TypeError("Expected argument 'vpus_per_gb' to be a str")
        pulumi.set(__self__, "vpus_per_gb", vpus_per_gb)
        if xrc_kms_key_id and not isinstance(xrc_kms_key_id, str):
            raise TypeError("Expected argument 'xrc_kms_key_id' to be a str")
        pulumi.set(__self__, "xrc_kms_key_id", xrc_kms_key_id)

    @_builtins.property
    @pulumi.getter(name="autoTunedVpusPerGb")
    def auto_tuned_vpus_per_gb(self) -> _builtins.str:
        """
        The number of Volume Performance Units per GB that this boot volume is effectively tuned to.
        """
        return pulumi.get(self, "auto_tuned_vpus_per_gb")

    @_builtins.property
    @pulumi.getter(name="autotunePolicies")
    def autotune_policies(self) -> Sequence['outputs.GetBootVolumeAutotunePolicyResult']:
        """
        The list of autotune policies enabled for this volume.
        """
        return pulumi.get(self, "autotune_policies")

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The availability domain of the boot volume replica.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    @_utilities.deprecated("""The 'backup_policy_id' field has been deprecated. Please use the 'oci_core_volume_backup_policy_assignment' resource instead.""")
    def backup_policy_id(self) -> _builtins.str:
        return pulumi.get(self, "backup_policy_id")

    @_builtins.property
    @pulumi.getter(name="bootVolumeId")
    def boot_volume_id(self) -> _builtins.str:
        return pulumi.get(self, "boot_volume_id")

    @_builtins.property
    @pulumi.getter(name="bootVolumeReplicas")
    def boot_volume_replicas(self) -> Sequence['outputs.GetBootVolumeBootVolumeReplicaResult']:
        """
        The list of boot volume replicas of this boot volume
        """
        return pulumi.get(self, "boot_volume_replicas")

    @_builtins.property
    @pulumi.getter(name="bootVolumeReplicasDeletion")
    def boot_volume_replicas_deletion(self) -> _builtins.bool:
        return pulumi.get(self, "boot_volume_replicas_deletion")

    @_builtins.property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> _builtins.str:
        """
        The clusterPlacementGroup Id of the volume for volume placement.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the boot volume.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (Required when type=bootVolume | bootVolumeBackup | bootVolumeReplica) The OCID of the boot volume replica.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The image OCID used to create the boot volume.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="isAutoTuneEnabled")
    def is_auto_tune_enabled(self) -> _builtins.bool:
        """
        Specifies whether the auto-tune performance is enabled for this boot volume. This field is deprecated. Use the `DetachedVolumeAutotunePolicy` instead to enable the volume for detached autotune.
        """
        return pulumi.get(self, "is_auto_tune_enabled")

    @_builtins.property
    @pulumi.getter(name="isHydrated")
    def is_hydrated(self) -> _builtins.bool:
        """
        Specifies whether the boot volume's data has finished copying from the source boot volume or boot volume backup.
        """
        return pulumi.get(self, "is_hydrated")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        The OCID of the Vault service master encryption key assigned to the boot volume.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> _builtins.str:
        """
        The size of the boot volume in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> _builtins.str:
        """
        The size of the volume in MBs. The value must be a multiple of 1024. This field is deprecated. Please use `size_in_gbs`.
        """
        return pulumi.get(self, "size_in_mbs")

    @_builtins.property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Sequence['outputs.GetBootVolumeSourceDetailResult']:
        return pulumi.get(self, "source_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of a boot volume.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the boot volume was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> _builtins.str:
        """
        The OCID of the source volume group.
        """
        return pulumi.get(self, "volume_group_id")

    @_builtins.property
    @pulumi.getter(name="vpusPerGb")
    def vpus_per_gb(self) -> _builtins.str:
        """
        The number of volume performance units (VPUs) that will be applied to this boot volume per GB, representing the Block Volume service's elastic performance options. See [Block Volume Performance Levels](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm#perf_levels) for more information.
        """
        return pulumi.get(self, "vpus_per_gb")

    @_builtins.property
    @pulumi.getter(name="xrcKmsKeyId")
    def xrc_kms_key_id(self) -> _builtins.str:
        return pulumi.get(self, "xrc_kms_key_id")


class AwaitableGetBootVolumeResult(GetBootVolumeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBootVolumeResult(
            auto_tuned_vpus_per_gb=self.auto_tuned_vpus_per_gb,
            autotune_policies=self.autotune_policies,
            availability_domain=self.availability_domain,
            backup_policy_id=self.backup_policy_id,
            boot_volume_id=self.boot_volume_id,
            boot_volume_replicas=self.boot_volume_replicas,
            boot_volume_replicas_deletion=self.boot_volume_replicas_deletion,
            cluster_placement_group_id=self.cluster_placement_group_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            image_id=self.image_id,
            is_auto_tune_enabled=self.is_auto_tune_enabled,
            is_hydrated=self.is_hydrated,
            kms_key_id=self.kms_key_id,
            size_in_gbs=self.size_in_gbs,
            size_in_mbs=self.size_in_mbs,
            source_details=self.source_details,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            volume_group_id=self.volume_group_id,
            vpus_per_gb=self.vpus_per_gb,
            xrc_kms_key_id=self.xrc_kms_key_id)


def get_boot_volume(boot_volume_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBootVolumeResult:
    """
    This data source provides details about a specific Boot Volume resource in Oracle Cloud Infrastructure Core service.

    Gets information for the specified boot volume.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_boot_volume = oci.Core.get_boot_volume(boot_volume_id=test_boot_volume_oci_core_boot_volume["id"])
    ```


    :param _builtins.str boot_volume_id: The OCID of the boot volume.
    """
    __args__ = dict()
    __args__['bootVolumeId'] = boot_volume_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getBootVolume:getBootVolume', __args__, opts=opts, typ=GetBootVolumeResult).value

    return AwaitableGetBootVolumeResult(
        auto_tuned_vpus_per_gb=pulumi.get(__ret__, 'auto_tuned_vpus_per_gb'),
        autotune_policies=pulumi.get(__ret__, 'autotune_policies'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        backup_policy_id=pulumi.get(__ret__, 'backup_policy_id'),
        boot_volume_id=pulumi.get(__ret__, 'boot_volume_id'),
        boot_volume_replicas=pulumi.get(__ret__, 'boot_volume_replicas'),
        boot_volume_replicas_deletion=pulumi.get(__ret__, 'boot_volume_replicas_deletion'),
        cluster_placement_group_id=pulumi.get(__ret__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        is_auto_tune_enabled=pulumi.get(__ret__, 'is_auto_tune_enabled'),
        is_hydrated=pulumi.get(__ret__, 'is_hydrated'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        size_in_gbs=pulumi.get(__ret__, 'size_in_gbs'),
        size_in_mbs=pulumi.get(__ret__, 'size_in_mbs'),
        source_details=pulumi.get(__ret__, 'source_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        volume_group_id=pulumi.get(__ret__, 'volume_group_id'),
        vpus_per_gb=pulumi.get(__ret__, 'vpus_per_gb'),
        xrc_kms_key_id=pulumi.get(__ret__, 'xrc_kms_key_id'))
def get_boot_volume_output(boot_volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBootVolumeResult]:
    """
    This data source provides details about a specific Boot Volume resource in Oracle Cloud Infrastructure Core service.

    Gets information for the specified boot volume.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_boot_volume = oci.Core.get_boot_volume(boot_volume_id=test_boot_volume_oci_core_boot_volume["id"])
    ```


    :param _builtins.str boot_volume_id: The OCID of the boot volume.
    """
    __args__ = dict()
    __args__['bootVolumeId'] = boot_volume_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getBootVolume:getBootVolume', __args__, opts=opts, typ=GetBootVolumeResult)
    return __ret__.apply(lambda __response__: GetBootVolumeResult(
        auto_tuned_vpus_per_gb=pulumi.get(__response__, 'auto_tuned_vpus_per_gb'),
        autotune_policies=pulumi.get(__response__, 'autotune_policies'),
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        backup_policy_id=pulumi.get(__response__, 'backup_policy_id'),
        boot_volume_id=pulumi.get(__response__, 'boot_volume_id'),
        boot_volume_replicas=pulumi.get(__response__, 'boot_volume_replicas'),
        boot_volume_replicas_deletion=pulumi.get(__response__, 'boot_volume_replicas_deletion'),
        cluster_placement_group_id=pulumi.get(__response__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        is_auto_tune_enabled=pulumi.get(__response__, 'is_auto_tune_enabled'),
        is_hydrated=pulumi.get(__response__, 'is_hydrated'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        size_in_gbs=pulumi.get(__response__, 'size_in_gbs'),
        size_in_mbs=pulumi.get(__response__, 'size_in_mbs'),
        source_details=pulumi.get(__response__, 'source_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        volume_group_id=pulumi.get(__response__, 'volume_group_id'),
        vpus_per_gb=pulumi.get(__response__, 'vpus_per_gb'),
        xrc_kms_key_id=pulumi.get(__response__, 'xrc_kms_key_id')))
