# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVolumeBackupsResult',
    'AwaitableGetVolumeBackupsResult',
    'get_volume_backups',
    'get_volume_backups_output',
]

@pulumi.output_type
class GetVolumeBackupsResult:
    """
    A collection of values returned by getVolumeBackups.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, source_volume_backup_id=None, state=None, volume_backups=None, volume_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if source_volume_backup_id and not isinstance(source_volume_backup_id, str):
            raise TypeError("Expected argument 'source_volume_backup_id' to be a str")
        pulumi.set(__self__, "source_volume_backup_id", source_volume_backup_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if volume_backups and not isinstance(volume_backups, list):
            raise TypeError("Expected argument 'volume_backups' to be a list")
        pulumi.set(__self__, "volume_backups", volume_backups)
        if volume_id and not isinstance(volume_id, str):
            raise TypeError("Expected argument 'volume_id' to be a str")
        pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains the volume backup.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVolumeBackupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="sourceVolumeBackupId")
    def source_volume_backup_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the source volume backup.
        """
        return pulumi.get(self, "source_volume_backup_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of a volume backup.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="volumeBackups")
    def volume_backups(self) -> Sequence['outputs.GetVolumeBackupsVolumeBackupResult']:
        """
        The list of volume_backups.
        """
        return pulumi.get(self, "volume_backups")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the volume.
        """
        return pulumi.get(self, "volume_id")


class AwaitableGetVolumeBackupsResult(GetVolumeBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeBackupsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            source_volume_backup_id=self.source_volume_backup_id,
            state=self.state,
            volume_backups=self.volume_backups,
            volume_id=self.volume_id)


def get_volume_backups(compartment_id: Optional[_builtins.str] = None,
                       display_name: Optional[_builtins.str] = None,
                       filters: Optional[Sequence[Union['GetVolumeBackupsFilterArgs', 'GetVolumeBackupsFilterArgsDict']]] = None,
                       source_volume_backup_id: Optional[_builtins.str] = None,
                       state: Optional[_builtins.str] = None,
                       volume_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeBackupsResult:
    """
    This data source provides the list of Volume Backups in Oracle Cloud Infrastructure Core service.

    Lists the volume backups in the specified compartment. You can filter the results by volume.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_backups = oci.Core.get_volume_backups(compartment_id=compartment_id,
        display_name=volume_backup_display_name,
        source_volume_backup_id=test_volume_backup["id"],
        state=volume_backup_state,
        volume_id=test_volume["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str source_volume_backup_id: A filter to return only resources that originated from the given source volume backup.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    :param _builtins.str volume_id: The OCID of the volume.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sourceVolumeBackupId'] = source_volume_backup_id
    __args__['state'] = state
    __args__['volumeId'] = volume_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getVolumeBackups:getVolumeBackups', __args__, opts=opts, typ=GetVolumeBackupsResult).value

    return AwaitableGetVolumeBackupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        source_volume_backup_id=pulumi.get(__ret__, 'source_volume_backup_id'),
        state=pulumi.get(__ret__, 'state'),
        volume_backups=pulumi.get(__ret__, 'volume_backups'),
        volume_id=pulumi.get(__ret__, 'volume_id'))
def get_volume_backups_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                              display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVolumeBackupsFilterArgs', 'GetVolumeBackupsFilterArgsDict']]]]] = None,
                              source_volume_backup_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              volume_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeBackupsResult]:
    """
    This data source provides the list of Volume Backups in Oracle Cloud Infrastructure Core service.

    Lists the volume backups in the specified compartment. You can filter the results by volume.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_volume_backups = oci.Core.get_volume_backups(compartment_id=compartment_id,
        display_name=volume_backup_display_name,
        source_volume_backup_id=test_volume_backup["id"],
        state=volume_backup_state,
        volume_id=test_volume["id"])
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str source_volume_backup_id: A filter to return only resources that originated from the given source volume backup.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    :param _builtins.str volume_id: The OCID of the volume.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sourceVolumeBackupId'] = source_volume_backup_id
    __args__['state'] = state
    __args__['volumeId'] = volume_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getVolumeBackups:getVolumeBackups', __args__, opts=opts, typ=GetVolumeBackupsResult)
    return __ret__.apply(lambda __response__: GetVolumeBackupsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        source_volume_backup_id=pulumi.get(__response__, 'source_volume_backup_id'),
        state=pulumi.get(__response__, 'state'),
        volume_backups=pulumi.get(__response__, 'volume_backups'),
        volume_id=pulumi.get(__response__, 'volume_id')))
