# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PluggableDatabaseManagementsManagementArgs', 'PluggableDatabaseManagementsManagement']

@pulumi.input_type
class PluggableDatabaseManagementsManagementArgs:
    def __init__(__self__, *,
                 credential_details: pulumi.Input['PluggableDatabaseManagementsManagementCredentialDetailsArgs'],
                 enable_pluggabledatabasemanagement: pulumi.Input[_builtins.bool],
                 pluggable_database_id: pulumi.Input[_builtins.str],
                 private_end_point_id: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_secret_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PluggableDatabaseManagementsManagement resource.
        :param pulumi.Input['PluggableDatabaseManagementsManagementCredentialDetailsArgs'] credential_details: Data for the credential used to connect to the database.
        :param pulumi.Input[_builtins.bool] enable_pluggabledatabasemanagement: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] pluggable_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] private_end_point_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        :param pulumi.Input[_builtins.str] service_name: The name of the Oracle Database service that will be used to connect to the database.
        :param pulumi.Input[_builtins.int] port: The port used to connect to the pluggable database.
        :param pulumi.Input[_builtins.str] protocol: Protocol used by the database connection.
        :param pulumi.Input[_builtins.str] role: The role of the user that will be connecting to the pluggable database.
        :param pulumi.Input[_builtins.str] ssl_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        pulumi.set(__self__, "credential_details", credential_details)
        pulumi.set(__self__, "enable_pluggabledatabasemanagement", enable_pluggabledatabasemanagement)
        pulumi.set(__self__, "pluggable_database_id", pluggable_database_id)
        pulumi.set(__self__, "private_end_point_id", private_end_point_id)
        pulumi.set(__self__, "service_name", service_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if ssl_secret_id is not None:
            pulumi.set(__self__, "ssl_secret_id", ssl_secret_id)

    @_builtins.property
    @pulumi.getter(name="credentialDetails")
    def credential_details(self) -> pulumi.Input['PluggableDatabaseManagementsManagementCredentialDetailsArgs']:
        """
        Data for the credential used to connect to the database.
        """
        return pulumi.get(self, "credential_details")

    @credential_details.setter
    def credential_details(self, value: pulumi.Input['PluggableDatabaseManagementsManagementCredentialDetailsArgs']):
        pulumi.set(self, "credential_details", value)

    @_builtins.property
    @pulumi.getter(name="enablePluggabledatabasemanagement")
    def enable_pluggabledatabasemanagement(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_pluggabledatabasemanagement")

    @enable_pluggabledatabasemanagement.setter
    def enable_pluggabledatabasemanagement(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable_pluggabledatabasemanagement", value)

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseId")
    def pluggable_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "pluggable_database_id")

    @pluggable_database_id.setter
    def pluggable_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pluggable_database_id", value)

    @_builtins.property
    @pulumi.getter(name="privateEndPointId")
    def private_end_point_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        """
        return pulumi.get(self, "private_end_point_id")

    @private_end_point_id.setter
    def private_end_point_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_end_point_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Oracle Database service that will be used to connect to the database.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port used to connect to the pluggable database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol used by the database connection.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of the user that will be connecting to the pluggable database.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "ssl_secret_id")

    @ssl_secret_id.setter
    def ssl_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_secret_id", value)


@pulumi.input_type
class _PluggableDatabaseManagementsManagementState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabaseManagementsManagementConnectionStringArgs']]]] = None,
                 container_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_details: Optional[pulumi.Input['PluggableDatabaseManagementsManagementCredentialDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_pluggabledatabasemanagement: Optional[pulumi.Input[_builtins.bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 open_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 pdb_name: Optional[pulumi.Input[_builtins.str]] = None,
                 pluggable_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pluggable_database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabaseManagementsManagementPluggableDatabaseManagementConfigArgs']]]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_end_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PluggableDatabaseManagementsManagement resources.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input['PluggableDatabaseManagementsManagementConnectionStringArgs']]] connection_strings: Connection strings to connect to an Oracle Pluggable Database.
        :param pulumi.Input[_builtins.str] container_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CDB.
        :param pulumi.Input['PluggableDatabaseManagementsManagementCredentialDetailsArgs'] credential_details: Data for the credential used to connect to the database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.bool] enable_pluggabledatabasemanagement: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_restricted: The restricted mode of the pluggable database. If a pluggable database is opened in restricted mode, the user needs both create a session and have restricted session privileges to connect to it.
        :param pulumi.Input[_builtins.str] lifecycle_details: Detailed message for the lifecycle state.
        :param pulumi.Input[_builtins.str] open_mode: The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).
        :param pulumi.Input[_builtins.str] pdb_name: The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        :param pulumi.Input[_builtins.str] pluggable_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input['PluggableDatabaseManagementsManagementPluggableDatabaseManagementConfigArgs']]] pluggable_database_management_configs: The configuration of the Pluggable Database Management service.
        :param pulumi.Input[_builtins.int] port: The port used to connect to the pluggable database.
        :param pulumi.Input[_builtins.str] private_end_point_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        :param pulumi.Input[_builtins.str] protocol: Protocol used by the database connection.
        :param pulumi.Input[_builtins.str] role: The role of the user that will be connecting to the pluggable database.
        :param pulumi.Input[_builtins.str] service_name: The name of the Oracle Database service that will be used to connect to the database.
        :param pulumi.Input[_builtins.str] ssl_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        :param pulumi.Input[_builtins.str] state: The current state of the pluggable database.
        :param pulumi.Input[_builtins.str] time_created: The date and time the pluggable database was created.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if container_database_id is not None:
            pulumi.set(__self__, "container_database_id", container_database_id)
        if credential_details is not None:
            pulumi.set(__self__, "credential_details", credential_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if enable_pluggabledatabasemanagement is not None:
            pulumi.set(__self__, "enable_pluggabledatabasemanagement", enable_pluggabledatabasemanagement)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_restricted is not None:
            pulumi.set(__self__, "is_restricted", is_restricted)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if open_mode is not None:
            pulumi.set(__self__, "open_mode", open_mode)
        if pdb_name is not None:
            pulumi.set(__self__, "pdb_name", pdb_name)
        if pluggable_database_id is not None:
            pulumi.set(__self__, "pluggable_database_id", pluggable_database_id)
        if pluggable_database_management_configs is not None:
            pulumi.set(__self__, "pluggable_database_management_configs", pluggable_database_management_configs)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_end_point_id is not None:
            pulumi.set(__self__, "private_end_point_id", private_end_point_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if ssl_secret_id is not None:
            pulumi.set(__self__, "ssl_secret_id", ssl_secret_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabaseManagementsManagementConnectionStringArgs']]]]:
        """
        Connection strings to connect to an Oracle Pluggable Database.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabaseManagementsManagementConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @_builtins.property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CDB.
        """
        return pulumi.get(self, "container_database_id")

    @container_database_id.setter
    def container_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_database_id", value)

    @_builtins.property
    @pulumi.getter(name="credentialDetails")
    def credential_details(self) -> Optional[pulumi.Input['PluggableDatabaseManagementsManagementCredentialDetailsArgs']]:
        """
        Data for the credential used to connect to the database.
        """
        return pulumi.get(self, "credential_details")

    @credential_details.setter
    def credential_details(self, value: Optional[pulumi.Input['PluggableDatabaseManagementsManagementCredentialDetailsArgs']]):
        pulumi.set(self, "credential_details", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="enablePluggabledatabasemanagement")
    def enable_pluggabledatabasemanagement(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_pluggabledatabasemanagement")

    @enable_pluggabledatabasemanagement.setter
    def enable_pluggabledatabasemanagement(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_pluggabledatabasemanagement", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isRestricted")
    def is_restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The restricted mode of the pluggable database. If a pluggable database is opened in restricted mode, the user needs both create a session and have restricted session privileges to connect to it.
        """
        return pulumi.get(self, "is_restricted")

    @is_restricted.setter
    def is_restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_restricted", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="openMode")
    def open_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).
        """
        return pulumi.get(self, "open_mode")

    @open_mode.setter
    def open_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "open_mode", value)

    @_builtins.property
    @pulumi.getter(name="pdbName")
    def pdb_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        """
        return pulumi.get(self, "pdb_name")

    @pdb_name.setter
    def pdb_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pdb_name", value)

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseId")
    def pluggable_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "pluggable_database_id")

    @pluggable_database_id.setter
    def pluggable_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pluggable_database_id", value)

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseManagementConfigs")
    def pluggable_database_management_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabaseManagementsManagementPluggableDatabaseManagementConfigArgs']]]]:
        """
        The configuration of the Pluggable Database Management service.
        """
        return pulumi.get(self, "pluggable_database_management_configs")

    @pluggable_database_management_configs.setter
    def pluggable_database_management_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabaseManagementsManagementPluggableDatabaseManagementConfigArgs']]]]):
        pulumi.set(self, "pluggable_database_management_configs", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port used to connect to the pluggable database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateEndPointId")
    def private_end_point_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        """
        return pulumi.get(self, "private_end_point_id")

    @private_end_point_id.setter
    def private_end_point_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_end_point_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol used by the database connection.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role of the user that will be connecting to the pluggable database.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Oracle Database service that will be used to connect to the database.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "ssl_secret_id")

    @ssl_secret_id.setter
    def ssl_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the pluggable database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the pluggable database was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:Database/pluggableDatabaseManagementsManagement:PluggableDatabaseManagementsManagement")
class PluggableDatabaseManagementsManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_details: Optional[pulumi.Input[Union['PluggableDatabaseManagementsManagementCredentialDetailsArgs', 'PluggableDatabaseManagementsManagementCredentialDetailsArgsDict']]] = None,
                 enable_pluggabledatabasemanagement: Optional[pulumi.Input[_builtins.bool]] = None,
                 pluggable_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_end_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Pluggable Database Pluggabledatabasemanagements Management resource in Oracle Cloud Infrastructure Database service.

        Enables the Database Management service for an Oracle Pluggable Database located in Oracle Cloud Infrastructure. This service allows the pluggable database to access tools including Metrics and Performance hub. Database Management is enabled at the pluggable database (PDB) level.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_pluggable_database_pluggabledatabasemanagements_management = oci.database.PluggableDatabaseManagementsManagement("test_pluggable_database_pluggabledatabasemanagements_management",
            pluggable_database_id=test_pluggable_database["id"],
            enable_pluggabledatabasemanagement=enable_pluggabledatabasemanagement,
            credential_details={
                "password_secret_id": test_secret["id"],
                "user_name": test_user["name"],
            },
            private_end_point_id=test_private_end_point["id"],
            service_name=test_service["name"],
            port=pluggable_database_pluggabledatabasemanagements_management_port,
            protocol=pluggable_database_pluggabledatabasemanagements_management_protocol,
            role=pluggable_database_pluggabledatabasemanagements_management_role,
            ssl_secret_id=test_secret["id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PluggableDatabaseManagementsManagementCredentialDetailsArgs', 'PluggableDatabaseManagementsManagementCredentialDetailsArgsDict']] credential_details: Data for the credential used to connect to the database.
        :param pulumi.Input[_builtins.bool] enable_pluggabledatabasemanagement: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] pluggable_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.int] port: The port used to connect to the pluggable database.
        :param pulumi.Input[_builtins.str] private_end_point_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        :param pulumi.Input[_builtins.str] protocol: Protocol used by the database connection.
        :param pulumi.Input[_builtins.str] role: The role of the user that will be connecting to the pluggable database.
        :param pulumi.Input[_builtins.str] service_name: The name of the Oracle Database service that will be used to connect to the database.
        :param pulumi.Input[_builtins.str] ssl_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PluggableDatabaseManagementsManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Pluggable Database Pluggabledatabasemanagements Management resource in Oracle Cloud Infrastructure Database service.

        Enables the Database Management service for an Oracle Pluggable Database located in Oracle Cloud Infrastructure. This service allows the pluggable database to access tools including Metrics and Performance hub. Database Management is enabled at the pluggable database (PDB) level.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_pluggable_database_pluggabledatabasemanagements_management = oci.database.PluggableDatabaseManagementsManagement("test_pluggable_database_pluggabledatabasemanagements_management",
            pluggable_database_id=test_pluggable_database["id"],
            enable_pluggabledatabasemanagement=enable_pluggabledatabasemanagement,
            credential_details={
                "password_secret_id": test_secret["id"],
                "user_name": test_user["name"],
            },
            private_end_point_id=test_private_end_point["id"],
            service_name=test_service["name"],
            port=pluggable_database_pluggabledatabasemanagements_management_port,
            protocol=pluggable_database_pluggabledatabasemanagements_management_protocol,
            role=pluggable_database_pluggabledatabasemanagements_management_role,
            ssl_secret_id=test_secret["id"])
        ```

        :param str resource_name: The name of the resource.
        :param PluggableDatabaseManagementsManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluggableDatabaseManagementsManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_details: Optional[pulumi.Input[Union['PluggableDatabaseManagementsManagementCredentialDetailsArgs', 'PluggableDatabaseManagementsManagementCredentialDetailsArgsDict']]] = None,
                 enable_pluggabledatabasemanagement: Optional[pulumi.Input[_builtins.bool]] = None,
                 pluggable_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_end_point_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluggableDatabaseManagementsManagementArgs.__new__(PluggableDatabaseManagementsManagementArgs)

            if credential_details is None and not opts.urn:
                raise TypeError("Missing required property 'credential_details'")
            __props__.__dict__["credential_details"] = credential_details
            if enable_pluggabledatabasemanagement is None and not opts.urn:
                raise TypeError("Missing required property 'enable_pluggabledatabasemanagement'")
            __props__.__dict__["enable_pluggabledatabasemanagement"] = enable_pluggabledatabasemanagement
            if pluggable_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'pluggable_database_id'")
            __props__.__dict__["pluggable_database_id"] = pluggable_database_id
            __props__.__dict__["port"] = port
            if private_end_point_id is None and not opts.urn:
                raise TypeError("Missing required property 'private_end_point_id'")
            __props__.__dict__["private_end_point_id"] = private_end_point_id
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["role"] = role
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["ssl_secret_id"] = ssl_secret_id
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["connection_strings"] = None
            __props__.__dict__["container_database_id"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["is_restricted"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["open_mode"] = None
            __props__.__dict__["pdb_name"] = None
            __props__.__dict__["pluggable_database_management_configs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(PluggableDatabaseManagementsManagement, __self__).__init__(
            'oci:Database/pluggableDatabaseManagementsManagement:PluggableDatabaseManagementsManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabaseManagementsManagementConnectionStringArgs', 'PluggableDatabaseManagementsManagementConnectionStringArgsDict']]]]] = None,
            container_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            credential_details: Optional[pulumi.Input[Union['PluggableDatabaseManagementsManagementCredentialDetailsArgs', 'PluggableDatabaseManagementsManagementCredentialDetailsArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            enable_pluggabledatabasemanagement: Optional[pulumi.Input[_builtins.bool]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            open_mode: Optional[pulumi.Input[_builtins.str]] = None,
            pdb_name: Optional[pulumi.Input[_builtins.str]] = None,
            pluggable_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            pluggable_database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabaseManagementsManagementPluggableDatabaseManagementConfigArgs', 'PluggableDatabaseManagementsManagementPluggableDatabaseManagementConfigArgsDict']]]]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            private_end_point_id: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None) -> 'PluggableDatabaseManagementsManagement':
        """
        Get an existing PluggableDatabaseManagementsManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabaseManagementsManagementConnectionStringArgs', 'PluggableDatabaseManagementsManagementConnectionStringArgsDict']]]] connection_strings: Connection strings to connect to an Oracle Pluggable Database.
        :param pulumi.Input[_builtins.str] container_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CDB.
        :param pulumi.Input[Union['PluggableDatabaseManagementsManagementCredentialDetailsArgs', 'PluggableDatabaseManagementsManagementCredentialDetailsArgsDict']] credential_details: Data for the credential used to connect to the database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[_builtins.bool] enable_pluggabledatabasemanagement: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_restricted: The restricted mode of the pluggable database. If a pluggable database is opened in restricted mode, the user needs both create a session and have restricted session privileges to connect to it.
        :param pulumi.Input[_builtins.str] lifecycle_details: Detailed message for the lifecycle state.
        :param pulumi.Input[_builtins.str] open_mode: The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).
        :param pulumi.Input[_builtins.str] pdb_name: The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        :param pulumi.Input[_builtins.str] pluggable_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabaseManagementsManagementPluggableDatabaseManagementConfigArgs', 'PluggableDatabaseManagementsManagementPluggableDatabaseManagementConfigArgsDict']]]] pluggable_database_management_configs: The configuration of the Pluggable Database Management service.
        :param pulumi.Input[_builtins.int] port: The port used to connect to the pluggable database.
        :param pulumi.Input[_builtins.str] private_end_point_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        :param pulumi.Input[_builtins.str] protocol: Protocol used by the database connection.
        :param pulumi.Input[_builtins.str] role: The role of the user that will be connecting to the pluggable database.
        :param pulumi.Input[_builtins.str] service_name: The name of the Oracle Database service that will be used to connect to the database.
        :param pulumi.Input[_builtins.str] ssl_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        :param pulumi.Input[_builtins.str] state: The current state of the pluggable database.
        :param pulumi.Input[_builtins.str] time_created: The date and time the pluggable database was created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PluggableDatabaseManagementsManagementState.__new__(_PluggableDatabaseManagementsManagementState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["container_database_id"] = container_database_id
        __props__.__dict__["credential_details"] = credential_details
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["enable_pluggabledatabasemanagement"] = enable_pluggabledatabasemanagement
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_restricted"] = is_restricted
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["open_mode"] = open_mode
        __props__.__dict__["pdb_name"] = pdb_name
        __props__.__dict__["pluggable_database_id"] = pluggable_database_id
        __props__.__dict__["pluggable_database_management_configs"] = pluggable_database_management_configs
        __props__.__dict__["port"] = port
        __props__.__dict__["private_end_point_id"] = private_end_point_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["role"] = role
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["ssl_secret_id"] = ssl_secret_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return PluggableDatabaseManagementsManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Sequence['outputs.PluggableDatabaseManagementsManagementConnectionString']]:
        """
        Connection strings to connect to an Oracle Pluggable Database.
        """
        return pulumi.get(self, "connection_strings")

    @_builtins.property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CDB.
        """
        return pulumi.get(self, "container_database_id")

    @_builtins.property
    @pulumi.getter(name="credentialDetails")
    def credential_details(self) -> pulumi.Output['outputs.PluggableDatabaseManagementsManagementCredentialDetails']:
        """
        Data for the credential used to connect to the database.
        """
        return pulumi.get(self, "credential_details")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="enablePluggabledatabasemanagement")
    def enable_pluggabledatabasemanagement(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_pluggabledatabasemanagement")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isRestricted")
    def is_restricted(self) -> pulumi.Output[_builtins.bool]:
        """
        The restricted mode of the pluggable database. If a pluggable database is opened in restricted mode, the user needs both create a session and have restricted session privileges to connect to it.
        """
        return pulumi.get(self, "is_restricted")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="openMode")
    def open_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).
        """
        return pulumi.get(self, "open_mode")

    @_builtins.property
    @pulumi.getter(name="pdbName")
    def pdb_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        """
        return pulumi.get(self, "pdb_name")

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseId")
    def pluggable_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "pluggable_database_id")

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseManagementConfigs")
    def pluggable_database_management_configs(self) -> pulumi.Output[Sequence['outputs.PluggableDatabaseManagementsManagementPluggableDatabaseManagementConfig']]:
        """
        The configuration of the Pluggable Database Management service.
        """
        return pulumi.get(self, "pluggable_database_management_configs")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The port used to connect to the pluggable database.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="privateEndPointId")
    def private_end_point_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint.
        """
        return pulumi.get(self, "private_end_point_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Protocol used by the database connection.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The role of the user that will be connecting to the pluggable database.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Oracle Database service that will be used to connect to the database.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [secret](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "ssl_secret_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the pluggable database.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the pluggable database was created.
        """
        return pulumi.get(self, "time_created")

