# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudAsmResult',
    'AwaitableGetCloudAsmResult',
    'get_cloud_asm',
    'get_cloud_asm_output',
]

@pulumi.output_type
class GetCloudAsmResult:
    """
    A collection of values returned by getCloudAsm.
    """
    def __init__(__self__, additional_details=None, cloud_asm_id=None, cloud_connector_id=None, cloud_db_system_id=None, compartment_id=None, component_name=None, dbaas_id=None, defined_tags=None, display_name=None, freeform_tags=None, grid_home=None, id=None, is_cluster=None, is_flex_enabled=None, lifecycle_details=None, serviced_databases=None, state=None, system_tags=None, time_created=None, time_updated=None, version=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if cloud_asm_id and not isinstance(cloud_asm_id, str):
            raise TypeError("Expected argument 'cloud_asm_id' to be a str")
        pulumi.set(__self__, "cloud_asm_id", cloud_asm_id)
        if cloud_connector_id and not isinstance(cloud_connector_id, str):
            raise TypeError("Expected argument 'cloud_connector_id' to be a str")
        pulumi.set(__self__, "cloud_connector_id", cloud_connector_id)
        if cloud_db_system_id and not isinstance(cloud_db_system_id, str):
            raise TypeError("Expected argument 'cloud_db_system_id' to be a str")
        pulumi.set(__self__, "cloud_db_system_id", cloud_db_system_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if component_name and not isinstance(component_name, str):
            raise TypeError("Expected argument 'component_name' to be a str")
        pulumi.set(__self__, "component_name", component_name)
        if dbaas_id and not isinstance(dbaas_id, str):
            raise TypeError("Expected argument 'dbaas_id' to be a str")
        pulumi.set(__self__, "dbaas_id", dbaas_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if grid_home and not isinstance(grid_home, str):
            raise TypeError("Expected argument 'grid_home' to be a str")
        pulumi.set(__self__, "grid_home", grid_home)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_cluster and not isinstance(is_cluster, bool):
            raise TypeError("Expected argument 'is_cluster' to be a bool")
        pulumi.set(__self__, "is_cluster", is_cluster)
        if is_flex_enabled and not isinstance(is_flex_enabled, bool):
            raise TypeError("Expected argument 'is_flex_enabled' to be a bool")
        pulumi.set(__self__, "is_flex_enabled", is_flex_enabled)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if serviced_databases and not isinstance(serviced_databases, list):
            raise TypeError("Expected argument 'serviced_databases' to be a list")
        pulumi.set(__self__, "serviced_databases", serviced_databases)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, _builtins.str]:
        """
        The additional details of the cloud ASM defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @_builtins.property
    @pulumi.getter(name="cloudAsmId")
    def cloud_asm_id(self) -> _builtins.str:
        return pulumi.get(self, "cloud_asm_id")

    @_builtins.property
    @pulumi.getter(name="cloudConnectorId")
    def cloud_connector_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud connector.
        """
        return pulumi.get(self, "cloud_connector_id")

    @_builtins.property
    @pulumi.getter(name="cloudDbSystemId")
    def cloud_db_system_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system that the ASM is a part of.
        """
        return pulumi.get(self, "cloud_db_system_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the cloud database resides.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="componentName")
    def component_name(self) -> _builtins.str:
        """
        The name of the cloud ASM.
        """
        return pulumi.get(self, "component_name")

    @_builtins.property
    @pulumi.getter(name="dbaasId")
    def dbaas_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the existing Dbaas Oracle Cloud Infrastructure resource matching the discovered DB system component.
        """
        return pulumi.get(self, "dbaas_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name for the database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="gridHome")
    def grid_home(self) -> _builtins.str:
        """
        The directory in which ASM is installed. This is the same directory in which Oracle Grid Infrastructure is installed.
        """
        return pulumi.get(self, "grid_home")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud database.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> _builtins.bool:
        """
        Indicates whether the ASM is a cluster ASM or not.
        """
        return pulumi.get(self, "is_cluster")

    @_builtins.property
    @pulumi.getter(name="isFlexEnabled")
    def is_flex_enabled(self) -> _builtins.bool:
        """
        Indicates whether Oracle Flex ASM is enabled or not.
        """
        return pulumi.get(self, "is_flex_enabled")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="servicedDatabases")
    def serviced_databases(self) -> Sequence['outputs.GetCloudAsmServicedDatabaseResult']:
        """
        The list of databases that are serviced by the ASM.
        """
        return pulumi.get(self, "serviced_databases")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the cloud ASM.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the cloud ASM was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the cloud ASM was last updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The ASM version.
        """
        return pulumi.get(self, "version")


class AwaitableGetCloudAsmResult(GetCloudAsmResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudAsmResult(
            additional_details=self.additional_details,
            cloud_asm_id=self.cloud_asm_id,
            cloud_connector_id=self.cloud_connector_id,
            cloud_db_system_id=self.cloud_db_system_id,
            compartment_id=self.compartment_id,
            component_name=self.component_name,
            dbaas_id=self.dbaas_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            grid_home=self.grid_home,
            id=self.id,
            is_cluster=self.is_cluster,
            is_flex_enabled=self.is_flex_enabled,
            lifecycle_details=self.lifecycle_details,
            serviced_databases=self.serviced_databases,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            version=self.version)


def get_cloud_asm(cloud_asm_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudAsmResult:
    """
    This data source provides details about a specific Cloud Asm resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the cloud ASM specified by `cloudAsmId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_asm = oci.DatabaseManagement.get_cloud_asm(cloud_asm_id=test_cloud_asm_oci_database_management_cloud_asm["id"])
    ```


    :param _builtins.str cloud_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud ASM.
    """
    __args__ = dict()
    __args__['cloudAsmId'] = cloud_asm_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getCloudAsm:getCloudAsm', __args__, opts=opts, typ=GetCloudAsmResult).value

    return AwaitableGetCloudAsmResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        cloud_asm_id=pulumi.get(__ret__, 'cloud_asm_id'),
        cloud_connector_id=pulumi.get(__ret__, 'cloud_connector_id'),
        cloud_db_system_id=pulumi.get(__ret__, 'cloud_db_system_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        component_name=pulumi.get(__ret__, 'component_name'),
        dbaas_id=pulumi.get(__ret__, 'dbaas_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        grid_home=pulumi.get(__ret__, 'grid_home'),
        id=pulumi.get(__ret__, 'id'),
        is_cluster=pulumi.get(__ret__, 'is_cluster'),
        is_flex_enabled=pulumi.get(__ret__, 'is_flex_enabled'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        serviced_databases=pulumi.get(__ret__, 'serviced_databases'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        version=pulumi.get(__ret__, 'version'))
def get_cloud_asm_output(cloud_asm_id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudAsmResult]:
    """
    This data source provides details about a specific Cloud Asm resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the cloud ASM specified by `cloudAsmId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_asm = oci.DatabaseManagement.get_cloud_asm(cloud_asm_id=test_cloud_asm_oci_database_management_cloud_asm["id"])
    ```


    :param _builtins.str cloud_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud ASM.
    """
    __args__ = dict()
    __args__['cloudAsmId'] = cloud_asm_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getCloudAsm:getCloudAsm', __args__, opts=opts, typ=GetCloudAsmResult)
    return __ret__.apply(lambda __response__: GetCloudAsmResult(
        additional_details=pulumi.get(__response__, 'additional_details'),
        cloud_asm_id=pulumi.get(__response__, 'cloud_asm_id'),
        cloud_connector_id=pulumi.get(__response__, 'cloud_connector_id'),
        cloud_db_system_id=pulumi.get(__response__, 'cloud_db_system_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        component_name=pulumi.get(__response__, 'component_name'),
        dbaas_id=pulumi.get(__response__, 'dbaas_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        grid_home=pulumi.get(__response__, 'grid_home'),
        id=pulumi.get(__response__, 'id'),
        is_cluster=pulumi.get(__response__, 'is_cluster'),
        is_flex_enabled=pulumi.get(__response__, 'is_flex_enabled'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        serviced_databases=pulumi.get(__response__, 'serviced_databases'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        version=pulumi.get(__response__, 'version')))
