# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCloudAsmsResult',
    'AwaitableGetCloudAsmsResult',
    'get_cloud_asms',
    'get_cloud_asms_output',
]

@pulumi.output_type
class GetCloudAsmsResult:
    """
    A collection of values returned by getCloudAsms.
    """
    def __init__(__self__, cloud_asm_collections=None, cloud_db_system_id=None, compartment_id=None, display_name=None, filters=None, id=None):
        if cloud_asm_collections and not isinstance(cloud_asm_collections, list):
            raise TypeError("Expected argument 'cloud_asm_collections' to be a list")
        pulumi.set(__self__, "cloud_asm_collections", cloud_asm_collections)
        if cloud_db_system_id and not isinstance(cloud_db_system_id, str):
            raise TypeError("Expected argument 'cloud_db_system_id' to be a str")
        pulumi.set(__self__, "cloud_db_system_id", cloud_db_system_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="cloudAsmCollections")
    def cloud_asm_collections(self) -> Sequence['outputs.GetCloudAsmsCloudAsmCollectionResult']:
        """
        The list of cloud_asm_collection.
        """
        return pulumi.get(self, "cloud_asm_collections")

    @_builtins.property
    @pulumi.getter(name="cloudDbSystemId")
    def cloud_db_system_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system that the ASM is a part of.
        """
        return pulumi.get(self, "cloud_db_system_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the cloud database resides.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCloudAsmsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetCloudAsmsResult(GetCloudAsmsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudAsmsResult(
            cloud_asm_collections=self.cloud_asm_collections,
            cloud_db_system_id=self.cloud_db_system_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id)


def get_cloud_asms(cloud_db_system_id: Optional[_builtins.str] = None,
                   compartment_id: Optional[_builtins.str] = None,
                   display_name: Optional[_builtins.str] = None,
                   filters: Optional[Sequence[Union['GetCloudAsmsFilterArgs', 'GetCloudAsmsFilterArgsDict']]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudAsmsResult:
    """
    This data source provides the list of Cloud Asms in Oracle Cloud Infrastructure Database Management service.

    Lists the ASMs in the specified cloud DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_asms = oci.DatabaseManagement.get_cloud_asms(cloud_db_system_id=test_cloud_db_system["id"],
        compartment_id=compartment_id,
        display_name=cloud_asm_display_name)
    ```


    :param _builtins.str cloud_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to only return the resources that match the entire display name.
    """
    __args__ = dict()
    __args__['cloudDbSystemId'] = cloud_db_system_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getCloudAsms:getCloudAsms', __args__, opts=opts, typ=GetCloudAsmsResult).value

    return AwaitableGetCloudAsmsResult(
        cloud_asm_collections=pulumi.get(__ret__, 'cloud_asm_collections'),
        cloud_db_system_id=pulumi.get(__ret__, 'cloud_db_system_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_cloud_asms_output(cloud_db_system_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCloudAsmsFilterArgs', 'GetCloudAsmsFilterArgsDict']]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudAsmsResult]:
    """
    This data source provides the list of Cloud Asms in Oracle Cloud Infrastructure Database Management service.

    Lists the ASMs in the specified cloud DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_asms = oci.DatabaseManagement.get_cloud_asms(cloud_db_system_id=test_cloud_db_system["id"],
        compartment_id=compartment_id,
        display_name=cloud_asm_display_name)
    ```


    :param _builtins.str cloud_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to only return the resources that match the entire display name.
    """
    __args__ = dict()
    __args__['cloudDbSystemId'] = cloud_db_system_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getCloudAsms:getCloudAsms', __args__, opts=opts, typ=GetCloudAsmsResult)
    return __ret__.apply(lambda __response__: GetCloudAsmsResult(
        cloud_asm_collections=pulumi.get(__response__, 'cloud_asm_collections'),
        cloud_db_system_id=pulumi.get(__response__, 'cloud_db_system_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
