# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceProjectArgs', 'WorkspaceProject']

@pulumi.input_type
class WorkspaceProjectArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_status: Optional[pulumi.Input[_builtins.int]] = None,
                 project_key: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceProjectRegistryMetadataArgs']] = None):
        """
        The set of arguments for constructing a WorkspaceProject resource.
        :param pulumi.Input[_builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] description: (Updatable) A user defined description for the project.
        :param pulumi.Input[_builtins.str] key: (Updatable) Generated key that can be used in API calls to identify project.
        :param pulumi.Input[_builtins.str] model_version: (Updatable) The model version of an object.
        :param pulumi.Input[_builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[_builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input['WorkspaceProjectRegistryMetadataArgs'] registry_metadata: (Updatable) Information about the object and its parent.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user defined description for the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Generated key that can be used in API calls to identify project.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The model version of an object.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_status", value)

    @_builtins.property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_key", value)

    @_builtins.property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceProjectRegistryMetadataArgs']]:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceProjectRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)


@pulumi.input_type
class _WorkspaceProjectState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 key_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceProjectMetadataArgs']]]] = None,
                 model_type: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_status: Optional[pulumi.Input[_builtins.int]] = None,
                 object_version: Optional[pulumi.Input[_builtins.int]] = None,
                 parent_reves: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceProjectParentRefArgs']]]] = None,
                 project_key: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceProjectRegistryMetadataArgs']] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceProject resources.
        :param pulumi.Input[_builtins.str] description: (Updatable) A user defined description for the project.
        :param pulumi.Input[_builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[_builtins.str] key: (Updatable) Generated key that can be used in API calls to identify project.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] key_map: A key map. If provided, the key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceProjectMetadataArgs']]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[_builtins.str] model_type: The type of the object.
        :param pulumi.Input[_builtins.str] model_version: (Updatable) The model version of an object.
        :param pulumi.Input[_builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[_builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[_builtins.int] object_version: The version of the object that is used to track changes in the object instance.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceProjectParentRefArgs']]] parent_reves: A reference to the object's parent.
        :param pulumi.Input['WorkspaceProjectRegistryMetadataArgs'] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if key_map is not None:
            pulumi.set(__self__, "key_map", key_map)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)
        if parent_reves is not None:
            pulumi.set(__self__, "parent_reves", parent_reves)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user defined description for the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Generated key that can be used in API calls to identify project.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="keyMap")
    def key_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A key map. If provided, the key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        """
        return pulumi.get(self, "key_map")

    @key_map.setter
    def key_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "key_map", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceProjectMetadataArgs']]]]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceProjectMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the object.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_type", value)

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The model version of an object.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_status", value)

    @_builtins.property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the object that is used to track changes in the object instance.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_version", value)

    @_builtins.property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceProjectParentRefArgs']]]]:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @parent_reves.setter
    def parent_reves(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceProjectParentRefArgs']]]]):
        pulumi.set(self, "parent_reves", value)

    @_builtins.property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_key", value)

    @_builtins.property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceProjectRegistryMetadataArgs']]:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceProjectRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("oci:DataIntegration/workspaceProject:WorkspaceProject")
class WorkspaceProject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_status: Optional[pulumi.Input[_builtins.int]] = None,
                 project_key: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_metadata: Optional[pulumi.Input[Union['WorkspaceProjectRegistryMetadataArgs', 'WorkspaceProjectRegistryMetadataArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Workspace Project resource in Oracle Cloud Infrastructure Data Integration service.

        Creates a project. Projects are organizational constructs within a workspace that you use to organize your design-time resources, such as tasks or data flows. Projects can be organized into folders.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_project = oci.dataintegration.WorkspaceProject("test_workspace_project",
            identifier=workspace_project_identifier,
            name=workspace_project_name,
            workspace_id=test_workspace["id"],
            description=workspace_project_description,
            key=workspace_project_key,
            model_version=workspace_project_model_version,
            object_status=workspace_project_object_status,
            registry_metadata={
                "aggregator_key": workspace_project_registry_metadata_aggregator_key,
                "is_favorite": workspace_project_registry_metadata_is_favorite,
                "key": workspace_project_registry_metadata_key,
                "labels": workspace_project_registry_metadata_labels,
                "registry_version": workspace_project_registry_metadata_registry_version,
            })
        ```

        ## Import

        WorkspaceProjects can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceProject:WorkspaceProject test_workspace_project "workspaces/{workspaceId}/projects/{projectKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: (Updatable) A user defined description for the project.
        :param pulumi.Input[_builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[_builtins.str] key: (Updatable) Generated key that can be used in API calls to identify project.
        :param pulumi.Input[_builtins.str] model_version: (Updatable) The model version of an object.
        :param pulumi.Input[_builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[_builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[Union['WorkspaceProjectRegistryMetadataArgs', 'WorkspaceProjectRegistryMetadataArgsDict']] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Workspace Project resource in Oracle Cloud Infrastructure Data Integration service.

        Creates a project. Projects are organizational constructs within a workspace that you use to organize your design-time resources, such as tasks or data flows. Projects can be organized into folders.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_project = oci.dataintegration.WorkspaceProject("test_workspace_project",
            identifier=workspace_project_identifier,
            name=workspace_project_name,
            workspace_id=test_workspace["id"],
            description=workspace_project_description,
            key=workspace_project_key,
            model_version=workspace_project_model_version,
            object_status=workspace_project_object_status,
            registry_metadata={
                "aggregator_key": workspace_project_registry_metadata_aggregator_key,
                "is_favorite": workspace_project_registry_metadata_is_favorite,
                "key": workspace_project_registry_metadata_key,
                "labels": workspace_project_registry_metadata_labels,
                "registry_version": workspace_project_registry_metadata_registry_version,
            })
        ```

        ## Import

        WorkspaceProjects can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceProject:WorkspaceProject test_workspace_project "workspaces/{workspaceId}/projects/{projectKey}"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 model_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_status: Optional[pulumi.Input[_builtins.int]] = None,
                 project_key: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_metadata: Optional[pulumi.Input[Union['WorkspaceProjectRegistryMetadataArgs', 'WorkspaceProjectRegistryMetadataArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceProjectArgs.__new__(WorkspaceProjectArgs)

            __props__.__dict__["description"] = description
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["key"] = key
            __props__.__dict__["model_version"] = model_version
            __props__.__dict__["name"] = name
            __props__.__dict__["object_status"] = object_status
            __props__.__dict__["project_key"] = project_key
            __props__.__dict__["registry_metadata"] = registry_metadata
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["key_map"] = None
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["model_type"] = None
            __props__.__dict__["object_version"] = None
            __props__.__dict__["parent_reves"] = None
        super(WorkspaceProject, __self__).__init__(
            'oci:DataIntegration/workspaceProject:WorkspaceProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            key_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceProjectMetadataArgs', 'WorkspaceProjectMetadataArgsDict']]]]] = None,
            model_type: Optional[pulumi.Input[_builtins.str]] = None,
            model_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            object_status: Optional[pulumi.Input[_builtins.int]] = None,
            object_version: Optional[pulumi.Input[_builtins.int]] = None,
            parent_reves: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceProjectParentRefArgs', 'WorkspaceProjectParentRefArgsDict']]]]] = None,
            project_key: Optional[pulumi.Input[_builtins.str]] = None,
            registry_metadata: Optional[pulumi.Input[Union['WorkspaceProjectRegistryMetadataArgs', 'WorkspaceProjectRegistryMetadataArgsDict']]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceProject':
        """
        Get an existing WorkspaceProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: (Updatable) A user defined description for the project.
        :param pulumi.Input[_builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[_builtins.str] key: (Updatable) Generated key that can be used in API calls to identify project.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] key_map: A key map. If provided, the key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceProjectMetadataArgs', 'WorkspaceProjectMetadataArgsDict']]]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[_builtins.str] model_type: The type of the object.
        :param pulumi.Input[_builtins.str] model_version: (Updatable) The model version of an object.
        :param pulumi.Input[_builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[_builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[_builtins.int] object_version: The version of the object that is used to track changes in the object instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceProjectParentRefArgs', 'WorkspaceProjectParentRefArgsDict']]]] parent_reves: A reference to the object's parent.
        :param pulumi.Input[Union['WorkspaceProjectRegistryMetadataArgs', 'WorkspaceProjectRegistryMetadataArgsDict']] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[_builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceProjectState.__new__(_WorkspaceProjectState)

        __props__.__dict__["description"] = description
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["key"] = key
        __props__.__dict__["key_map"] = key_map
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["model_version"] = model_version
        __props__.__dict__["name"] = name
        __props__.__dict__["object_status"] = object_status
        __props__.__dict__["object_version"] = object_version
        __props__.__dict__["parent_reves"] = parent_reves
        __props__.__dict__["project_key"] = project_key
        __props__.__dict__["registry_metadata"] = registry_metadata
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceProject(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user defined description for the project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Generated key that can be used in API calls to identify project.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="keyMap")
    def key_map(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A key map. If provided, the key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        """
        return pulumi.get(self, "key_map")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceProjectMetadata']]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the object.
        """
        return pulumi.get(self, "model_type")

    @_builtins.property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The model version of an object.
        """
        return pulumi.get(self, "model_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @_builtins.property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the object that is used to track changes in the object instance.
        """
        return pulumi.get(self, "object_version")

    @_builtins.property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> pulumi.Output[Sequence['outputs.WorkspaceProjectParentRef']]:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @_builtins.property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "project_key")

    @_builtins.property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> pulumi.Output['outputs.WorkspaceProjectRegistryMetadata']:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

