# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseSecurityConfigManagementArgs', 'DatabaseSecurityConfigManagement']

@pulumi.input_type
class DatabaseSecurityConfigManagementArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 refresh_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 sql_firewall_config: Optional[pulumi.Input['DatabaseSecurityConfigManagementSqlFirewallConfigArgs']] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseSecurityConfigManagement resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the database security config.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the security policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the database security config. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] refresh_trigger: (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['DatabaseSecurityConfigManagementSqlFirewallConfigArgs'] sql_firewall_config: (Updatable) Details to update the SQL firewall config.
        :param pulumi.Input[_builtins.str] target_id: Unique target identifier.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if refresh_trigger is not None:
            pulumi.set(__self__, "refresh_trigger", refresh_trigger)
        if sql_firewall_config is not None:
            pulumi.set(__self__, "sql_firewall_config", sql_firewall_config)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment containing the database security config.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the security policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the database security config. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="refreshTrigger")
    def refresh_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "refresh_trigger")

    @refresh_trigger.setter
    def refresh_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "refresh_trigger", value)

    @_builtins.property
    @pulumi.getter(name="sqlFirewallConfig")
    def sql_firewall_config(self) -> Optional[pulumi.Input['DatabaseSecurityConfigManagementSqlFirewallConfigArgs']]:
        """
        (Updatable) Details to update the SQL firewall config.
        """
        return pulumi.get(self, "sql_firewall_config")

    @sql_firewall_config.setter
    def sql_firewall_config(self, value: Optional[pulumi.Input['DatabaseSecurityConfigManagementSqlFirewallConfigArgs']]):
        pulumi.set(self, "sql_firewall_config", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique target identifier.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)


@pulumi.input_type
class _DatabaseSecurityConfigManagementState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 sql_firewall_config: Optional[pulumi.Input['DatabaseSecurityConfigManagementSqlFirewallConfigArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_refreshed: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseSecurityConfigManagement resources.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the database security config.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the security policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the database security config. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the database security config in Data Safe.
        :param pulumi.Input[_builtins.bool] refresh_trigger: (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['DatabaseSecurityConfigManagementSqlFirewallConfigArgs'] sql_firewall_config: (Updatable) Details to update the SQL firewall config.
        :param pulumi.Input[_builtins.str] state: The current state of the database security config.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] target_id: Unique target identifier.
        :param pulumi.Input[_builtins.str] time_created: The time that the database security config was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_last_refreshed: The last date and time the database security config was refreshed, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the database security configuration was last updated, in the format defined by RFC3339.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if refresh_trigger is not None:
            pulumi.set(__self__, "refresh_trigger", refresh_trigger)
        if sql_firewall_config is not None:
            pulumi.set(__self__, "sql_firewall_config", sql_firewall_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_refreshed is not None:
            pulumi.set(__self__, "time_last_refreshed", time_last_refreshed)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment containing the database security config.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the security policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the database security config. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Details about the current state of the database security config in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="refreshTrigger")
    def refresh_trigger(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "refresh_trigger")

    @refresh_trigger.setter
    def refresh_trigger(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "refresh_trigger", value)

    @_builtins.property
    @pulumi.getter(name="sqlFirewallConfig")
    def sql_firewall_config(self) -> Optional[pulumi.Input['DatabaseSecurityConfigManagementSqlFirewallConfigArgs']]:
        """
        (Updatable) Details to update the SQL firewall config.
        """
        return pulumi.get(self, "sql_firewall_config")

    @sql_firewall_config.setter
    def sql_firewall_config(self, value: Optional[pulumi.Input['DatabaseSecurityConfigManagementSqlFirewallConfigArgs']]):
        pulumi.set(self, "sql_firewall_config", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the database security config.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique target identifier.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time that the database security config was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeLastRefreshed")
    def time_last_refreshed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last date and time the database security config was refreshed, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_refreshed")

    @time_last_refreshed.setter
    def time_last_refreshed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_refreshed", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the database security configuration was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DataSafe/databaseSecurityConfigManagement:DatabaseSecurityConfigManagement")
class DatabaseSecurityConfigManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 refresh_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 sql_firewall_config: Optional[pulumi.Input[Union['DatabaseSecurityConfigManagementSqlFirewallConfigArgs', 'DatabaseSecurityConfigManagementSqlFirewallConfigArgsDict']]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Database Security Config Management resource in Oracle Cloud Infrastructure Data Safe service.

        Updates the database security configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_database_security_config_management = oci.datasafe.DatabaseSecurityConfigManagement("test_database_security_config_management",
            compartment_id=compartment_id,
            target_id=test_target_database["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=database_security_config_management_description,
            display_name=database_security_config_management_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            sql_firewall_config={
                "exclude_job": database_security_config_management_sql_firewall_config_exclude_job,
                "status": database_security_config_management_sql_firewall_config_status,
                "violation_log_auto_purge": database_security_config_management_sql_firewall_config_violation_log_auto_purge,
            })
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the database security config.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the security policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the database security config. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] refresh_trigger: (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['DatabaseSecurityConfigManagementSqlFirewallConfigArgs', 'DatabaseSecurityConfigManagementSqlFirewallConfigArgsDict']] sql_firewall_config: (Updatable) Details to update the SQL firewall config.
        :param pulumi.Input[_builtins.str] target_id: Unique target identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DatabaseSecurityConfigManagementArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Database Security Config Management resource in Oracle Cloud Infrastructure Data Safe service.

        Updates the database security configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_database_security_config_management = oci.datasafe.DatabaseSecurityConfigManagement("test_database_security_config_management",
            compartment_id=compartment_id,
            target_id=test_target_database["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=database_security_config_management_description,
            display_name=database_security_config_management_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            sql_firewall_config={
                "exclude_job": database_security_config_management_sql_firewall_config_exclude_job,
                "status": database_security_config_management_sql_firewall_config_status,
                "violation_log_auto_purge": database_security_config_management_sql_firewall_config_violation_log_auto_purge,
            })
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param DatabaseSecurityConfigManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseSecurityConfigManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 refresh_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
                 sql_firewall_config: Optional[pulumi.Input[Union['DatabaseSecurityConfigManagementSqlFirewallConfigArgs', 'DatabaseSecurityConfigManagementSqlFirewallConfigArgsDict']]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseSecurityConfigManagementArgs.__new__(DatabaseSecurityConfigManagementArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["refresh_trigger"] = refresh_trigger
            __props__.__dict__["sql_firewall_config"] = sql_firewall_config
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_refreshed"] = None
            __props__.__dict__["time_updated"] = None
        super(DatabaseSecurityConfigManagement, __self__).__init__(
            'oci:DataSafe/databaseSecurityConfigManagement:DatabaseSecurityConfigManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_trigger: Optional[pulumi.Input[_builtins.bool]] = None,
            sql_firewall_config: Optional[pulumi.Input[Union['DatabaseSecurityConfigManagementSqlFirewallConfigArgs', 'DatabaseSecurityConfigManagementSqlFirewallConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_refreshed: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseSecurityConfigManagement':
        """
        Get an existing DatabaseSecurityConfigManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment containing the database security config.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the security policy.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the database security config. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: Details about the current state of the database security config in Data Safe.
        :param pulumi.Input[_builtins.bool] refresh_trigger: (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['DatabaseSecurityConfigManagementSqlFirewallConfigArgs', 'DatabaseSecurityConfigManagementSqlFirewallConfigArgsDict']] sql_firewall_config: (Updatable) Details to update the SQL firewall config.
        :param pulumi.Input[_builtins.str] state: The current state of the database security config.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] target_id: Unique target identifier.
        :param pulumi.Input[_builtins.str] time_created: The time that the database security config was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_last_refreshed: The last date and time the database security config was refreshed, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the database security configuration was last updated, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseSecurityConfigManagementState.__new__(_DatabaseSecurityConfigManagementState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["refresh_trigger"] = refresh_trigger
        __props__.__dict__["sql_firewall_config"] = sql_firewall_config
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_refreshed"] = time_last_refreshed
        __props__.__dict__["time_updated"] = time_updated
        return DatabaseSecurityConfigManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment containing the database security config.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the security policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the database security config. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Details about the current state of the database security config in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="refreshTrigger")
    def refresh_trigger(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Updatable) An optional property when incremented triggers Refresh. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "refresh_trigger")

    @_builtins.property
    @pulumi.getter(name="sqlFirewallConfig")
    def sql_firewall_config(self) -> pulumi.Output['outputs.DatabaseSecurityConfigManagementSqlFirewallConfig']:
        """
        (Updatable) Details to update the SQL firewall config.
        """
        return pulumi.get(self, "sql_firewall_config")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the database security config.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique target identifier.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time that the database security config was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastRefreshed")
    def time_last_refreshed(self) -> pulumi.Output[_builtins.str]:
        """
        The last date and time the database security config was refreshed, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_refreshed")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the database security configuration was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

