# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiscoveryJobsResultArgs', 'DiscoveryJobsResult']

@pulumi.input_type
class DiscoveryJobsResultArgs:
    def __init__(__self__, *,
                 discovery_job_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a DiscoveryJobsResult resource.
        :param pulumi.Input[_builtins.str] discovery_job_id: The OCID of the discovery job.
        """
        if discovery_job_id is not None:
            warnings.warn("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""", DeprecationWarning)
            pulumi.log.warn("""discovery_job_id is deprecated: The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
        pulumi.set(__self__, "discovery_job_id", discovery_job_id)

    @_builtins.property
    @pulumi.getter(name="discoveryJobId")
    @_utilities.deprecated("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
    def discovery_job_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the discovery job.
        """
        return pulumi.get(self, "discovery_job_id")

    @discovery_job_id.setter
    def discovery_job_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "discovery_job_id", value)


@pulumi.input_type
class _DiscoveryJobsResultState:
    def __init__(__self__, *,
                 app_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 column_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 discovery_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_type: Optional[pulumi.Input[_builtins.str]] = None,
                 estimated_data_value_count: Optional[pulumi.Input[_builtins.str]] = None,
                 is_result_applied: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DiscoveryJobsResultModifiedAttributeArgs']]]] = None,
                 object: Optional[pulumi.Input[_builtins.str]] = None,
                 object_type: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 planned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 relation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sample_data_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_columnkey: Optional[pulumi.Input[_builtins.str]] = None,
                 sensitive_type_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DiscoveryJobsResult resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] app_defined_child_column_keys: Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column.
        :param pulumi.Input[_builtins.str] app_name: The name of the application. An application is an entity that is identified by a schema and stores sensitive information for that schema. Its value will be same as schemaName, if no value is passed.
        :param pulumi.Input[_builtins.str] column_name: The name of the sensitive column.
        :param pulumi.Input[_builtins.str] data_type: The data type of the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_defined_child_column_keys: Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column.
        :param pulumi.Input[_builtins.str] discovery_job_id: The OCID of the discovery job.
        :param pulumi.Input[_builtins.str] discovery_type: The type of the discovery result. It can be one of the following three types: NEW: A new sensitive column in the target database that is not in the sensitive data model. DELETED: A column that is present in the sensitive data model but has been deleted from the target database. MODIFIED: A column that is present in the target database as well as the sensitive data model but some of its attributes have been modified.
        :param pulumi.Input[_builtins.str] estimated_data_value_count: The estimated number of data values the column has in the associated database.
        :param pulumi.Input[_builtins.bool] is_result_applied: Indicates if the discovery result has been processed. You can update this attribute using the PatchDiscoveryJobResults operation to track whether the discovery result has already been processed and applied to the sensitive data model.
        :param pulumi.Input[_builtins.str] key: The unique key that identifies the discovery result.
        :param pulumi.Input[Sequence[pulumi.Input['DiscoveryJobsResultModifiedAttributeArgs']]] modified_attributes: The attributes of a sensitive column that have been modified in the target database. It's populated only in the case of MODIFIED discovery results and shows the new values of the modified attributes.
        :param pulumi.Input[_builtins.str] object: The database object that contains the sensitive column.
        :param pulumi.Input[_builtins.str] object_type: The type of the database object that contains the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] parent_column_keys: Unique keys identifying the columns that are parents of the sensitive column. At present, it tracks a single parent only.
        :param pulumi.Input[_builtins.str] planned_action: Specifies how to process the discovery result. It's set to NONE by default. Use the PatchDiscoveryJobResults operation to update this attribute. You can choose one of the following options: ACCEPT: To accept the discovery result and update the sensitive data model to reflect the changes. REJECT: To reject the discovery result so that it doesn't change the sensitive data model. INVALIDATE: To invalidate a newly discovered column. It adds the column to the sensitive data model but marks it as invalid. It helps track false positives and ensure that they aren't reported by future discovery jobs. After specifying the planned action, you can use the ApplyDiscoveryJobResults operation to automatically process the discovery results.
        :param pulumi.Input[_builtins.str] relation_type: The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sample_data_values: Original data values collected for the sensitive column from the associated database. Sample data helps review the column and ensure that it actually contains sensitive data. Note that sample data is retrieved by a data discovery job only if the isSampleDataCollectionEnabled attribute is set to true. At present, only one data value is collected per sensitive column.
        :param pulumi.Input[_builtins.str] schema_name: The database schema that contains the sensitive column.
        :param pulumi.Input[_builtins.str] sensitive_columnkey: The unique key that identifies the sensitive column represented by the discovery result.
        :param pulumi.Input[_builtins.str] sensitive_type_id: The OCID of the sensitive type associated with the sensitive column.
        """
        if app_defined_child_column_keys is not None:
            pulumi.set(__self__, "app_defined_child_column_keys", app_defined_child_column_keys)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if db_defined_child_column_keys is not None:
            pulumi.set(__self__, "db_defined_child_column_keys", db_defined_child_column_keys)
        if discovery_job_id is not None:
            warnings.warn("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""", DeprecationWarning)
            pulumi.log.warn("""discovery_job_id is deprecated: The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
        if discovery_job_id is not None:
            pulumi.set(__self__, "discovery_job_id", discovery_job_id)
        if discovery_type is not None:
            warnings.warn("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""", DeprecationWarning)
            pulumi.log.warn("""discovery_type is deprecated: The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
        if discovery_type is not None:
            pulumi.set(__self__, "discovery_type", discovery_type)
        if estimated_data_value_count is not None:
            pulumi.set(__self__, "estimated_data_value_count", estimated_data_value_count)
        if is_result_applied is not None:
            pulumi.set(__self__, "is_result_applied", is_result_applied)
        if key is not None:
            warnings.warn("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""", DeprecationWarning)
            pulumi.log.warn("""key is deprecated: The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
        if key is not None:
            pulumi.set(__self__, "key", key)
        if modified_attributes is not None:
            pulumi.set(__self__, "modified_attributes", modified_attributes)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)
        if parent_column_keys is not None:
            pulumi.set(__self__, "parent_column_keys", parent_column_keys)
        if planned_action is not None:
            pulumi.set(__self__, "planned_action", planned_action)
        if relation_type is not None:
            pulumi.set(__self__, "relation_type", relation_type)
        if sample_data_values is not None:
            pulumi.set(__self__, "sample_data_values", sample_data_values)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if sensitive_columnkey is not None:
            pulumi.set(__self__, "sensitive_columnkey", sensitive_columnkey)
        if sensitive_type_id is not None:
            pulumi.set(__self__, "sensitive_type_id", sensitive_type_id)

    @_builtins.property
    @pulumi.getter(name="appDefinedChildColumnKeys")
    def app_defined_child_column_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column.
        """
        return pulumi.get(self, "app_defined_child_column_keys")

    @app_defined_child_column_keys.setter
    def app_defined_child_column_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_defined_child_column_keys", value)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the application. An application is an entity that is identified by a schema and stores sensitive information for that schema. Its value will be same as schemaName, if no value is passed.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the sensitive column.
        """
        return pulumi.get(self, "column_name")

    @column_name.setter
    def column_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "column_name", value)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data type of the sensitive column.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_type", value)

    @_builtins.property
    @pulumi.getter(name="dbDefinedChildColumnKeys")
    def db_defined_child_column_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column.
        """
        return pulumi.get(self, "db_defined_child_column_keys")

    @db_defined_child_column_keys.setter
    def db_defined_child_column_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_defined_child_column_keys", value)

    @_builtins.property
    @pulumi.getter(name="discoveryJobId")
    @_utilities.deprecated("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
    def discovery_job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the discovery job.
        """
        return pulumi.get(self, "discovery_job_id")

    @discovery_job_id.setter
    def discovery_job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discovery_job_id", value)

    @_builtins.property
    @pulumi.getter(name="discoveryType")
    @_utilities.deprecated("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
    def discovery_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the discovery result. It can be one of the following three types: NEW: A new sensitive column in the target database that is not in the sensitive data model. DELETED: A column that is present in the sensitive data model but has been deleted from the target database. MODIFIED: A column that is present in the target database as well as the sensitive data model but some of its attributes have been modified.
        """
        return pulumi.get(self, "discovery_type")

    @discovery_type.setter
    def discovery_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discovery_type", value)

    @_builtins.property
    @pulumi.getter(name="estimatedDataValueCount")
    def estimated_data_value_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The estimated number of data values the column has in the associated database.
        """
        return pulumi.get(self, "estimated_data_value_count")

    @estimated_data_value_count.setter
    def estimated_data_value_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "estimated_data_value_count", value)

    @_builtins.property
    @pulumi.getter(name="isResultApplied")
    def is_result_applied(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the discovery result has been processed. You can update this attribute using the PatchDiscoveryJobResults operation to track whether the discovery result has already been processed and applied to the sensitive data model.
        """
        return pulumi.get(self, "is_result_applied")

    @is_result_applied.setter
    def is_result_applied(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_result_applied", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique key that identifies the discovery result.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="modifiedAttributes")
    def modified_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiscoveryJobsResultModifiedAttributeArgs']]]]:
        """
        The attributes of a sensitive column that have been modified in the target database. It's populated only in the case of MODIFIED discovery results and shows the new values of the modified attributes.
        """
        return pulumi.get(self, "modified_attributes")

    @modified_attributes.setter
    def modified_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiscoveryJobsResultModifiedAttributeArgs']]]]):
        pulumi.set(self, "modified_attributes", value)

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database object that contains the sensitive column.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object", value)

    @_builtins.property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the database object that contains the sensitive column.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_type", value)

    @_builtins.property
    @pulumi.getter(name="parentColumnKeys")
    def parent_column_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Unique keys identifying the columns that are parents of the sensitive column. At present, it tracks a single parent only.
        """
        return pulumi.get(self, "parent_column_keys")

    @parent_column_keys.setter
    def parent_column_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parent_column_keys", value)

    @_builtins.property
    @pulumi.getter(name="plannedAction")
    def planned_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how to process the discovery result. It's set to NONE by default. Use the PatchDiscoveryJobResults operation to update this attribute. You can choose one of the following options: ACCEPT: To accept the discovery result and update the sensitive data model to reflect the changes. REJECT: To reject the discovery result so that it doesn't change the sensitive data model. INVALIDATE: To invalidate a newly discovered column. It adds the column to the sensitive data model but marks it as invalid. It helps track false positives and ensure that they aren't reported by future discovery jobs. After specifying the planned action, you can use the ApplyDiscoveryJobResults operation to automatically process the discovery results.
        """
        return pulumi.get(self, "planned_action")

    @planned_action.setter
    def planned_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "planned_action", value)

    @_builtins.property
    @pulumi.getter(name="relationType")
    def relation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        """
        return pulumi.get(self, "relation_type")

    @relation_type.setter
    def relation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relation_type", value)

    @_builtins.property
    @pulumi.getter(name="sampleDataValues")
    def sample_data_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Original data values collected for the sensitive column from the associated database. Sample data helps review the column and ensure that it actually contains sensitive data. Note that sample data is retrieved by a data discovery job only if the isSampleDataCollectionEnabled attribute is set to true. At present, only one data value is collected per sensitive column.
        """
        return pulumi.get(self, "sample_data_values")

    @sample_data_values.setter
    def sample_data_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sample_data_values", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database schema that contains the sensitive column.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveColumnkey")
    def sensitive_columnkey(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique key that identifies the sensitive column represented by the discovery result.
        """
        return pulumi.get(self, "sensitive_columnkey")

    @sensitive_columnkey.setter
    def sensitive_columnkey(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sensitive_columnkey", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the sensitive type associated with the sensitive column.
        """
        return pulumi.get(self, "sensitive_type_id")

    @sensitive_type_id.setter
    def sensitive_type_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sensitive_type_id", value)


@pulumi.type_token("oci:DataSafe/discoveryJobsResult:DiscoveryJobsResult")
class DiscoveryJobsResult(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 discovery_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        **Deprecated. This resource does not support create and update operations.**

        This resource provides the Discovery Jobs Result resource in Oracle Cloud Infrastructure Data Safe service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_discovery_jobs_result = oci.datasafe.DiscoveryJobsResult("test_discovery_jobs_result")
        ```

        ## Import

        DiscoveryJobsResults can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/discoveryJobsResult:DiscoveryJobsResult test_discovery_jobs_result "discoveryJobs/{discoveryJobId}/results/{resultKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] discovery_job_id: The OCID of the discovery job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiscoveryJobsResultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        **Deprecated. This resource does not support create and update operations.**

        This resource provides the Discovery Jobs Result resource in Oracle Cloud Infrastructure Data Safe service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_discovery_jobs_result = oci.datasafe.DiscoveryJobsResult("test_discovery_jobs_result")
        ```

        ## Import

        DiscoveryJobsResults can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/discoveryJobsResult:DiscoveryJobsResult test_discovery_jobs_result "discoveryJobs/{discoveryJobId}/results/{resultKey}"
        ```

        :param str resource_name: The name of the resource.
        :param DiscoveryJobsResultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiscoveryJobsResultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 discovery_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiscoveryJobsResultArgs.__new__(DiscoveryJobsResultArgs)

            if discovery_job_id is None and not opts.urn:
                raise TypeError("Missing required property 'discovery_job_id'")
            __props__.__dict__["discovery_job_id"] = discovery_job_id
            __props__.__dict__["app_defined_child_column_keys"] = None
            __props__.__dict__["app_name"] = None
            __props__.__dict__["column_name"] = None
            __props__.__dict__["data_type"] = None
            __props__.__dict__["db_defined_child_column_keys"] = None
            __props__.__dict__["discovery_type"] = None
            __props__.__dict__["estimated_data_value_count"] = None
            __props__.__dict__["is_result_applied"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["modified_attributes"] = None
            __props__.__dict__["object"] = None
            __props__.__dict__["object_type"] = None
            __props__.__dict__["parent_column_keys"] = None
            __props__.__dict__["planned_action"] = None
            __props__.__dict__["relation_type"] = None
            __props__.__dict__["sample_data_values"] = None
            __props__.__dict__["schema_name"] = None
            __props__.__dict__["sensitive_columnkey"] = None
            __props__.__dict__["sensitive_type_id"] = None
        super(DiscoveryJobsResult, __self__).__init__(
            'oci:DataSafe/discoveryJobsResult:DiscoveryJobsResult',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            app_name: Optional[pulumi.Input[_builtins.str]] = None,
            column_name: Optional[pulumi.Input[_builtins.str]] = None,
            data_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            discovery_job_id: Optional[pulumi.Input[_builtins.str]] = None,
            discovery_type: Optional[pulumi.Input[_builtins.str]] = None,
            estimated_data_value_count: Optional[pulumi.Input[_builtins.str]] = None,
            is_result_applied: Optional[pulumi.Input[_builtins.bool]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            modified_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiscoveryJobsResultModifiedAttributeArgs', 'DiscoveryJobsResultModifiedAttributeArgsDict']]]]] = None,
            object: Optional[pulumi.Input[_builtins.str]] = None,
            object_type: Optional[pulumi.Input[_builtins.str]] = None,
            parent_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            planned_action: Optional[pulumi.Input[_builtins.str]] = None,
            relation_type: Optional[pulumi.Input[_builtins.str]] = None,
            sample_data_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            sensitive_columnkey: Optional[pulumi.Input[_builtins.str]] = None,
            sensitive_type_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DiscoveryJobsResult':
        """
        Get an existing DiscoveryJobsResult resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] app_defined_child_column_keys: Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column.
        :param pulumi.Input[_builtins.str] app_name: The name of the application. An application is an entity that is identified by a schema and stores sensitive information for that schema. Its value will be same as schemaName, if no value is passed.
        :param pulumi.Input[_builtins.str] column_name: The name of the sensitive column.
        :param pulumi.Input[_builtins.str] data_type: The data type of the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_defined_child_column_keys: Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column.
        :param pulumi.Input[_builtins.str] discovery_job_id: The OCID of the discovery job.
        :param pulumi.Input[_builtins.str] discovery_type: The type of the discovery result. It can be one of the following three types: NEW: A new sensitive column in the target database that is not in the sensitive data model. DELETED: A column that is present in the sensitive data model but has been deleted from the target database. MODIFIED: A column that is present in the target database as well as the sensitive data model but some of its attributes have been modified.
        :param pulumi.Input[_builtins.str] estimated_data_value_count: The estimated number of data values the column has in the associated database.
        :param pulumi.Input[_builtins.bool] is_result_applied: Indicates if the discovery result has been processed. You can update this attribute using the PatchDiscoveryJobResults operation to track whether the discovery result has already been processed and applied to the sensitive data model.
        :param pulumi.Input[_builtins.str] key: The unique key that identifies the discovery result.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiscoveryJobsResultModifiedAttributeArgs', 'DiscoveryJobsResultModifiedAttributeArgsDict']]]] modified_attributes: The attributes of a sensitive column that have been modified in the target database. It's populated only in the case of MODIFIED discovery results and shows the new values of the modified attributes.
        :param pulumi.Input[_builtins.str] object: The database object that contains the sensitive column.
        :param pulumi.Input[_builtins.str] object_type: The type of the database object that contains the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] parent_column_keys: Unique keys identifying the columns that are parents of the sensitive column. At present, it tracks a single parent only.
        :param pulumi.Input[_builtins.str] planned_action: Specifies how to process the discovery result. It's set to NONE by default. Use the PatchDiscoveryJobResults operation to update this attribute. You can choose one of the following options: ACCEPT: To accept the discovery result and update the sensitive data model to reflect the changes. REJECT: To reject the discovery result so that it doesn't change the sensitive data model. INVALIDATE: To invalidate a newly discovered column. It adds the column to the sensitive data model but marks it as invalid. It helps track false positives and ensure that they aren't reported by future discovery jobs. After specifying the planned action, you can use the ApplyDiscoveryJobResults operation to automatically process the discovery results.
        :param pulumi.Input[_builtins.str] relation_type: The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sample_data_values: Original data values collected for the sensitive column from the associated database. Sample data helps review the column and ensure that it actually contains sensitive data. Note that sample data is retrieved by a data discovery job only if the isSampleDataCollectionEnabled attribute is set to true. At present, only one data value is collected per sensitive column.
        :param pulumi.Input[_builtins.str] schema_name: The database schema that contains the sensitive column.
        :param pulumi.Input[_builtins.str] sensitive_columnkey: The unique key that identifies the sensitive column represented by the discovery result.
        :param pulumi.Input[_builtins.str] sensitive_type_id: The OCID of the sensitive type associated with the sensitive column.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiscoveryJobsResultState.__new__(_DiscoveryJobsResultState)

        __props__.__dict__["app_defined_child_column_keys"] = app_defined_child_column_keys
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["column_name"] = column_name
        __props__.__dict__["data_type"] = data_type
        __props__.__dict__["db_defined_child_column_keys"] = db_defined_child_column_keys
        __props__.__dict__["discovery_job_id"] = discovery_job_id
        __props__.__dict__["discovery_type"] = discovery_type
        __props__.__dict__["estimated_data_value_count"] = estimated_data_value_count
        __props__.__dict__["is_result_applied"] = is_result_applied
        __props__.__dict__["key"] = key
        __props__.__dict__["modified_attributes"] = modified_attributes
        __props__.__dict__["object"] = object
        __props__.__dict__["object_type"] = object_type
        __props__.__dict__["parent_column_keys"] = parent_column_keys
        __props__.__dict__["planned_action"] = planned_action
        __props__.__dict__["relation_type"] = relation_type
        __props__.__dict__["sample_data_values"] = sample_data_values
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["sensitive_columnkey"] = sensitive_columnkey
        __props__.__dict__["sensitive_type_id"] = sensitive_type_id
        return DiscoveryJobsResult(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appDefinedChildColumnKeys")
    def app_defined_child_column_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column.
        """
        return pulumi.get(self, "app_defined_child_column_keys")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the application. An application is an entity that is identified by a schema and stores sensitive information for that schema. Its value will be same as schemaName, if no value is passed.
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="columnName")
    def column_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the sensitive column.
        """
        return pulumi.get(self, "column_name")

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Output[_builtins.str]:
        """
        The data type of the sensitive column.
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter(name="dbDefinedChildColumnKeys")
    def db_defined_child_column_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column.
        """
        return pulumi.get(self, "db_defined_child_column_keys")

    @_builtins.property
    @pulumi.getter(name="discoveryJobId")
    @_utilities.deprecated("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
    def discovery_job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the discovery job.
        """
        return pulumi.get(self, "discovery_job_id")

    @_builtins.property
    @pulumi.getter(name="discoveryType")
    @_utilities.deprecated("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
    def discovery_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the discovery result. It can be one of the following three types: NEW: A new sensitive column in the target database that is not in the sensitive data model. DELETED: A column that is present in the sensitive data model but has been deleted from the target database. MODIFIED: A column that is present in the target database as well as the sensitive data model but some of its attributes have been modified.
        """
        return pulumi.get(self, "discovery_type")

    @_builtins.property
    @pulumi.getter(name="estimatedDataValueCount")
    def estimated_data_value_count(self) -> pulumi.Output[_builtins.str]:
        """
        The estimated number of data values the column has in the associated database.
        """
        return pulumi.get(self, "estimated_data_value_count")

    @_builtins.property
    @pulumi.getter(name="isResultApplied")
    def is_result_applied(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if the discovery result has been processed. You can update this attribute using the PatchDiscoveryJobResults operation to track whether the discovery result has already been processed and applied to the sensitive data model.
        """
        return pulumi.get(self, "is_result_applied")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The 'oci_data_safe_discovery_jobs_result' resource has been deprecated. It is no longer supported.""")
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The unique key that identifies the discovery result.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="modifiedAttributes")
    def modified_attributes(self) -> pulumi.Output[Sequence['outputs.DiscoveryJobsResultModifiedAttribute']]:
        """
        The attributes of a sensitive column that have been modified in the target database. It's populated only in the case of MODIFIED discovery results and shows the new values of the modified attributes.
        """
        return pulumi.get(self, "modified_attributes")

    @_builtins.property
    @pulumi.getter
    def object(self) -> pulumi.Output[_builtins.str]:
        """
        The database object that contains the sensitive column.
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter(name="objectType")
    def object_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the database object that contains the sensitive column.
        """
        return pulumi.get(self, "object_type")

    @_builtins.property
    @pulumi.getter(name="parentColumnKeys")
    def parent_column_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Unique keys identifying the columns that are parents of the sensitive column. At present, it tracks a single parent only.
        """
        return pulumi.get(self, "parent_column_keys")

    @_builtins.property
    @pulumi.getter(name="plannedAction")
    def planned_action(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies how to process the discovery result. It's set to NONE by default. Use the PatchDiscoveryJobResults operation to update this attribute. You can choose one of the following options: ACCEPT: To accept the discovery result and update the sensitive data model to reflect the changes. REJECT: To reject the discovery result so that it doesn't change the sensitive data model. INVALIDATE: To invalidate a newly discovered column. It adds the column to the sensitive data model but marks it as invalid. It helps track false positives and ensure that they aren't reported by future discovery jobs. After specifying the planned action, you can use the ApplyDiscoveryJobResults operation to automatically process the discovery results.
        """
        return pulumi.get(self, "planned_action")

    @_builtins.property
    @pulumi.getter(name="relationType")
    def relation_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        """
        return pulumi.get(self, "relation_type")

    @_builtins.property
    @pulumi.getter(name="sampleDataValues")
    def sample_data_values(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Original data values collected for the sensitive column from the associated database. Sample data helps review the column and ensure that it actually contains sensitive data. Note that sample data is retrieved by a data discovery job only if the isSampleDataCollectionEnabled attribute is set to true. At present, only one data value is collected per sensitive column.
        """
        return pulumi.get(self, "sample_data_values")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[_builtins.str]:
        """
        The database schema that contains the sensitive column.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter(name="sensitiveColumnkey")
    def sensitive_columnkey(self) -> pulumi.Output[_builtins.str]:
        """
        The unique key that identifies the sensitive column represented by the discovery result.
        """
        return pulumi.get(self, "sensitive_columnkey")

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the sensitive type associated with the sensitive column.
        """
        return pulumi.get(self, "sensitive_type_id")

