# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityAssessmentTemplateAssociationAnalyticsResult',
    'AwaitableGetSecurityAssessmentTemplateAssociationAnalyticsResult',
    'get_security_assessment_template_association_analytics',
    'get_security_assessment_template_association_analytics_output',
]

@pulumi.output_type
class GetSecurityAssessmentTemplateAssociationAnalyticsResult:
    """
    A collection of values returned by getSecurityAssessmentTemplateAssociationAnalytics.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, target_database_group_id=None, target_id=None, template_assessment_id=None, template_association_analytics_collections=None, template_baseline_assessment_id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if target_database_group_id and not isinstance(target_database_group_id, str):
            raise TypeError("Expected argument 'target_database_group_id' to be a str")
        pulumi.set(__self__, "target_database_group_id", target_database_group_id)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if template_assessment_id and not isinstance(template_assessment_id, str):
            raise TypeError("Expected argument 'template_assessment_id' to be a str")
        pulumi.set(__self__, "template_assessment_id", template_assessment_id)
        if template_association_analytics_collections and not isinstance(template_association_analytics_collections, list):
            raise TypeError("Expected argument 'template_association_analytics_collections' to be a list")
        pulumi.set(__self__, "template_association_analytics_collections", template_association_analytics_collections)
        if template_baseline_assessment_id and not isinstance(template_baseline_assessment_id, str):
            raise TypeError("Expected argument 'template_baseline_assessment_id' to be a str")
        pulumi.set(__self__, "template_baseline_assessment_id", template_baseline_assessment_id)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityAssessmentTemplateAssociationAnalyticsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="targetDatabaseGroupId")
    def target_database_group_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the target database group that the group assessment is created for.  This field will be in the response if the template was applied on a target group.
        """
        return pulumi.get(self, "target_database_group_id")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the target database. If the template was applied on a target group, this field will be the OCID of the target members of the target group. If the template was applied on an individual target, this field will contain that targetId.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="templateAssessmentId")
    def template_assessment_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the security assessment of type TEMPLATE.
        """
        return pulumi.get(self, "template_assessment_id")

    @_builtins.property
    @pulumi.getter(name="templateAssociationAnalyticsCollections")
    def template_association_analytics_collections(self) -> Sequence['outputs.GetSecurityAssessmentTemplateAssociationAnalyticsTemplateAssociationAnalyticsCollectionResult']:
        """
        The list of template_association_analytics_collection.
        """
        return pulumi.get(self, "template_association_analytics_collections")

    @_builtins.property
    @pulumi.getter(name="templateBaselineAssessmentId")
    def template_baseline_assessment_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the security assessment of type TEMPLATE_BASELINE.
        """
        return pulumi.get(self, "template_baseline_assessment_id")


class AwaitableGetSecurityAssessmentTemplateAssociationAnalyticsResult(GetSecurityAssessmentTemplateAssociationAnalyticsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityAssessmentTemplateAssociationAnalyticsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            target_database_group_id=self.target_database_group_id,
            target_id=self.target_id,
            template_assessment_id=self.template_assessment_id,
            template_association_analytics_collections=self.template_association_analytics_collections,
            template_baseline_assessment_id=self.template_baseline_assessment_id)


def get_security_assessment_template_association_analytics(access_level: Optional[_builtins.str] = None,
                                                           compartment_id: Optional[_builtins.str] = None,
                                                           compartment_id_in_subtree: Optional[_builtins.bool] = None,
                                                           filters: Optional[Sequence[Union['GetSecurityAssessmentTemplateAssociationAnalyticsFilterArgs', 'GetSecurityAssessmentTemplateAssociationAnalyticsFilterArgsDict']]] = None,
                                                           target_database_group_id: Optional[_builtins.str] = None,
                                                           target_id: Optional[_builtins.str] = None,
                                                           template_assessment_id: Optional[_builtins.str] = None,
                                                           template_baseline_assessment_id: Optional[_builtins.str] = None,
                                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityAssessmentTemplateAssociationAnalyticsResult:
    """
    This data source provides the list of Security Assessment Template Association Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of template association details in the specified compartment. This provides information about the
    overall template usage, by returning the count of the target databases/target groups using the templates.

    If the template baseline is created for a target group which contains several targets, we will have each individual target
    listed there as targetId field together with targetDatabaseGroupId. And if the template baseline is created for an individual target,
    it will have targetId field only.

    By leveraging the targetId filter, you will be able to know all the template or template baseline that this target has something to do with.
    No matter if they are directly applied or created for this target, or they are for the target group the target belongs to.

    When you perform the ListTemplateAssociationAnalytics operation, if the parameter compartmentIdInSubtree is set to "true," and if the
    parameter accessLevel is set to ACCESSIBLE, then the operation returns statistics from the compartments in which the requestor has INSPECT
    permissions on at least one resource, directly or indirectly (in subcompartments). If the operation is performed at the
    root compartment and the requestor does not have access to at least one subcompartment of the compartment specified by
    compartmentId, then "Not Authorized" is returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_template_association_analytics = oci.DataSafe.get_security_assessment_template_association_analytics(compartment_id=compartment_id,
        access_level=security_assessment_template_association_analytic_access_level,
        compartment_id_in_subtree=security_assessment_template_association_analytic_compartment_id_in_subtree,
        target_database_group_id=test_target_database_group["id"],
        target_id=test_target["id"],
        template_assessment_id=test_template_assessment["id"],
        template_baseline_assessment_id=test_template_baseline_assessment["id"])
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str target_database_group_id: A filter to return the target database group that matches the specified OCID.
    :param _builtins.str target_id: A filter to return only items related to a specific target OCID.
    :param _builtins.str template_assessment_id: The OCID of the security assessment of type TEMPLATE.
    :param _builtins.str template_baseline_assessment_id: The OCID of the security assessment of type TEMPLATE_BASELINE.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['targetDatabaseGroupId'] = target_database_group_id
    __args__['targetId'] = target_id
    __args__['templateAssessmentId'] = template_assessment_id
    __args__['templateBaselineAssessmentId'] = template_baseline_assessment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityAssessmentTemplateAssociationAnalytics:getSecurityAssessmentTemplateAssociationAnalytics', __args__, opts=opts, typ=GetSecurityAssessmentTemplateAssociationAnalyticsResult).value

    return AwaitableGetSecurityAssessmentTemplateAssociationAnalyticsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        target_database_group_id=pulumi.get(__ret__, 'target_database_group_id'),
        target_id=pulumi.get(__ret__, 'target_id'),
        template_assessment_id=pulumi.get(__ret__, 'template_assessment_id'),
        template_association_analytics_collections=pulumi.get(__ret__, 'template_association_analytics_collections'),
        template_baseline_assessment_id=pulumi.get(__ret__, 'template_baseline_assessment_id'))
def get_security_assessment_template_association_analytics_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                                  compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                                  compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecurityAssessmentTemplateAssociationAnalyticsFilterArgs', 'GetSecurityAssessmentTemplateAssociationAnalyticsFilterArgsDict']]]]] = None,
                                                                  target_database_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                                  target_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                                  template_assessment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                                  template_baseline_assessment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityAssessmentTemplateAssociationAnalyticsResult]:
    """
    This data source provides the list of Security Assessment Template Association Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of template association details in the specified compartment. This provides information about the
    overall template usage, by returning the count of the target databases/target groups using the templates.

    If the template baseline is created for a target group which contains several targets, we will have each individual target
    listed there as targetId field together with targetDatabaseGroupId. And if the template baseline is created for an individual target,
    it will have targetId field only.

    By leveraging the targetId filter, you will be able to know all the template or template baseline that this target has something to do with.
    No matter if they are directly applied or created for this target, or they are for the target group the target belongs to.

    When you perform the ListTemplateAssociationAnalytics operation, if the parameter compartmentIdInSubtree is set to "true," and if the
    parameter accessLevel is set to ACCESSIBLE, then the operation returns statistics from the compartments in which the requestor has INSPECT
    permissions on at least one resource, directly or indirectly (in subcompartments). If the operation is performed at the
    root compartment and the requestor does not have access to at least one subcompartment of the compartment specified by
    compartmentId, then "Not Authorized" is returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_template_association_analytics = oci.DataSafe.get_security_assessment_template_association_analytics(compartment_id=compartment_id,
        access_level=security_assessment_template_association_analytic_access_level,
        compartment_id_in_subtree=security_assessment_template_association_analytic_compartment_id_in_subtree,
        target_database_group_id=test_target_database_group["id"],
        target_id=test_target["id"],
        template_assessment_id=test_template_assessment["id"],
        template_baseline_assessment_id=test_template_baseline_assessment["id"])
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str target_database_group_id: A filter to return the target database group that matches the specified OCID.
    :param _builtins.str target_id: A filter to return only items related to a specific target OCID.
    :param _builtins.str template_assessment_id: The OCID of the security assessment of type TEMPLATE.
    :param _builtins.str template_baseline_assessment_id: The OCID of the security assessment of type TEMPLATE_BASELINE.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['targetDatabaseGroupId'] = target_database_group_id
    __args__['targetId'] = target_id
    __args__['templateAssessmentId'] = template_assessment_id
    __args__['templateBaselineAssessmentId'] = template_baseline_assessment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSecurityAssessmentTemplateAssociationAnalytics:getSecurityAssessmentTemplateAssociationAnalytics', __args__, opts=opts, typ=GetSecurityAssessmentTemplateAssociationAnalyticsResult)
    return __ret__.apply(lambda __response__: GetSecurityAssessmentTemplateAssociationAnalyticsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        target_database_group_id=pulumi.get(__response__, 'target_database_group_id'),
        target_id=pulumi.get(__response__, 'target_id'),
        template_assessment_id=pulumi.get(__response__, 'template_assessment_id'),
        template_association_analytics_collections=pulumi.get(__response__, 'template_association_analytics_collections'),
        template_baseline_assessment_id=pulumi.get(__response__, 'template_baseline_assessment_id')))
